<?php

defined('BASEPATH') OR exit('No direct script access allowed');
date_default_timezone_set('Asia/Kolkata');
require_once(APPPATH."libraries/razorpay/razorpay-php/Razorpay.php");
        use Razorpay\Api\Api;
        use Razorpay\Api\Errors\SignatureVerificationError;

class Json extends MY_Controller {

    function __construct() {
        parent::__construct();

        $this->load->model('auth_model');
        $this->load->model('json_model');
        $this->load->model('transfer_request_model');
        $this->load->model('users_model');
        $this->load->helper('notification_helper');
       
    }

    public function login() {
        try {
            $mobile_no = $this->input->post('mobile');
            $password = $this->input->post('password');
            $token = $this->input->post('token');
            $ftoken = $this->input->post('ftoken');

            $this->db->select('*');
            $this->db->where(['token' => $token, 'status' => 1]);
            $queryt = $this->db->get('apptoken');
            $num_rowt = $queryt->num_rows();
            if ($num_rowt > 0) {

                $check_mobile = $this->auth_model->CheckMobileExits($mobile_no);
                if ($check_mobile != "") {

                    $send_data = array(
                        'mobile_no' => $mobile_no,
                        'password' => md5($password)
                    );

                    $login_data = $this->auth_model->RegisterLogin($send_data);
                    if ($login_data) {


                        $arrData = array(
                            'ftoken' => $ftoken,
                        );
                        //echo "<pre>";print_r($arrData);exit;
                        $this->db->where(['mobile_no' => $mobile_no]);
                        $this->db->update('register_users', $arrData);
                        $data[] = array(
                            "status" => 1,
                            "msg" => "Loggedin Successfully",
                            "user_id" => $login_data->id,
                            "name" => $login_data->first_name,
                            "email" => $login_data->email,
                            "mobile_no" => $login_data->mobile_no,
                            "uid" => $login_data->uid,
                        );
                    } else {
                        $data[] = array(
                            "status" => '0',
                            "msg" => "Password Incorrect"
                        );
                    }
                } else {
                    $data[] = array(
                        "status" => '0',
                        "msg" => "Mobile Number Not Register!",
                    );
                }
            } else {
                $data[] = array(
                    "status" => '0',
                    "msg" => "Unauthorized User!",
                );
            }
        } catch (Exception $e) {
            $data[] = array(
                "status" => '10',
                "msg" => "Could not register Mobile number. Please try again!",
                'error' => "Error: " . $e->getMessage()
            );
        }
        echo json_encode(array("result" => $data));
    }
    
        public function login_agent() {
        try {
            $mobile_no = $this->input->post('mobile');
            $password = $this->input->post('password');
            $token = $this->input->post('token');
            $ftoken = $this->input->post('ftoken');

            $this->db->select('*');
            $this->db->where(['token' => $token, 'status' => 1]);
            $queryt = $this->db->get('apptoken');
            $num_rowt = $queryt->num_rows();
            if ($num_rowt > 0) {
                $check_mobile = $this->auth_model->CheckAgentMobileExits($mobile_no);
                if ($check_mobile != "") {

                    $send_data = array(
                        'mobile_no' => $mobile_no,
                        'password' => md5($password)
                    );

                    $login_data = $this->auth_model->RegisterAgentLogin($send_data);
                    if ($login_data) {
                        $arrData = array(
                            'ftoken' => $ftoken,
                        );
                        $this->db->where(['mobile_no' => $mobile_no]);
                        $this->db->update('register_agent', $arrData);
                        $data[] = array(
                            "status" => 1,
                            "msg" => "Loggedin Successfully",
                            "user_id" => $login_data->id,
                            "name" => $login_data->fname,
                            "email" => $login_data->email,
                            "mobile_no" => $login_data->mobile_no,
                            "uid" => $login_data->uid,
                        );
                    } else {
                        $data[] = array(
                            "status" => '0',
                            "msg" => "Password Incorrect"
                        );
                    }
                } else {
                    $data[] = array(
                        "status" => '0',
                        "msg" => "Mobile Number Not Register!",
                    );
                }
            } else {
                $data[] = array(
                    "status" => '0',
                    "msg" => "Unauthorized User!",
                );
            }
        } catch (Exception $e) {
            $data[] = array(
                "status" => '10',
                "msg" => "Could not register Mobile number. Please try again!",
                'error' => "Error: " . $e->getMessage()
            );
        }
        echo json_encode(array("result" => $data));
    }

    public function addregister() {
        try {
            $data = array();
            $post_data = $this->input->post();
            $id = $post_data['id'];
            $ref = $post_data['refno'];
            $otp = $post_data['otp'];
            $token = $post_data['token'];

            $this->db->select('*');
            $this->db->where(['token' => $token, 'status' => 1]);
            $queryt = $this->db->get('apptoken');
            $num_rowt = $queryt->num_rows();
            if ($num_rowt > 0) {

                if ($otp) {
                    $this->db->select('*');
                    $this->db->where(['id' => $id, 'ref_no' => $ref, 'otp' => $otp,]);
                    $query = $this->db->get('register_otp');
                    $num_row = $query->num_rows();
                    if ($num_row > 0) {
                        $res = $query->result_array();
                        $mobile = $res[0]['mobile'];
                        $name = $res[0]['name'];
                        $email = $res[0]['email'];
                        $passsword = $res[0]['password'];
                        $uid = $res[0]['uid'];
                        $randomString = mt_rand(100000, 999999);
                        $sendData = array(
                            'first_name' => $name,
                            'last_name' => '',
                            'mobile_no' => $mobile,
                            'email' => $email,
                            'password' => md5($passsword),
                            'plain_text' => $passsword,
                            'referral_no' => $randomString,
                            'uid' => $uid,
                            'wallet' => 0,
                            'referral_wallet' => '0'
                        );
                        $saved_data = $this->auth_model->RegisterUsers($sendData);
                        if ($saved_data) {

                            $data[] = array(
                                "status" => '1',
                                "msg" => "Register Successfully",
                            );
                        } else {
                            $data[] = array(
                                "status" => '0',
                                "msg" => "Something Went To Wrong!",
                            );
                        }
                    } else {
                        $data[] = array(
                            "status" => '0',
                            "msg" => "OTP Wrong!",
                        );
                    }
                } else {
                    $data[] = array(
                        "status" => '0',
                        "msg" => "Enter otp!",
                    );
                }
            } else {
                $data[] = array(
                    "status" => '0',
                    "msg" => "Unauthorized User!",
                );
            }
        } catch (Exception $e) {
            $data[] = array(
                "status" => '10',
                "msg" => "Could not register Mobile number. Please try again!",
                'error' => "Error: " . $e->getMessage()
            );
        }
        echo json_encode(array("result" => $data));
    }
    
        public function addregister_agent() {
        try {
            $data = array();
            $post_data = $this->input->post();
            $id = $post_data['id'];
            $ref = $post_data['refno'];
            $otp = $post_data['otp'];
            $token = $post_data['token'];

            $this->db->select('*');
            $this->db->where(['token' => $token, 'status' => 1]);
            $queryt = $this->db->get('apptoken');
            $num_rowt = $queryt->num_rows();
            if ($num_rowt > 0) {

                if ($otp) {
                    $this->db->select('*');
                    $this->db->where(['id' => $id, 'ref_no' => $ref, 'otp' => $otp,]);
                    $query = $this->db->get('register_agent_otp');
                    $num_row = $query->num_rows();
                    if ($num_row > 0) {
                        $res = $query->result_array();
                        $mobile = $res[0]['mobile'];
                        $name = $res[0]['name'];
                        $email = $res[0]['email'];
                        $passsword = $res[0]['password'];
                        $uid = $res[0]['uid'];
                        $randomString = mt_rand(100000, 999999);
                        
                        $sign_img = base64_decode($this->input->post("img"));
                        if ($sign_img != '') {
                            $si_img = strtolower($mobile);
                            $filename_sign = $si_img . '.' . 'png';
                            $path1 = 'assets/uploads/agent_sign/';
                            file_put_contents($path1 . $filename_sign, $sign_img);
                        }
                        
                        $sendData = array(
                            'first_name' => $name,
                            'last_name' => '',
                            'mobile_no' => $mobile,
                            'email' => $email,
                            'password' => md5($passsword),
                            'plain_text' => $passsword,
                            'referral_no' => $randomString,
                            'uid' => $uid,
                            'wallet' => 0,
                            'referral_wallet' => '0',
                            'fname' => $this->input->post('fname'),
                            'gst_no' => $this->input->post('gstno'),
                            'sign' => $filename_sign
                        );
                        $saved_data = $this->auth_model->RegisterAgent($sendData);
                        if ($saved_data) {
                            $insert_data = array(
                                'agent_id' => $saved_data
                                );
                                $AddAgent_balance = $this->auth_model->AddAgent_balance($insert_data);
                                
                            $data[] = array(
                                "status" => '1',
                                "msg" => "Register Successfully",
                            );
                        } else {
                            $data[] = array(
                                "status" => '0',
                                "msg" => "Something Went To Wrong!",
                            );
                        }
                    } else {
                        $data[] = array(
                            "status" => '0',
                            "msg" => "OTP Wrong!",
                        );
                    }
                } else {
                    $data[] = array(
                        "status" => '0',
                        "msg" => "Enter otp!",
                    );
                }
            } else {
                $data[] = array(
                    "status" => '0',
                    "msg" => "Unauthorized User!",
                );
            }
        } catch (Exception $e) {
            $data[] = array(
                "status" => '10',
                "msg" => "Could not register Mobile number. Please try again!",
                'error' => "Error: " . $e->getMessage()
            );
        }
        echo json_encode(array("result" => $data));
    }

    public function register() {
        try {
            $data = array();
            $post_data = $this->input->post();
            //echo "<pre>";print_r($post_data);exit;
            $mobile = $post_data['mobile'];
            $token = $post_data['token'];
            $this->db->select('*');
            $this->db->where(['token' => $token, 'status' => 1]);
            $queryt = $this->db->get('apptoken');
            $num_rowt = $queryt->num_rows();
            if ($num_rowt > 0) {
                $check_mobile = $this->auth_model->CheckMobileExits($post_data['mobile']);
                if ($check_mobile != 1) {
                    $randomString = rand(111111, 999999);
                    $otp = rand(1111, 9999);
                    $randomString1 = $mobile . '' . $randomString;
                    if ($post_data['name']) {
                        if ($post_data['email']) {
                            if ($post_data['password']) {
                                $this->db->select('*');
                                $this->db->where(['mobile' => $mobile]);
                                $query = $this->db->get('register_otp');
                                $num_row = $query->num_rows();
                                if ($num_row == 0) {
                                    $sendData = array(
                                        'name' => $post_data['name'],
                                        'mobile' => $post_data['mobile'],
                                        'email' => $post_data['email'],
                                        'password' => $post_data['password'],
                                        'uid' => $randomString1,
                                        'ref_no' => $randomString,
                                        'otp' => $otp,
                                        'datee' => date("Y-m-d")
                                    );
                                    $saved_data = $this->db->insert('register_otp', $sendData);
                                    $lastid = $this->db->insert_id();
                                    if ($lastid) {


                                        $api_url = "https://2factor.in/API/R1/?module=TRANS_SMS&apikey=938b2f31-2485-11ee-addf-0200cd936042&to=$mobile&from=PAYMYC&templatename=forgot+password&var1=$otp";
                                        $ch = curl_init($api_url);
                                        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "GET");
                                        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                                        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/xml'));


                                        $result = curl_exec($ch);

                                        $data[] = array(
                                            "status" => '1',
                                            "refno" => $randomString,
                                            "id" => $lastid,
                                            "msg" => "Inserted Successfully",
                                        );
                                    } else {
                                        $data[] = array(
                                            "status" => '0',
                                            "msg" => "Something Went To Wrong!",
                                        );
                                    }
                                } else {
                                    $sendData = array(
                                        'name' => $post_data['name'],
                                        'email' => $post_data['email'],
                                        'password' => $post_data['password'],
                                        'uid' => $randomString1,
                                        'ref_no' => $randomString,
                                        'otp' => $otp,
                                        'datee' => date("Y-m-d")
                                    );
                                    $this->db->where('mobile', $mobile);
                                    $this->db->update('register_otp', $sendData);



                                    $api_url = "https://2factor.in/API/R1/?module=TRANS_SMS&apikey=938b2f31-2485-11ee-addf-0200cd936042&to=$mobile&from=PAYMYC&templatename=forgot+password&var1=$otp";
                                    $ch = curl_init($api_url);
                                    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "GET");
                                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                                    curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/xml'));


                                    $result = curl_exec($ch);


                                    $res = $query->result_array();
                                    $lastid = $res[0]['id'];
                                    $data[] = array(
                                        "status" => '1',
                                        "refno" => $randomString,
                                        "id" => $lastid,
                                        "msg" => "Updated Successfully",
                                    );
                                }
                            } else {
                                $data[] = array(
                                    "status" => '0',
                                    "msg" => "Enter Password!",
                                );
                            }
                        } else {
                            $data[] = array(
                                "status" => '0',
                                "msg" => "Enter Email!",
                            );
                        }
                    } else {
                        $data[] = array(
                            "status" => '0',
                            "msg" => "Enter Name",
                        );
                    }
                } else {
                    $data[] = array(
                        "status" => '0',
                        "msg" => "Mobile Number already Register!",
                    );
                }
            } else {
                $data[] = array(
                    "status" => '0',
                    "msg" => "Unauthorized User!",
                );
            }
        } catch (Exception $e) {
            $data[] = array(
                "status" => '10',
                "msg" => "Could not register Mobile number. Please try again!",
                'error' => "Error: " . $e->getMessage()
            );
        }
        echo json_encode(array("result" => $data));
    }
    
    public function register_agent() {
        try {
            $data = array();
            $post_data = $this->input->post();
            //echo "<pre>";print_r($post_data);exit;
            $mobile = $post_data['mobile'];
            $token = $post_data['token'];
            $this->db->select('*');
            $this->db->where(['token' => $token, 'status' => 1]);
            $queryt = $this->db->get('apptoken');
            $num_rowt = $queryt->num_rows();
            if ($num_rowt > 0) {
                $check_mobile = $this->auth_model->CheckAgentMobileExits($post_data['mobile']);
                if ($check_mobile != 1) {
                    $randomString = rand(111111, 999999);
                    $otp = rand(1111, 9999);
                    $randomString1 = $mobile . '' . $randomString;
                    if ($post_data['name']) {
                        if ($post_data['email']) {
                            if ($post_data['password']) {
                                $this->db->select('*');
                                $this->db->where(['mobile' => $mobile]);
                                $query = $this->db->get('register_agent_otp');
                                $num_row = $query->num_rows();
                                if ($num_row == 0) {
                                    $sendData = array(
                                        'name' => $post_data['name'],
                                        'mobile' => $post_data['mobile'],
                                        'email' => $post_data['email'],
                                        'password' => $post_data['password'],
                                        'uid' => $randomString1,
                                        'ref_no' => $randomString,
                                        'otp' => $otp,
                                        'datee' => date("Y-m-d")
                                    );
                                    $saved_data = $this->db->insert('register_agent_otp', $sendData);
                                    $lastid = $this->db->insert_id();
                                    if ($lastid) {
                                        $api_url = "https://2factor.in/API/V1/938b2f31-2485-11ee-addf-0200cd936042/SMS/$mobile/$otp/OTP1";
                                        $ch = curl_init($api_url);
                                        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "GET");
                                        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                                        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/xml'));
                                        $result = curl_exec($ch);

                                        $data[] = array(
                                            "status" => '1',
                                            "refno" => $randomString,
                                            "id" => $lastid,
                                            "msg" => "Inserted Successfully",
                                        );
                                    } else {
                                        $data[] = array(
                                            "status" => '0',
                                            "msg" => "Something Went To Wrong!",
                                        );
                                    }
                                } else {
                                    $sendData = array(
                                        'name' => $post_data['name'],
                                        'email' => $post_data['email'],
                                        'password' => $post_data['password'],
                                        'uid' => $randomString1,
                                        'ref_no' => $randomString,
                                        'otp' => $otp,
                                        'datee' => date("Y-m-d")
                                    );
                                    $this->db->where('mobile', $mobile);
                                    $this->db->update('register_agent_otp', $sendData);
                                    
                                    $api_url = "https://2factor.in/API/V1/938b2f31-2485-11ee-addf-0200cd936042/SMS/$mobile/$otp/OTP1";
                                    $ch = curl_init($api_url);
                                    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "GET");
                                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                                    curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/xml'));
                                    $result = curl_exec($ch);
                                    $res = $query->result_array();
                                    $lastid = $res[0]['id'];
                                    $data[] = array(
                                        "status" => '1',
                                        "refno" => $randomString,
                                        "id" => $lastid,
                                        "msg" => "Updated Successfully",
                                    );
                                }
                            } else {
                                $data[] = array(
                                    "status" => '0',
                                    "msg" => "Enter Password!",
                                );
                            }
                        } else {
                            $data[] = array(
                                "status" => '0',
                                "msg" => "Enter Email!",
                            );
                        }
                    } else {
                        $data[] = array(
                            "status" => '0',
                            "msg" => "Enter Name",
                        );
                    }
                } else {
                    $data[] = array(
                        "status" => '0',
                        "msg" => "Mobile Number already Register!",
                    );
                }
            } else {
                $data[] = array(
                    "status" => '0',
                    "msg" => "Unauthorized User!",
                );
            }
        } catch (Exception $e) {
            $data[] = array(
                "status" => '10',
                "msg" => "Could not register Mobile number. Please try again!",
                'error' => "Error: " . $e->getMessage()
            );
        }
        echo json_encode(array("result" => $data));
    }

    public function service_check() {
        try {
            $data = array();
            $post_data = $this->input->post();
            //echo "<pre>";print_r($post_data);exit;
            $uid = $post_data['uid'];
            $token = $post_data['token'];
            $ftoken = $post_data['ftoken'];
            $this->db->select('*');
            $this->db->where(['token' => $token, 'status' => 1]);
            $queryt = $this->db->get('apptoken');
            $num_rowt = $queryt->num_rows();
            if ($num_rowt > 0) {
                $this->db->select('*');
                $this->db->where(['ftoken' => $ftoken, 'uid' => $uid]);
                $query = $this->db->get('register_users');
                $num_row = $query->num_rows();
                if ($num_row > 0) {
                    $result = $query->result_array();
                    $sta = $result[0]['user_status'];
                    $auto_transaction_status = $result[0]['user_auto_transaction_status'];
                    $post_data = $result[0]['id'];
                    
                    $this->db->select('*');
                    $query_key = $this->db->get('razorpay_key');
                    $num_rows_key = $query_key->result_array();

                    $this->db->select('*');
                    $querynew = $this->db->get('apiService');
                    $num_rowsnew = $querynew->result_array();
                    // print_r($num_rowsnew);
                    // if($num_rowsnew[6]['status']==0){
                    //     $key=$num_rows_key[0]['razorpay_balue_key'];
                    //     $secret=$num_rows_key[0]['razorpay_balue_secret'];
                    // }elseif($num_rowsnew[6]['status']==1){
                    //     $key=$num_rows_key[0]['razorpay_paymychoice_key'];
                    //     $secret=$num_rows_key[0]['razorpay_paymychoice_secret'];
                    // }else{
                    //     $key="";
                    //     $secret="";
                    // }
                    
                    if($num_rowsnew[6]['status']==1){
                        $key=$num_rows_key[0]['razorpay_paymychoice_key'];
                        $secret=$num_rows_key[0]['razorpay_paymychoice_secret'];
                    }elseif($num_rowsnew[7]['status']==1){
                        $key=$num_rows_key[0]['razorpay_balue_key'];
                        $secret=$num_rows_key[0]['razorpay_balue_secret'];
                    }elseif($num_rowsnew[8]['status']==1){
                        $key=$num_rows_key[0]['razorpay_sun_key'];
                        $secret=$num_rows_key[0]['razorpay_sun_secret'];
                    }elseif($num_rowsnew[9]['status']==1){
                        $key=$num_rows_key[0]['razorpay_surya_key'];
                        $secret=$num_rows_key[0]['razorpay_surya_secret'];
                    }else{
                        $key=$num_rows_key[0]['razorpay_paymychoice_key'];
                        $secret=$num_rows_key[0]['razorpay_paymychoice_secret'];
                    }

                    $this->db->select('*');
                    $this->db->where('id','1');
                    $querynews = $this->db->get('latest_news');
                    $result_news = $querynews->row();

                    $daily = $this->json_model->daily_transaction_amount($post_data);
                    $monthly = $this->json_model->transaction_amount($post_data);


                    $data[] = array(
                        "status" => '1',
                        "user_staus" => $sta,
                        "referral_code" => $result[0]['referral_no'],
                        "rbal" =>  round($result[0]['referral_wallet']),
                        "wbal" =>  round($result[0]['wallet']),
                        "auto_transaction_status" => $auto_transaction_status,
                        "instant_status" => $num_rowsnew[0]['status'],
                        "tone_status" => $num_rowsnew[1]['status'],
                        "ttwo_status" => $num_rowsnew[2]['status'],
                        "app_version" => "1.86",
                        "maintenance" => $num_rowsnew[3]['status'],
                        //"easebuzz" => $num_rowsnew[4]['status'],
                        //"tstatus" => $num_rowsnew[5]['status'],
                        //"offer_status" => $num_rowsnew[6]['status'],
                        "amex_status" => $num_rowsnew[4]['status'],
                        "rzp" => $num_rowsnew[5]['status'],
                        "cfree" => $num_rowsnew[11]['status'],
                        "offer_msg" => $result_news->news,
                        "m_transation" => ($monthly->amount) ? $monthly->amount : "0",
                        "d_transation" => ($daily->amount) ? $daily->amount : "0",
                        "takaone" => $result_news->instant_settlement,
                        "takatwo" => $result_news->t1_settlement,
                        "takathree" => $result_news->t2_settlement,
                        "referral_amount" => $result_news->referral_amount,
                        "normal_card" => $result_news->normal_card,
                        "amex_card" => $result_news->amex_card,
                        "corporate_business_card" => $result_news->corporate_business_card,
                        "emi_convert" => $result_news->emi_convert,
                        "wallet_card" => $result_news->wallet_charge,
                        "msg" => "Successfully",
                        "r_key"=>$key,
                        "r_secret"=>$secret
                    );
                } else {
                    $data[] = array(
                        "status" => '0',
                        "msg" => "Unauthorized User!",
                    );
                }
            } else {
                $data[] = array(
                    "status" => '0',
                    "msg" => "Unauthorized User!",
                );
            }
        } catch (Exception $e) {
            $data[] = array(
                "status" => '10',
                "msg" => "Could not user. Please try again!",
                'error' => "Error: " . $e->getMessage()
            );
        }
        echo json_encode(array("result" => $data));
    }



 public function service_check_agent() {
        try {
            $data = array();
            $post_data = $this->input->post();
            //echo "<pre>";print_r($post_data);exit;
            $uid = $post_data['uid'];
            $token = $post_data['token'];
            $ftoken = $post_data['ftoken'];
            $this->db->select('*');
            $this->db->where(['token' => $token, 'status' => 1]);
            $queryt = $this->db->get('apptoken');
            $num_rowt = $queryt->num_rows();
            if ($num_rowt > 0) {
                $this->db->select('*');
                $this->db->where(['ftoken' => $ftoken, 'uid' => $uid]);
                $query = $this->db->get('register_agent');
                $num_row = $query->num_rows();
                if ($num_row > 0) {
                    $result = $query->result_array();
                    $sta = $result[0]['user_status'];
                    $auto_transaction_status = $result[0]['charges'];
                    $post_data = $result[0]['id'];
                    
                    $this->db->select('current_balance');
                    $this->db->where('id',$post_data);
                    $query_balance = $this->db->get('agent_account');
                    $agent_balance = $query_balance->row();
                    
                    
                    $this->db->select('status');
                    $this->db->where('id',$post_data);
                    $query_balance_status = $this->db->get('agent_account');
                    $agent_balance_status = $query_balance_status->row();
                    
                    
                    $this->db->select('*');
                    $query_key = $this->db->get('razorpay_key');
                    $num_rows_key = $query_key->result_array();

                    $this->db->select('*');
                    $querynew = $this->db->get('agentApiService');
                    $num_rowsnew = $querynew->result_array();
                    // print_r($num_rowsnew);
                    // if($num_rowsnew[2]['status']==0){
                    //     $key=$num_rows_key[0]['razorpay_balue_key'];
                    //     $secret=$num_rows_key[0]['razorpay_balue_secret'];
                    // }elseif($num_rowsnew[2]['status']==1){
                    //     $key=$num_rows_key[0]['razorpay_paymychoice_key'];
                    //     $secret=$num_rows_key[0]['razorpay_paymychoice_secret'];
                    // }else{
                        $key="NA";
                        $secret="NA";
                    // }
                    
                    $this->db->select('*');
                    $queryagentServiceApi = $this->db->get('agentServiceApi');
                    $num_queryagentServiceApi = $queryagentServiceApi->result_array();
                    
                    $this->db->select('*');
                    $querynew_latest = $this->db->get('latest_news_agent');
                    $num_rowsnew_latest = $querynew_latest->result_array();

                    $data[] = array(
                        "status" => '1',
                        "user_staus" => $sta,
                        "charges" => $auto_transaction_status,
                        "amex_charges" => $result[0]['amex_charges'],
                        "bussiness_charge" => $result[0]['bussiness_charge'],
                        "ukyc" => $result[0]['ukyc'],
                        "app_version" => "1.0",
                        "link_gateway" => $num_rowsnew[1]['status'],
                        "maintenance" => $num_rowsnew[0]['status'],
                        
                        "cfone" => $num_rowsnew[7]['status'],
                        "cftwo" => $num_rowsnew[8]['status'],
                        
                        "ptm" => $num_rowsnew[9]['status'],
                        "p_condition" => $num_rowsnew[10]['status'],
                        
                         "cf2" => "1",
                         
                         "wbghan" => "r",
                        
                        "msg" => "Successfully",
                        "mini_charges"=>$num_rowsnew_latest[0]['min_link_trans'],
                        "r_key"=>$key,
                        "r_secret"=>$secret,
                        "main_wallet" => $result[0]['main_wallet'],
                        "agent_wallet" => $agent_balance->current_balance,
                        "agent_wallet_status" => $agent_balance_status->status,
                        "new_normal_card"  => $num_queryagentServiceApi[0]['status'],
                         "new_amax_card"  => $num_queryagentServiceApi[1]['status'],
                         "new_cb_card"  => $num_queryagentServiceApi[2]['status'],
                        "new_app_main"  => $num_queryagentServiceApi[3]['status'],
                        "new_wire_ac"  => $num_queryagentServiceApi[4]['status'],
                        "new_without_amt_link"  => $num_queryagentServiceApi[5]['status'],
                        "pg_wallet"  => $num_queryagentServiceApi[6]['status'],
                        
                         "wb_api"  => $num_queryagentServiceApi[7]['status'],
                         
                         "bene_verify"  =>"https://tpkfintechsolutions.com/adminP/json/verify_bene_agent",
                        
                        "hold_bal" => $result[0]['hold_balance'],
                        
                    );
                } else {
                    $data[] = array(
                        "status" => '0',
                        "msg" => "Unauthorized User!",
                    );
                }
            } else {
                $data[] = array(
                    "status" => '0',
                    "msg" => "Unauthorized User!",
                );
            }
        } catch (Exception $e) {
            $data[] = array(
                "status" => '10',
                "msg" => "Could not user. Please try again!",
                'error' => "Error: " . $e->getMessage()
            );
        }
        echo json_encode(array("result" => $data));
    }



    public function forgot_pass_otp() {
        try {
            $data = array();
            $post_data = $this->input->post();
            //echo "<pre>";print_r($post_data);exit;
            $mobile = $post_data['mobile'];
            $token = $post_data['token'];
            $this->db->select('*');
            $this->db->where(['token' => $token, 'status' => 1]);
            $queryt = $this->db->get('apptoken');
            $num_rowt = $queryt->num_rows();
            if ($num_rowt > 0) {
                $check_mobile = $this->auth_model->CheckMobileExits($post_data['mobile']);
                if ($check_mobile == 1) {
                    $randomString = rand(111111, 999999);
                    $otp = rand(1111, 9999);
                    $randomString1 = $mobile . '' . $randomString;



                    $this->db->select('*');
                    $this->db->where(['mobile' => $mobile]);
                    $query = $this->db->get('register_otp');
                    $num_row = $query->num_rows();
                    if ($num_row == 0) {
                        $sendData = array(
                            'mobile' => $post_data['mobile'],
                            'ref_no' => $randomString,
                            'otp' => $otp,
                            'datee' => date("Y-m-d")
                        );
                        $saved_data = $this->db->insert('register_otp', $sendData);
                        $lastid = $this->db->insert_id();
                        if ($lastid) {


                            $api_url = "https://2factor.in/API/R1/?module=TRANS_SMS&apikey=938b2f31-2485-11ee-addf-0200cd936042&to=$mobile&from=PAYMYC&templatename=forgot+password&var1=$otp";
                            $ch = curl_init($api_url);
                            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "GET");
                            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                            curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/xml'));


                            

                            $data[] = array(
                                "status" => '1',
                                "refno" => $randomString,
                                "id" => $lastid,
                                "msg" => "Inserted Successfully",
                            );
                        } else {
                            $data[] = array(
                                "status" => '0',
                                "msg" => "Something Went To Wrong!",
                            );
                        }
                    } else {
                        $sendData = array(
                            'ref_no' => $randomString,
                            'otp' => $otp,
                            'datee' => date("Y-m-d")
                        );
                        $this->db->where('mobile', $mobile);
                        $this->db->update('register_otp', $sendData);



                        $api_url = "https://2factor.in/API/R1/?module=TRANS_SMS&apikey=938b2f31-2485-11ee-addf-0200cd936042&to=$mobile&from=PAYMYC&templatename=forgot+password&var1=$otp";
                        $ch = curl_init($api_url);
                        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "GET");
                        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/xml'));


                        $result = curl_exec($ch);


                        $res = $query->result_array();
                        $lastid = $res[0]['id'];
                        $data[] = array(
                            "status" => '1',
                            "refno" => $randomString,
                            "id" => $lastid,
                            "msg" => "Updated Successfully",
                        );
                    }
                } else {
                    $data[] = array(
                        "status" => '0',
                        "msg" => "Mobile Number not Register!",
                    );
                }
            } else {
                $data[] = array(
                    "status" => '0',
                    "msg" => "Unauthorized User!",
                );
            }
        } catch (Exception $e) {
            $data[] = array(
                "status" => '10',
                "msg" => "Could not register Mobile number. Please try again!",
                'error' => "Error: " . $e->getMessage()
            );
        }
        echo json_encode(array("result" => $data));
    }

    public function forgot_password() {
        try {
            $data = array();
            $post_data = $this->input->post();
            $id = $post_data['id'];
            $ref = $post_data['refno'];
            $otp = $post_data['otp'];
            $token = $post_data['tokennn'];
            $password = $post_data['passworddd'];

            $this->db->select('*');
            $this->db->where(['token' => $token, 'status' => 1]);
            $queryt = $this->db->get('apptoken');
            $num_rowt = $queryt->num_rows();
            if ($num_rowt > 0) {

                if ($otp) {
                    $this->db->select('*');
                    $this->db->where(['id' => $id, 'ref_no' => $ref, 'otp' => $otp]);
                    $query = $this->db->get('register_otp');
                    $num_row = $query->num_rows();
                    if ($num_row > 0) {
                        $res = $query->result_array();
                        $mobile = $res[0]['mobile'];
                        $name = $res[0]['name'];
                        $email = $res[0]['email'];

                        $uid = $res[0]['uid'];
                        $randomString = substr(md5(time()), 0, 6);
                        $sendData = array(
                            'password' => md5($password),
                            'plain_text' => $password,
                        );
                        $this->db->where(['uid' => $uid, 'mobile_no' => $mobile]);
                        $saved_data = $this->db->update('register_users', $sendData);


                        $data[] = array(
                            "status" => '1',
                            "msg" => "Updated Successfully",
                        );
                    } else {
                        $data[] = array(
                            "status" => '0',
                            "msg" => "OTP Wrong!",
                        );
                    }
                } else {
                    $data[] = array(
                        "status" => '0',
                        "msg" => "Enter otp!",
                    );
                }
            } else {
                $data[] = array(
                    "status" => '0',
                    "msg" => "Unauthorized User!",
                );
            }
        } catch (Exception $e) {
            $data[] = array(
                "status" => '10',
                "msg" => "Could not register Mobile number. Please try again!",
                'error' => "Error: " . $e->getMessage()
            );
        }
        echo json_encode(array("result" => $data));
    }
    
    
    public function forgot_pass_otp_agent() {
        try {
            $data = array();
            $post_data = $this->input->post();
            $mobile = $post_data['mobile'];
            $token = $post_data['token'];
            $this->db->select('*');
            $this->db->where(['token' => $token, 'status' => 1]);
            $queryt = $this->db->get('apptoken');
            $num_rowt = $queryt->num_rows();
            if ($num_rowt > 0) {
                $check_mobile = $this->auth_model->CheckAgentMobileExits($post_data['mobile']);
                if ($check_mobile == 1) {
                    $randomString = rand(111111, 999999);
                    $otp = rand(1111, 9999);
                    $randomString1 = $mobile . '' . $randomString;
                    $this->db->select('*');
                    $this->db->where(['mobile' => $mobile]);
                    $query = $this->db->get('register_agent_otp');
                    $num_row = $query->num_rows();
                    if ($num_row == 0) {
                        $sendData = array(
                            'mobile' => $post_data['mobile'],
                            'ref_no' => $randomString,
                            'otp' => $otp,
                            'datee' => date("Y-m-d")
                        );
                        $saved_data = $this->db->insert('register_agent_otp', $sendData);
                        $lastid = $this->db->insert_id();
                        if ($lastid) {
                            $api_url = "https://2factor.in/API/R1/?module=TRANS_SMS&apikey=938b2f31-2485-11ee-addf-0200cd936042&to=$mobile&from=PAYMYC&templatename=forgot+password&var1=$otp";
                            $ch = curl_init($api_url);
                            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "GET");
                            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                            curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/xml'));
                            $result = curl_exec($ch);

                            $data[] = array(
                                "status" => '1',
                                "refno" => $randomString,
                                "id" => $lastid,
                                "msg" => "Inserted Successfully",
                            );
                        } else {
                            $data[] = array(
                                "status" => '0',
                                "msg" => "Something Went To Wrong!",
                            );
                        }
                    } else {
                        $sendData = array(
                            'ref_no' => $randomString,
                            'otp' => $otp,
                            'datee' => date("Y-m-d")
                        );
                        $this->db->where('mobile', $mobile);
                        $this->db->update('register_agent_otp', $sendData);

                        $api_url = "https://2factor.in/API/R1/?module=TRANS_SMS&apikey=938b2f31-2485-11ee-addf-0200cd936042&to=$mobile&from=PAYMYC&templatename=forgot+password&var1=$otp";
                        $ch = curl_init($api_url);
                        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "GET");
                        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/xml'));
                        $result = curl_exec($ch);

                        $res = $query->result_array();
                        $lastid = $res[0]['id'];
                        $data[] = array(
                            "status" => '1',
                            "refno" => $randomString,
                            "id" => $lastid,
                            "msg" => "Updated Successfully",
                        );
                    }
                } else {
                    $data[] = array(
                        "status" => '0',
                        "msg" => "Mobile Number not Register!",
                    );
                }
            } else {
                $data[] = array(
                    "status" => '0',
                    "msg" => "Unauthorized User!",
                );
            }
        } catch (Exception $e) {
            $data[] = array(
                "status" => '10',
                "msg" => "Could not register Mobile number. Please try again!",
                'error' => "Error: " . $e->getMessage()
            );
        }
        echo json_encode(array("result" => $data));
    }

   

    public function payment_request() {
      
        try {
            $data = array();
            $post_data = $this->input->post();
            $token = $post_data['token'];
            $ftoken = $post_data['ftoken'];
            $taka_name = $post_data['taka_name'];
            // $c_code = $post_data['c_code'];
            

            $this->db->select('*');
            $this->db->where(['token' => $token, 'status' => 1]);
            $queryt = $this->db->get('apptoken');
            $num_rowt = $queryt->num_rows();
            if ($num_rowt > 0) {
                $this->db->select('*');
                $this->db->where(['uid' => $post_data['user_id'], 'ftoken' => $ftoken]);
                $query = $this->db->get('register_users');
                $num_rows = $query->num_rows();
                if ($num_rows > 0) {
                    $re = $query->result_array();
                    $post_data['user_id'] = $re[0]['id'];
                    $mobile_no = $re[0]['mobile_no'];
                    $uid=$re[0]['id'];

                    $check_users = $this->json_model->check_users_block($post_data['user_id']);
                    if ($check_users) {
                        $getUserById = $this->json_model->getUsersById($post_data['user_id']);
                        if ($this->input->post('payment_mode') == "Bank") {
                            
                            $card_image = "";
                            $card_status = 0;
                            $card_address = "";
                            $checkUserRequest = $this->json_model->checkUserRequest($post_data['user_id'],$post_data['card_number']);
                            if($checkUserRequest) {
                                $card_image = $checkUserRequest->card_image;
                                $card_status = $checkUserRequest->card_status;
                                $card_address = $checkUserRequest->card_address;
                            } else {
                                $card_image = "NA";
                                $card_status = 0;
                                $card_address = "NA";
                            }
                            
                            $length = 10;
                            $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
                            $charactersLength = strlen($characters);
                            $randomString = '';
                            for ($i = 0; $i < $length; $i++) {
                                $randomString .= $characters[rand(0, $charactersLength - 1)];
                            }
                            
                            $this->db->select('*');
                            $querynew = $this->db->get('apiService');
                            $num_rowsnew = $querynew->result_array();
                            // print_r($num_rowsnew);
                            // if($num_rowsnew[6]['status']==0){
                            //     $gateway=0;
                            // }elseif($num_rowsnew[6]['status']==1){
                            //     $gateway=1;
                            // }else{
                            //     $gateway="";
                            // }
                            
                            if($num_rowsnew[7]['status']==1){
                                $gateway=0;
                            }elseif($num_rowsnew[6]['status']==1){
                                $gateway=1;
                            }elseif($num_rowsnew[8]['status']==1){
                                $gateway=2;
                            }elseif($num_rowsnew[9]['status']==1){
                                $gateway=3;
                            }else{
                                $gateway=1;
                            }
                            if(isset($post_data['c_code'])){
                                $c_code = $post_data['c_code']; 
                            if(!empty($c_code) && $c_code!="NA"){
                            $query_coopen = $this->db->query("select * from coopen where user_id='$uid' and coopen_code='$c_code' and status='0'");
                            $num_rows_coopen = $query_coopen->num_rows();
                            if ($num_rows_coopen > 0) {
                                $result_coopen = $query_coopen->row();
                                $discount_percentage=$result_coopen->discount_percentage;
                                $service = $post_data['service'] - $discount_percentage;
                                
                                $arrData_status = array(
                                        'status' => "1"
                                        );
                                        //echo "<pre>";print_r($arrData);exit;
                                        $this->db->where(['status' => 0,'user_id'=>$uid, 'coopen_code'=>$c_code]);
                                        $this->db->update('coopen', $arrData_status);
                            }else{
                                $service=$post_data['service'];
                            }
                            $c_code_f=$post_data['c_code'];
                            } else{
                                $service=$post_data['service'];
                                $c_code_f="NA";
                            } }else{
                                $service=$post_data['service'];
                                $c_code_f="NA";
                            }
                            
                            if(!empty($taka_name) && $taka_name!="NA"){
                                $taka_name_f = $taka_name;
                            }else{
                                $taka_name_f = "NA";
                            }
                            
                            $sendData = array(
                                'user_id' => $post_data['user_id'],
                                'ref_no' => $randomString,
                                'amount' => $post_data['amount'],
                                'charge_amount' => $post_data['charge_amount'],
                                'payment_mode' => $post_data['payment_mode'],
                                'account_no' => $post_data['account_no'],
                                'holder_name' => $post_data['holder_name'],
                                'bank_name' => $post_data['bank_name'],
                                'ifsc_code' => $post_data['ifsc_code'],
                                'purpose' => $post_data['purpose'],
                                'address' => $post_data['address'],
                                'service' => $service,
                                'razorpay_trans_id' => $post_data['rid'],
                                'request_date' => date('Y-m-d H:i:s'),
                                'cdate' => date('Y-m-d'),
                                'card_number' => $post_data['card_number'],
                                'payment_channel' => $post_data['payment_channel'],
                                'payment_mode_main' => $post_data['payment_mode_main'],
                                'name_on_card' => $post_data['name_on_card'],
                                'card_image' => $card_image,
                                'card_status' => $card_status,
                                'card_address' => $card_address,
                                'gateway' => $gateway,
                                'taka_name' => $taka_name_f,
                                'coopen_code' => $c_code_f,
                            );
                        } else {
                            $sendData = array(
                                'user_id' => $post_data['user_id'],
                                'amount' => $post_data['amount'],
                                'charge_amount' => $post_data['charge_amount'],
                                'payment_mode' => $post_data['payment_mode'],
                                'purpose' => $post_data['purpose'],
                                'address' => $post_data['address'],
                                'request_date' => date('Y-m-d H:i:s'),
                                'cdate' => date('Y-m-d'),
                                'card_image' => $card_image,
                                'card_status' => $card_status,
                                'card_address' => $card_address,
                            );
                        }
                        
                        $saved_data = $this->json_model->payment_request($sendData);
                        if ($saved_data) {
                            $amt = $post_data['amount'];
                            $api_url = "https://2factor.in/API/R1/?module=TRANS_SMS&apikey=938b2f31-2485-11ee-addf-0200cd936042&to=8939112304&from=PAYMYC&templatename=lead+update+new&var1=$amt";
                            $ch = curl_init($api_url);
                            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "GET");
                            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                            curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/xml'));
                            $result = curl_exec($ch);
                            $api_url = "https://2factor.in/API/R1/?module=TRANS_SMS&apikey=938b2f31-2485-11ee-addf-0200cd936042&to=$mobile_no&from=PAYMYC&templatename=balance+deduct+update&var1=$amt";
                            $ch = curl_init($api_url);
                            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "GET");
                            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                            curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/xml'));

                            $result = curl_exec($ch);

                            $data[] = array(
                                "status" => '1',
                                "msg" => "Request Sent Successfully",
                                "request_id" => "$saved_data"
                            );
                        } else {
                            $data[] = array(
                                "status" => '0',
                                "msg" => "Something Went To Wrong!",
                                 "request_id" => "NA"
                            );
                        }
                    } else {
                        $data[] = array(
                            "status" => '0',
                            "msg" => "Unauthorized User!",
                            "request_id" => "NA"
                        );
                    }
                } else {
                    $data[] = array(
                        "status" => '0',
                        "msg" => "Unauthorized User!",
                        "request_id" => "NA"
                    );
                }
            } else {
                $data[] = array(
                    "status" => '0',
                    "msg" => "Unauthorized User!",
                    "request_id" => "NA"
                );
            }
        } catch (Exception $e) {
            
            $data[] = array(
                "status" => '10',
                "msg" => "Could not request Payment. Please try again!",
                'error' => "Error: " . $e->getMessage()
            );
        }
        echo json_encode(array("result" => $data));
        
        //Auto transaction on 
        
        $autotransaction_status = $re[0]['user_auto_transaction_status'];
        
        if($autotransaction_status == '1' && $taka_name == 'Instant Settlement'){
            $auto_card = $post_data['auto_card'];
            $auto_AMT = $post_data['auto_amt'] - 9.50 ;
            $auto_amt = floatval($auto_AMT);
            $company_commision_percent = $post_data['company_commision_percent'];
            $commistion_amount = $post_data['amount'] * $post_data['company_commision_percent'] / 100;
            
            if ($this->input->post('payment_mode') == "Bank") {
            
                $beneficiary_name = $post_data['holder_name'];
                $account_number = $post_data['account_no'];
                $ifsc_code = $post_data['ifsc_code'];
                
                if($auto_amt > 500000.00){
                    $pay_mode="RTGS";
                }elseif($auto_amt <= 500000.00){
                    $pay_mode="IMPS";
                }else{
                    $pay_mode="IMPS";
                }
                
                if(isset($post_data['c_code'])){
                    $c_code = $post_data['c_code'];
                if(!empty($c_code) && $c_code!="NA"){
                            $query_coopen = $this->db->query("select * from coopen where user_id='$uid' and coopen_code='$c_code' and status='0'");
                            $num_rows_coopen = $query_coopen->num_rows();
                            if ($num_rows_coopen > 0) {
                                $arrData_status = array(
                                        'status' => "1"
                                        );
                                        //echo "<pre>";print_r($arrData);exit;
                                        $this->db->where(['status' => 0,'user_id'=>$uid, 'coopen_code'=>$c_code]);
                                        $this->db->update('coopen', $arrData_status);
                            }
                            $c_code_f=$c_code;
                            }else{
                                $c_code_f="NA";
                            }}else{
                                $c_code_f="NA";
                            }
                            
                $this->db->select('status');
                $this->db->where(['id' => 18]);
                $querynew = $this->db->get('apiService');
                $num_rowsnew = $querynew->result_array();
                
                if($num_rowsnew[0]['status']==1){
                    $keyy="C38AF3551B";
                    $saalt="8E8771ED8B";
                }else{
                    $keyy="";
                    $saalt="";
                }
                            
                $hashvalue = $keyy.'|'.$post_data['account_no'].'|'.$post_data['ifsc_code'].'||'.$randomString.'|'.$auto_amt.'|'.$saalt;
                $hashed_value = hash('sha512', $hashvalue);
                
                $passArray = array(
                    'key' => $keyy,
                    'beneficiary_type' => "bank_account",
                    'beneficiary_name' => $beneficiary_name,
                    'account_number' => $account_number,
                    'ifsc' => $ifsc_code,
                    'upi_handle' => "",
                    'unique_request_number' => $randomString,
                    'payment_mode' => $pay_mode,
                    'amount' => $auto_amt,
                    'email' => "",
                    'phone' => "",
                    'narration' => ""
                );
                
                $encodeArray = json_encode($passArray);
                
                $curl = curl_init();
                curl_setopt_array($curl, array(
                    CURLOPT_URL => 'https://wire.easebuzz.in/api/v1/quick_transfers/initiate/',
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => '',
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => 'POST',
                    CURLOPT_POSTFIELDS => "$encodeArray",
                    CURLOPT_HTTPHEADER => array(
                        'Content-Type: application/json',
                        'Accept: application/json',
                        'Authorization:'.$hashed_value
                    )
                ));

                $response = curl_exec($curl);
                curl_close($curl);
                $jsonDecode = json_decode($response);
                
                if($jsonDecode->success == "true"){
                    $unique_transaction_reference = $jsonDecode->data->transfer_request->unique_transaction_reference;
                    $status = $jsonDecode->data->transfer_request->status;
                    
                    $update_data = array(
                        'amount' => $post_data['amount'],
                        'cash_amount' => "0",
                        'bank_amount' => $auto_amt,
                        'card_type' => $auto_card,
                        'card_bank' => $auto_card,
                        'card_no' => $post_data['card_number'],
                        'card_holder_name' => $post_data['holder_name'],
                        'swipe_machine' => 'Easebuzz',
                        'account_no' => $post_data['account_no'],
                        'holder_name' => $post_data['holder_name'],
                        'bank_name' => $post_data['bank_name'],
                        'ifsc_code' => $post_data['ifsc_code'],
                        'bank_refence_no' => $status.'+'.$unique_transaction_reference,
                        'transferable_amount' => $auto_amt,
                        'company_commistion' => $commistion_amount,
                        'company_commision_percent' => $company_commision_percent,
                        'remark' => 'Auto wire transaction',
                        'debited_date' => date('Y-m-d H:i:s'),
                        'status' => '1',
                        'taka_name' => $taka_name,
                        'coopen_code' => $c_code_f,
                    );
    
                    $this->transfer_request_model->update_trastion_details($update_data, $saved_data);
                }
            }
        }
    
  }
    
    public function callBackRechargeApiKWIK(){
      
    //  https://mitropay.in/adminV2/json/callBackRechargeApiKWIK?payid=#payid&client_id=#client_id&operator_ref=#ref_id&status=#status
        $pay_id = $this->input->get('payid');
        $client_id = $this->input->get('client_id');
        $operator_ref = $this->input->get('operator_ref');
        $status = $this->input->get('status');

        $getRechargeData = $this->json_model->getRechageData($client_id);
        $getUsers = $this->json_model->getUsersById($getRechargeData->user_id);
        if($status == 'SUCCESS') {
            if($getRechargeData){
                if($getRechargeData->status == 'PENDING'){
                    $update = array(
                        'status' => $status,
                        'operator_id' => $operator_ref
                    );
                    $update = $this->json_model->update_rechage_data($update,$client_id);
                    if($update){
                        $title = "Recharge Successful";
                        $message = "Your recharge has been successfully done.";
                        send_notification($getUsers->ftoken,$title,$message);
                       echo 'CallBack Success'; 
                    }
                } else if($getRechargeData->status == 'FAILED'){
                    echo 'Already Failed';
                } else if($getRechargeData->status == 'SUCCESS'){
                    echo 'Already Success';
                }
            
            } else {
                echo 'Data Not Found';
            }
        } else if($status == 'FAILED'){
            if($getRechargeData->status == 'FAILED'){
                    echo 'Already Failed';
            } else {
            $update = array(
                'status' => $status,
                'operator_id' => $operator_ref
            );
            $update = $this->json_model->update_rechage_data($update,$client_id);
            
            if($update) {
                $wallet_history = array(
                    'user_id' => $getRechargeData->user_id,
                    'transation_id' => rand(100000,999999),
                    'opening_balance' => $getUsers->wallet,
                    'credit_balance' => $getRechargeData->amount,
                    'debit_balance' => 0,
                    'closing_balance' => $getUsers->wallet + $getRechargeData->amount,
                    'remark' => "Refund amount of failed Mobile Recharge",
                    'tr_date' => date('Y-m-d')
                    );
                $wallet_transtion = $this->transfer_request_model->wallet_transtion($wallet_history);
                $updateA = array(
        		    'wallet' => $getUsers->wallet + $getRechargeData->amount
        	    );
                $updateWallet= $this->json_model->update_user_photo($updateA,$getUsers->id); 
                $title = "Recharge Failed";
                $message = "Your recharge has been failed and refund successfully done on credit balance.";
                send_notification($getUsers->ftoken,$title,$message);
                echo 'CallBack failed'; 
            }
            }
        }
    }

    public function payment_request_by_admin() {
        try {
            $data = array();
            $post_data = $this->input->post();
                $check_users = $this->json_model->check_users_block($post_data['user_id']);
                if ($check_users) {
                    $getUserById = $this->json_model->getUsersById($post_data['user_id']);

                    if ($this->input->post('payment_mode') == "Bank") {

                        $sendData = array(
                            'user_id' => $post_data['user_id'],
                            'amount' => $post_data['amount'],
                            'charge_amount' => $post_data['charge_amount'],
                            'payment_mode' => $post_data['payment_mode'],
                            'account_no' => $post_data['account_no'],
                            'holder_name' => $post_data['holder_name'],
                            'bank_name' => $post_data['bank_name'],
                            'ifsc_code' => $post_data['ifsc_code'],
                            'purpose' => $post_data['purpose'],
                            'address' => $post_data['address'],
                            'service' => $post_data['service'],
                            'razorpay_trans_id' => $post_data['rid'],
                            'request_date' => date('Y-m-d H:i:s'),
                            'cdate' => date('Y-m-d'),
                            'card_image' => 'NA',
                            'card_status' => '0',
                            'card_address' => 'NA',
                        );
                    } else {
                        $sendData = array(
                            'user_id' => $post_data['user_id'],
                            'amount' => $post_data['amount'],
                            'charge_amount' => $post_data['charge_amount'],
                            'payment_mode' => $post_data['payment_mode'],
                            'purpose' => $post_data['purpose'],
                            'address' => $post_data['address'],
                            'request_date' => date('Y-m-d H:i:s'),
                            'cdate' => date('Y-m-d'),
                            'card_image' => 'NA',
                            'card_status' => '0',
                            'card_address' => 'NA',
                        );
                    }
                    $saved_data = $this->json_model->payment_request($sendData);
                    if ($saved_data) {
                        $data[] = array(
                            "status" => '1',
                            "msg" => "Request Sent Successfully",
                        );
                    } else {
                        $data[] = array(
                            "status" => '0',
                            "msg" => "Something Went To Wrong!",
                        );
                    }
                } else {
                    $data[] = array(
                        "status" => '0',
                        "msg" => "Unauthorized User!",
                    );
                }
            
        } catch (Exception $e) {
            $data[] = array(
                "status" => '10',
                "msg" => "Could not request Payment. Please try again!",
                'error' => "Error: " . $e->getMessage()
            );
        }
        echo json_encode(array("result" => $data));
    }

    public function user_profile() {
        try {
            $data = array();
            $user_id = $this->input->post('user_id');

            $saved_data = $this->json_model->getUsersById($user_id);
            $user_document = $this->json_model->getDocumentsByUserId($user_id);
            if ($user_document) {
                $user_verified = "";
                if ($user_document->pancard_status == "1" && $user_document->adhar_card_front_status == "1" && $user_document->adhar_card_back_status == "1" && $user_document->selfee_image_status == "1") {
                    $user_verified = "1";
                } else {
                    $user_verified = "0";
                }

                if ($saved_data) {
                    $data[] = array(
                        "status" => '1',
                        "name" => $saved_data->first_name . ' ' . $saved_data->last_name,
                        "email" => $saved_data->email,
                        "mobile_no" => $saved_data->mobile_no,
                        'image' => ($saved_data->user_photo) ? base_url('assets/uploads/user_photos/' . $saved_data->user_photo) : "",
                        'amt' => ($saved_data->wallet),
                        'verified' => $user_verified
                    );
                } else {
                    $data[] = array(
                        "status" => '0',
                        "msg" => "Data not available!",
                    );
                }
            } else {
                $data[] = array(
                    "status" => '0',
                    "msg" => "Data not available!",
                );
            }
        } catch (Exception $e) {
            $data[] = array(
                "status" => '10',
                "msg" => "Could not request Payment. Please try again!",
                'error' => "Error: " . $e->getMessage()
            );
        }
        echo json_encode(array("result" => $data));
    }

    public function user_kyc() {
        try {
            $data = array();
            $post_data = $this->input->post();
            $userid = $post_data['user_id'];
            $address = $post_data['address'];
            $this->db->select('*');
            $this->db->where('uid', $userid);
            $q = $this->db->get('register_users');
            $r = $q->result_array();
            $user_id = $r[0]['id'];
            $user_details = $this->json_model->getUsersById($user_id);
            $user_document = $this->json_model->getDocumentsByUserId($user_id);

            if ($this->input->post("type") == "pancard") {

                if ($user_document) {
                    $pancard_img = base64_decode($this->input->post("image"));
                    if ($pancard_img != '') {
                        $pan_img = strtolower($user_details->first_name . '_' . $user_details->last_name . '_' . $user_details->id);
                        $filename_pan = $pan_img . '.' . 'png';
                        $filename_pans = 2;
                        $path1 = 'assets/uploads/pancards/';
                        file_put_contents($path1 . $filename_pan, $pancard_img);
                    }
                    $sendData = array(
                        'user_id' => $user_id,
                        'pancard_image' => $filename_pan,
                        'pancard_status' => $filename_pans,
                        "address" => $address,
                    );
                    $saved_data = $this->json_model->update_user_kyc($sendData);
                    $count_image1 = $this->json_model->getDocumentsByUserId($user_id);
                    if ($saved_data) {
                        $data[] = array(
                            "status" => '1',
                            "msg" => "Documents Updated successfully!",
                            "image1" => ($count_image1->pancard_image) ? $count_image1->pancard_image : "NA",
                            "image2" => ($count_image1->adharcard_front_image) ? $count_image1->adharcard_front_image : "NA",
                            "image3" => ($count_image1->adharcard_back_image) ? $count_image1->adharcard_back_image : "NA",
                            "image4" => ($count_image1->selfee_image) ? $count_image1->selfee_image : "NA",
                        );
                    } else {
                        $data[] = array(
                            "status" => '0',
                            "msg" => "Data not available!",
                        );
                    }
                } else {
                    $pancard_img = base64_decode($this->input->post("image"));
                    if ($pancard_img != '') {
                        $pan_img = strtolower($user_details->first_name . '_' . $user_details->last_name . '_' . $user_details->id);
                        $filename_pan = $pan_img . '.' . 'png';
                        $path1 = 'assets/uploads/pancards/';
                        file_put_contents($path1 . $filename_pan, $pancard_img);
                    }
                    $sendData = array(
                        'user_id' => $user_id,
                        'pancard_image' => $filename_pan,
                        'pancard_status' => 2,
                    );
                    $saved_data = $this->json_model->user_kyc($sendData);
                    $count_image2 = $this->json_model->getDocumentsByUserId($user_id);
                    if ($saved_data) {
                        $data[] = array(
                            "status" => '1',
                            "msg" => "PanCard Uploaded successfully!",
                            "image1" => ($count_image2->pancard_image) ? $count_image2->pancard_image : "NA",
                            "image2" => ($count_image2->adharcard_front_image) ? $count_image2->adharcard_front_image : "NA",
                            "image3" => ($count_image2->adharcard_back_image) ? $count_image2->adharcard_back_image : "NA",
                            "image4" => ($count_image2->selfee_image) ? $count_image2->selfee_image : "NA",
                        );
                    } else {
                        $data[] = array(
                            "status" => '0',
                            "msg" => "Data not available!",
                        );
                    }
                }
            }

            if ($this->input->post("type") == "adhar_front") {
                if ($user_document) {
                    $adharf_img = base64_decode($this->input->post("image"));
                    if ($adharf_img != '') {
                        $adhar_img = strtolower($user_details->first_name . '_' . $user_details->last_name . '_' . 'adharfront' . '_' . $user_details->id);
                        $filename_adharf = $adhar_img . '.' . 'png';
                        $filename_adharfs = 2;
                        $path2 = 'assets/uploads/adharcards/';
                        file_put_contents($path2 . $filename_adharf, $adharf_img);
                    }
                    $sendData = array(
                        'user_id' => $user_id,
                        'adharcard_front_image' => $filename_adharf,
                        'adhar_card_front_status' => $filename_adharfs,
                        "address" => $address,
                    );
                    $saved_data = $this->json_model->update_user_kyc($sendData);
                    $count_image3 = $this->json_model->getDocumentsByUserId($user_id);
                    if ($saved_data) {
                        $data[] = array(
                            "status" => '1',
                            "msg" => "Adhar Card Updated successfully!",
                            "image1" => ($count_image3->pancard_image) ? $count_image3->pancard_image : "NA",
                            "image2" => ($count_image3->adharcard_front_image) ? $count_image3->adharcard_front_image : "NA",
                            "image3" => ($count_image3->adharcard_back_image) ? $count_image3->adharcard_back_image : "NA",
                            "image4" => ($count_image3->selfee_image) ? $count_image3->selfee_image : "NA",
                        );
                    } else {
                        $data[] = array(
                            "status" => '0',
                            "msg" => "Data not available!",
                        );
                    }
                } else {
                    $adharf_img = base64_decode($this->input->post("image"));
                    if ($adharf_img != '') {
                        $adhar_img = strtolower($user_details->first_name . '_' . $user_details->last_name . '_' . 'adharfront' . '_' . $user_details->id);
                        $filename_adharf = $adhar_img . '.' . 'png';
                        $path2 = 'assets/uploads/adharcards/';
                        file_put_contents($path2 . $filename_adharf, $adharf_img);
                    }
                    $sendData = array(
                        'user_id' => $user_id,
                        'adharcard_front_image' => $filename_adharf,
                        'adhar_card_front_status' => 2,
                    );

                    $saved_data = $this->json_model->user_kyc($sendData);
                    $count_image4 = $this->json_model->getDocumentsByUserId($user_id);
                    if ($saved_data) {

                        $data[] = array(
                            "status" => '1',
                            "msg" => "Adhar Card Updated successfully!",
                            "image1" => ($count_image4->pancard_image) ? $count_image4->pancard_image : "NA",
                            "image2" => ($count_image4->adharcard_front_image) ? $count_image4->adharcard_front_image : "NA",
                            "image3" => ($count_image4->adharcard_back_image) ? $count_image4->adharcard_back_image : "NA",
                            "image4" => ($count_image4->selfee_image) ? $count_image4->selfee_image : "NA",
                        );
                    } else {
                        $data[] = array(
                            "status" => '0',
                            "msg" => "Data not available!",
                        );
                    }
                }
            }
            if ($this->input->post("type") == "adhar_back") {
                if ($user_document) {
                    $adharb_img = base64_decode($this->input->post("image"));
                    if ($adharb_img != '') {
                        $adhar_b_img = strtolower($user_details->first_name . '_' . $user_details->last_name . '_' . 'adharback' . '_' . $user_details->id);
                        $filename_adharb = $adhar_b_img . '.' . 'png';
                        $filename_adharbs = 2;
                        $path3 = 'assets/uploads/adharcards/';
                        file_put_contents($path3 . $filename_adharb, $adharb_img);
                    }
                    $sendData = array(
                        'user_id' => $user_id,
                        'adharcard_back_image' => $filename_adharb,
                        'adhar_card_back_status' => $filename_adharbs,
                        "address" => $address,
                    );
                    $saved_data = $this->json_model->update_user_kyc($sendData);
                    $count_image5 = $this->json_model->getDocumentsByUserId($user_id);

                    if ($saved_data) {
                        $data[] = array(
                            "status" => '1',
                            "msg" => "Adhar Card Updated successfully!",
                            "image1" => ($count_image5->pancard_image) ? $count_image5->pancard_image : "NA",
                            "image2" => ($count_image5->adharcard_front_image) ? $count_image5->adharcard_front_image : "NA",
                            "image3" => ($count_image5->adharcard_back_image) ? $count_image5->adharcard_back_image : "NA",
                            "image4" => ($count_image5->selfee_image) ? $count_image5->selfee_image : 'NA'
                        );
                    } else {
                        $data[] = array(
                            "status" => '0',
                            "msg" => "Data not available!",
                        );
                    }
                } else {
                    $adharb_img = base64_decode($this->input->post("image"));
                    if ($adharb_img != '') {
                        $adhar_b_img = strtolower($user_details->first_name . '_' . $user_details->last_name . '_' . 'adharback' . '_' . $user_details->id);
                        $filename_adharb = $adhar_b_img . '.' . 'png';
                        $path3 = 'assets/uploads/adharcards/';
                        file_put_contents($path3 . $filename_adharb, $adharb_img);
                    }
                    $sendData = array(
                        'user_id' => $user_id,
                        'adharcard_back_image' => $filename_adharb,
                        'adhar_card_back_status' => 2,
                    );
                    $saved_data = $this->json_model->user_kyc($sendData);
                    $count_image6 = $this->json_model->getDocumentsByUserId($user_id);

                    if ($saved_data) {
                        $data[] = array(
                            "status" => '1',
                            "msg" => "Adhar Card Updated successfully!",
                            "image1" => ($count_image6->pancard_image) ? $count_image6->pancard_image : "NA",
                            "image2" => ($count_image6->adharcard_front_image) ? $count_image6->adharcard_front_image : "NA",
                            "image3" => ($count_image6->adharcard_back_image) ? $count_image6->adharcard_back_image : "NA",
                            "image4" => ($count_image6->selfee_image) ? $count_image6->selfee_image : "NA",
                        );
                    } else {
                        $data[] = array(
                            "status" => '0',
                            "msg" => "Data not available!",
                        );
                    }
                }
            }
            if ($this->input->post("type") == "selfee") {
                if ($user_document) {
                    $current_add_proof = base64_decode($this->input->post("image"));
                    if ($current_add_proof != '') {
                        $current_add_img = strtolower($user_details->first_name . '_' . $user_details->last_name . '_' . $user_details->id);
                        $filename_current_add = $current_add_img . '.' . 'png';
                        $filename_current_adds = 2;
                        $path4 = 'assets/uploads/selfee/';
                        file_put_contents($path4 . $filename_current_add, $current_add_proof);
                    }
                    $sendData = array(
                        'user_id' => $user_id,
                        'selfee_image' => $filename_current_add,
                        'selfee_image_status' => $filename_current_adds,
                        "address" => $address,
                    );
                    $saved_data = $this->json_model->update_user_kyc($sendData);
                    $count_image7 = $this->json_model->getDocumentsByUserId($user_id);

                    if ($saved_data) {
                        $data[] = array(
                            "status" => '1',
                            "msg" => "Selfee Updated successfully!",
                            "image1" => ($count_image7->pancard_image) ? $count_image7->pancard_image : "NA",
                            "image2" => ($count_image7->adharcard_front_image) ? $count_image7->adharcard_front_image : "NA",
                            "image3" => ($count_image7->adharcard_back_image) ? $count_image7->adharcard_back_image : "NA",
                            "image4" => ($count_image7->selfee_image) ? $count_image7->selfee_image : "NA",
                        );
                    } else {
                        $data[] = array(
                            "status" => '0',
                            "msg" => "Data not available!",
                        );
                    }
                } else {
                    $current_add_proof = base64_decode($this->input->post("image"));
                    if ($current_add_proof != '') {
                        $current_add_img = strtolower($user_details->first_name . '_' . $user_details->last_name . '_' . $user_details->id);
                        $filename_current_add = $current_add_img . '.' . 'png';
                        $path4 = 'assets/uploads/selfee/';
                        file_put_contents($path4 . $filename_current_add, $current_add_proof);
                    }
                    $sendData = array(
                        'user_id' => $user_id,
                        'selfee_image' => $filename_current_add,
                        'selfee_image_status' => 2,
                    );
                    $saved_data = $this->json_model->user_kyc($sendData);
                    $count_image8 = $this->json_model->getDocumentsByUserId($user_id);
                    if ($saved_data) {
                        $data[] = array(
                            "status" => '1',
                            "msg" => "Selfee Updated successfully!",
                            "image1" => ($count_image8->pancard_image) ? $count_image8->pancard_image : "NA",
                            "image2" => ($count_image8->adharcard_front_image) ? $count_image8->adharcard_front_image : "NA",
                            "image3" => ($count_image8->adharcard_back_image) ? $count_image8->adharcard_back_image : "NA",
                            "image4" => ($count_image8->selfee_image) ? $count_image8->selfee_image : "NA",
                        );
                    } else {
                        $data[] = array(
                            "status" => '0',
                            "msg" => "Data not available!",
                        );
                    }
                }
            }
        } catch (Exception $e) {
            $data[] = array(
                "status" => '10',
                "msg" => "Could not request Payment. Please try again!",
                'error' => "Error: " . $e->getMessage()
            );
        }
        echo json_encode(array("result" => $data));
    }
    
    public function agent_user_kyc() {
        try {
            $data = array();
            $post_data = $this->input->post();
            $userid = $post_data['user_id'];
            $address = $post_data['address'];
            $this->db->select('*');
            $this->db->where('uid', $userid);
            $q = $this->db->get('register_agent');
            $r = $q->result_array();
            $user_id = $r[0]['id'];
            $user_details = $this->json_model->getAgentById($user_id);
            $user_document = $this->json_model->getDocumentsByAgentId($user_id);

            if ($this->input->post("type") == "pancard") {

                if ($user_document) {
                    $pancard_img = base64_decode($this->input->post("image"));
                    if ($pancard_img != '') {
                        $pan_img = strtolower($user_details->first_name . '_' . $user_details->last_name . '_' . $user_details->id);
                        $filename_pan = $pan_img . '.' . 'png';
                        $filename_pans = 2;
                        $path1 = 'assets/uploads/agent/pancards/';
                        file_put_contents($path1 . $filename_pan, $pancard_img);
                    }
                    $sendData = array(
                        'user_id' => $user_id,
                        'pancard_image' => $filename_pan,
                        'pancard_status' => $filename_pans,
                        "address" => $address,
                    );
                    $saved_data = $this->json_model->update_agent_kyc($sendData);
                    $count_image1 = $this->json_model->getDocumentsByAgentId($user_id);
                    if ($saved_data) {
                        $data[] = array(
                            "status" => '1',
                            "msg" => "Documents Updated successfully!",
                            "image1" => ($count_image1->pancard_image) ? $count_image1->pancard_image : "NA",
                            "image2" => ($count_image1->adharcard_front_image) ? $count_image1->adharcard_front_image : "NA",
                            "image3" => ($count_image1->adharcard_back_image) ? $count_image1->adharcard_back_image : "NA",
                            "image4" => ($count_image1->cancel_cheque) ? $count_image1->cancel_cheque : "NA",
                            "image5" => ($count_image1->office_in) ? $count_image1->office_in : "NA",
                            "image6" => ($count_image1->office_out) ? $count_image1->office_out : "NA",
                        );
                    } else {
                        $data[] = array(
                            "status" => '0',
                            "msg" => "Data not available!",
                        );
                    }
                } else {
                    $pancard_img = base64_decode($this->input->post("image"));
                    if ($pancard_img != '') {
                        $pan_img = strtolower($user_details->first_name . '_' . $user_details->last_name . '_' . $user_details->id);
                        $filename_pan = $pan_img . '.' . 'png';
                        $path1 = 'assets/uploads/agent/pancards/';
                        file_put_contents($path1 . $filename_pan, $pancard_img);
                    }
                    $sendData = array(
                        'user_id' => $user_id,
                        'pancard_image' => $filename_pan,
                        'pancard_status' => 2,
                    );
                    $saved_data = $this->json_model->agent_kyc($sendData);
                    $count_image2 = $this->json_model->getDocumentsByAgentId($user_id);
                    if ($saved_data) {
                        $data[] = array(
                            "status" => '1',
                            "msg" => "PanCard Uploaded successfully!",
                            "image1" => ($count_image2->pancard_image) ? $count_image2->pancard_image : "NA",
                            "image2" => ($count_image2->adharcard_front_image) ? $count_image2->adharcard_front_image : "NA",
                            "image3" => ($count_image2->adharcard_back_image) ? $count_image2->adharcard_back_image : "NA",
                            "image4" => ($count_image2->cancel_cheque) ? $count_image2->cancel_cheque : "NA",
                            "image5" => ($count_image2->office_in) ? $count_image2->office_in : "NA",
                            "image6" => ($count_image2->office_out) ? $count_image2->office_out : "NA",
                        );
                    } else {
                        $data[] = array(
                            "status" => '0',
                            "msg" => "Data not available!",
                        );
                    }
                }
            }

            if ($this->input->post("type") == "adhar_front") {
                if ($user_document) {
                    $adharf_img = base64_decode($this->input->post("image"));
                    if ($adharf_img != '') {
                        $adhar_img = strtolower($user_details->first_name . '_' . $user_details->last_name . '_' . 'adharfront' . '_' . $user_details->id);
                        $filename_adharf = $adhar_img . '.' . 'png';
                        $filename_adharfs = 2;
                        $path2 = 'assets/uploads/agent/adharcards/';
                        file_put_contents($path2 . $filename_adharf, $adharf_img);
                    }
                    $sendData = array(
                        'user_id' => $user_id,
                        'adharcard_front_image' => $filename_adharf,
                        'adhar_card_front_status' => $filename_adharfs,
                        "address" => $address,
                    );
                    $saved_data = $this->json_model->update_agent_kyc($sendData);
                    $count_image3 = $this->json_model->getDocumentsByAgentId($user_id);
                    if ($saved_data) {
                        $data[] = array(
                            "status" => '1',
                            "msg" => "Adhar Card Updated successfully!",
                            "image1" => ($count_image3->pancard_image) ? $count_image3->pancard_image : "NA",
                            "image2" => ($count_image3->adharcard_front_image) ? $count_image3->adharcard_front_image : "NA",
                            "image3" => ($count_image3->adharcard_back_image) ? $count_image3->adharcard_back_image : "NA",
                            "image4" => ($count_image3->cancel_cheque) ? $count_image3->cancel_cheque : "NA",
                            "image5" => ($count_image3->office_in) ? $count_image3->office_in : "NA",
                            "image6" => ($count_image3->office_out) ? $count_image3->office_out : "NA",
                        );
                    } else {
                        $data[] = array(
                            "status" => '0',
                            "msg" => "Data not available!",
                        );
                    }
                } else {
                    $adharf_img = base64_decode($this->input->post("image"));
                    if ($adharf_img != '') {
                        $adhar_img = strtolower($user_details->first_name . '_' . $user_details->last_name . '_' . 'adharfront' . '_' . $user_details->id);
                        $filename_adharf = $adhar_img . '.' . 'png';
                        $path2 = 'assets/uploads/agent/adharcards/';
                        file_put_contents($path2 . $filename_adharf, $adharf_img);
                    }
                    $sendData = array(
                        'user_id' => $user_id,
                        'adharcard_front_image' => $filename_adharf,
                        'adhar_card_front_status' => 2,
                    );

                    $saved_data = $this->json_model->agent_kyc($sendData);
                    $count_image4 = $this->json_model->getDocumentsByAgentId($user_id);
                    if ($saved_data) {

                        $data[] = array(
                            "status" => '1',
                            "msg" => "Adhar Card Updated successfully!",
                            "image1" => ($count_image4->pancard_image) ? $count_image4->pancard_image : "NA",
                            "image2" => ($count_image4->adharcard_front_image) ? $count_image4->adharcard_front_image : "NA",
                            "image3" => ($count_image4->adharcard_back_image) ? $count_image4->adharcard_back_image : "NA",
                            "image4" => ($count_image4->cancel_cheque) ? $count_image4->cancel_cheque : "NA",
                            "image5" => ($count_image4->office_in) ? $count_image4->office_in : "NA",
                            "image6" => ($count_image4->office_out) ? $count_image4->office_out : "NA",
                        );
                    } else {
                        $data[] = array(
                            "status" => '0',
                            "msg" => "Data not available!",
                        );
                    }
                }
            }
            if ($this->input->post("type") == "adhar_back") {
                if ($user_document) {
                    $adharb_img = base64_decode($this->input->post("image"));
                    if ($adharb_img != '') {
                        $adhar_b_img = strtolower($user_details->first_name . '_' . $user_details->last_name . '_' . 'adharback' . '_' . $user_details->id);
                        $filename_adharb = $adhar_b_img . '.' . 'png';
                        $filename_adharbs = 2;
                        $path3 = 'assets/uploads/agent/adharcards/';
                        file_put_contents($path3 . $filename_adharb, $adharb_img);
                    }
                    $sendData = array(
                        'user_id' => $user_id,
                        'adharcard_back_image' => $filename_adharb,
                        'adhar_card_back_status' => $filename_adharbs,
                        "address" => $address,
                    );
                    $saved_data = $this->json_model->update_agent_kyc($sendData);
                    $count_image5 = $this->json_model->getDocumentsByAgentId($user_id);

                    if ($saved_data) {
                        $data[] = array(
                            "status" => '1',
                            "msg" => "Adhar Card Updated successfully!",
                            "image1" => ($count_image5->pancard_image) ? $count_image5->pancard_image : "NA",
                            "image2" => ($count_image5->adharcard_front_image) ? $count_image5->adharcard_front_image : "NA",
                            "image3" => ($count_image5->adharcard_back_image) ? $count_image5->adharcard_back_image : "NA",
                            "image4" => ($count_image5->cancel_cheque) ? $count_image5->cancel_cheque : 'NA',
                            "image5" => ($count_image5->office_in) ? $count_image5->office_in : "NA",
                            "image6" => ($count_image5->office_out) ? $count_image5->office_out : "NA",
                        );
                    } else {
                        $data[] = array(
                            "status" => '0',
                            "msg" => "Data not available!",
                        );
                    }
                } else {
                    $adharb_img = base64_decode($this->input->post("image"));
                    if ($adharb_img != '') {
                        $adhar_b_img = strtolower($user_details->first_name . '_' . $user_details->last_name . '_' . 'adharback' . '_' . $user_details->id);
                        $filename_adharb = $adhar_b_img . '.' . 'png';
                        $path3 = 'assets/uploads/agent/adharcards/';
                        file_put_contents($path3 . $filename_adharb, $adharb_img);
                    }
                    $sendData = array(
                        'user_id' => $user_id,
                        'adharcard_back_image' => $filename_adharb,
                        'adhar_card_back_status' => 2,
                    );
                    $saved_data = $this->json_model->agent_kyc($sendData);
                    $count_image6 = $this->json_model->getDocumentsByAgentId($user_id);

                    if ($saved_data) {
                        $data[] = array(
                            "status" => '1',
                            "msg" => "Adhar Card Updated successfully!",
                            "image1" => ($count_image6->pancard_image) ? $count_image6->pancard_image : "NA",
                            "image2" => ($count_image6->adharcard_front_image) ? $count_image6->adharcard_front_image : "NA",
                            "image3" => ($count_image6->adharcard_back_image) ? $count_image6->adharcard_back_image : "NA",
                            "image4" => ($count_image6->cancel_cheque) ? $count_image6->cancel_cheque : "NA",
                            "image5" => ($count_image6->office_in) ? $count_image6->office_in : "NA",
                            "image6" => ($count_image6->office_out) ? $count_image6->office_out : "NA",
                        );
                    } else {
                        $data[] = array(
                            "status" => '0',
                            "msg" => "Data not available!",
                        );
                    }
                }
            }
            if ($this->input->post("type") == "cancel_cheque") {
                if ($user_document) {
                    $current_add_proof = base64_decode($this->input->post("image"));
                    if ($current_add_proof != '') {
                        $current_add_img = strtolower($user_details->first_name . '_' . $user_details->last_name . '_' . $user_details->id);
                        $filename_current_add = $current_add_img . '.' . 'png';
                        $filename_current_adds = 2;
                        $path4 = 'assets/uploads/agent/cancel_cheque/';
                        file_put_contents($path4 . $filename_current_add, $current_add_proof);
                    }
                    $sendData = array(
                        'user_id' => $user_id,
                        'cancel_cheque' => $filename_current_add,
                        'cancel_cheque_status' => $filename_current_adds,
                        "address" => $address,
                    );
                    $saved_data = $this->json_model->update_agent_kyc($sendData);
                    $count_image7 = $this->json_model->getDocumentsByAgentId($user_id);

                    if ($saved_data) {
                        $data[] = array(
                            "status" => '1',
                            "msg" => "Selfee Updated successfully!",
                            "image1" => ($count_image7->pancard_image) ? $count_image7->pancard_image : "NA",
                            "image2" => ($count_image7->adharcard_front_image) ? $count_image7->adharcard_front_image : "NA",
                            "image3" => ($count_image7->adharcard_back_image) ? $count_image7->adharcard_back_image : "NA",
                            "image4" => ($count_image7->cancel_cheque) ? $count_image7->cancel_cheque : "NA",
                            "image5" => ($count_image7->office_in) ? $count_image7->office_in : "NA",
                            "image6" => ($count_image7->office_out) ? $count_image7->office_out : "NA",
                        );
                    } else {
                        $data[] = array(
                            "status" => '0',
                            "msg" => "Data not available!",
                        );
                    }
                } else {
                    $current_add_proof = base64_decode($this->input->post("image"));
                    if ($current_add_proof != '') {
                        $current_add_img = strtolower($user_details->first_name . '_' . $user_details->last_name . '_' . $user_details->id);
                        $filename_current_add = $current_add_img . '.' . 'png';
                        $path4 = 'assets/uploads/agent/cancel_cheque/';
                        file_put_contents($path4 . $filename_current_add, $current_add_proof);
                    }
                    $sendData = array(
                        'user_id' => $user_id,
                        'cancel_cheque' => $filename_current_add,
                        'cancel_cheque_status' => 2,
                    );
                    $saved_data = $this->json_model->agent_kyc($sendData);
                    $count_image8 = $this->json_model->getDocumentsByAgentId($user_id);
                    if ($saved_data) {
                        $data[] = array(
                            "status" => '1',
                            "msg" => "Selfee Updated successfully!",
                            "image1" => ($count_image8->pancard_image) ? $count_image8->pancard_image : "NA",
                            "image2" => ($count_image8->adharcard_front_image) ? $count_image8->adharcard_front_image : "NA",
                            "image3" => ($count_image8->adharcard_back_image) ? $count_image8->adharcard_back_image : "NA",
                            "image4" => ($count_image8->cancel_cheque) ? $count_image8->cancel_cheque : "NA",
                            "image5" => ($count_image8->office_in) ? $count_image8->office_in : "NA",
                            "image6" => ($count_image8->office_out) ? $count_image8->office_out : "NA",
                        );
                    } else {
                        $data[] = array(
                            "status" => '0',
                            "msg" => "Data not available!",
                        );
                    }
                }
            }
            if ($this->input->post("type") == "office_in") {
                if ($user_document) {
                    $current_add_proof = base64_decode($this->input->post("image"));
                    if ($current_add_proof != '') {
                        $current_add_img = strtolower($user_details->first_name . '_' . $user_details->last_name . '_' . $user_details->id);
                        $filename_current_add = $current_add_img . '.' . 'png';
                        $filename_current_adds = 2;
                        $path4 = 'assets/uploads/agent/office_in/';
                        file_put_contents($path4 . $filename_current_add, $current_add_proof);
                    }
                    $sendData = array(
                        'user_id' => $user_id,
                        'office_in' => $filename_current_add,
                        'office_in_status' => $filename_current_adds,
                        "address" => $address,
                    );
                    $saved_data = $this->json_model->update_agent_kyc($sendData);
                    $count_image9 = $this->json_model->getDocumentsByAgentId($user_id);

                    if ($saved_data) {
                        $data[] = array(
                            "status" => '1',
                            "msg" => "Selfee Updated successfully!",
                            "image1" => ($count_image9->pancard_image) ? $count_image9->pancard_image : "NA",
                            "image2" => ($count_image9->adharcard_front_image) ? $count_image9->adharcard_front_image : "NA",
                            "image3" => ($count_image9->adharcard_back_image) ? $count_image9->adharcard_back_image : "NA",
                            "image4" => ($count_image9->cancel_cheque) ? $count_image9->cancel_cheque : "NA",
                            "image5" => ($count_image9->office_in) ? $count_image9->office_in : "NA",
                            "image6" => ($count_image9->office_out) ? $count_image9->office_out : "NA",
                        );
                    } else {
                        $data[] = array(
                            "status" => '0',
                            "msg" => "Data not available!",
                        );
                    }
                } else {
                    $current_add_proof = base64_decode($this->input->post("image"));
                    if ($current_add_proof != '') {
                        $current_add_img = strtolower($user_details->first_name . '_' . $user_details->last_name . '_' . $user_details->id);
                        $filename_current_add = $current_add_img . '.' . 'png';
                        $path4 = 'assets/uploads/agent/office_in/';
                        file_put_contents($path4 . $filename_current_add, $current_add_proof);
                    }
                    $sendData = array(
                        'user_id' => $user_id,
                        'office_in' => $filename_current_add,
                        'office_in_status' => 2,
                    );
                    $saved_data = $this->json_model->agent_kyc($sendData);
                    $count_image10 = $this->json_model->getDocumentsByAgentId($user_id);
                    if ($saved_data) {
                        $data[] = array(
                            "status" => '1',
                            "msg" => "Selfee Updated successfully!",
                            "image1" => ($count_image10->pancard_image) ? $count_image10->pancard_image : "NA",
                            "image2" => ($count_image10->adharcard_front_image) ? $count_image10->adharcard_front_image : "NA",
                            "image3" => ($count_image10->adharcard_back_image) ? $count_image10->adharcard_back_image : "NA",
                            "image4" => ($count_image10->cancel_cheque) ? $count_image10->cancel_cheque : "NA",
                            "image5" => ($count_image10->office_in) ? $count_image10->office_in : "NA",
                            "image6" => ($count_image10->office_out) ? $count_image10->office_out : "NA",
                        );
                    } else {
                        $data[] = array(
                            "status" => '0',
                            "msg" => "Data not available!",
                        );
                    }
                }
            }
            if ($this->input->post("type") == "office_out") {
                if ($user_document) {
                    $current_add_proof = base64_decode($this->input->post("image"));
                    if ($current_add_proof != '') {
                        $current_add_img = strtolower($user_details->first_name . '_' . $user_details->last_name . '_' . $user_details->id);
                        $filename_current_add = $current_add_img . '.' . 'png';
                        $filename_current_adds = 2;
                        $path4 = 'assets/uploads/agent/office_out/';
                        file_put_contents($path4 . $filename_current_add, $current_add_proof);
                    }
                    $sendData = array(
                        'user_id' => $user_id,
                        'office_out' => $filename_current_add,
                        'office_out_status' => $filename_current_adds,
                        "address" => $address,
                    );
                    $saved_data = $this->json_model->update_agent_kyc($sendData);
                    $count_image11 = $this->json_model->getDocumentsByAgentId($user_id);

                    if ($saved_data) {
                        $data[] = array(
                            "status" => '1',
                            "msg" => "Selfee Updated successfully!",
                            "image1" => ($count_image11->pancard_image) ? $count_image11->pancard_image : "NA",
                            "image2" => ($count_image11->adharcard_front_image) ? $count_image11->adharcard_front_image : "NA",
                            "image3" => ($count_image11->adharcard_back_image) ? $count_image11->adharcard_back_image : "NA",
                            "image4" => ($count_image11->cancel_cheque) ? $count_image11->cancel_cheque : "NA",
                            "image5" => ($count_image11->office_in) ? $count_image11->office_in : "NA",
                            "image6" => ($count_image11->office_out) ? $count_image11->office_out : "NA",
                        );
                    } else {
                        $data[] = array(
                            "status" => '0',
                            "msg" => "Data not available!",
                        );
                    }
                } else {
                    $current_add_proof = base64_decode($this->input->post("image"));
                    if ($current_add_proof != '') {
                        $current_add_img = strtolower($user_details->first_name . '_' . $user_details->last_name . '_' . $user_details->id);
                        $filename_current_add = $current_add_img . '.' . 'png';
                        $path4 = 'assets/uploads/agent/office_out/';
                        file_put_contents($path4 . $filename_current_add, $current_add_proof);
                    }
                    $sendData = array(
                        'user_id' => $user_id,
                        'office_out' => $filename_current_add,
                        'office_out_status' => 2,
                    );
                    $saved_data = $this->json_model->agent_kyc($sendData);
                    $count_image12 = $this->json_model->getDocumentsByAgentId($user_id);
                    if ($saved_data) {
                        $data[] = array(
                            "status" => '1',
                            "msg" => "Selfee Updated successfully!",
                            "image1" => ($count_image12->pancard_image) ? $count_image12->pancard_image : "NA",
                            "image2" => ($count_image12->adharcard_front_image) ? $count_image12->adharcard_front_image : "NA",
                            "image3" => ($count_image12->adharcard_back_image) ? $count_image12->adharcard_back_image : "NA",
                            "image4" => ($count_image12->cancel_cheque) ? $count_image12->cancel_cheque : "NA",
                            "image5" => ($count_image12->office_in) ? $count_image12->office_in : "NA",
                            "image6" => ($count_image12->office_out) ? $count_image12->office_out : "NA",
                        );
                    } else {
                        $data[] = array(
                            "status" => '0',
                            "msg" => "Data not available!",
                        );
                    }
                }
            }
        } catch (Exception $e) {
            $data[] = array(
                "status" => '10',
                "msg" => "Could not request Payment. Please try again!",
                'error' => "Error: " . $e->getMessage()
            );
        }
        echo json_encode(array("result" => $data));
    }

    public function add_payee() {
        try {
            $data = array();
            $post_data = $this->input->post();


            $this->db->select('*');
            $this->db->where(['uid' => $post_data['user_id']]);
            $query = $this->db->get('register_users');
            $num_rows = $query->num_rows();
            if ($num_rows > 0) {
                $re = $query->result_array();
                $user_id = $re[0]['id'];
            } else {
                $user_id = '';
            }

            $this->db->select('*');
            $this->db->where(['user_id' => $user_id, 'name' => $post_data['name'], 'account_no' => $post_data['account_no']]);
            $querya = $this->db->get('payee_list');
            $num_rowsa = $querya->num_rows();
            // echo $this->db->last_query();exit;
            if ($num_rowsa == 0) {
                $sendData = array(
                    'user_id' => $user_id,
                    'name' => $post_data['name'],
                    'mobile_no' => $post_data['mobile_no'],
                    'bank_name' => $post_data['bank_name'],
                    'ifsc_code' => $post_data['ifsc_code'],
                    'account_no' => $post_data['account_no'],
                    'address' => $post_data['address']
                );

                $saved_data = $this->json_model->Add_Payee($sendData);
                if ($saved_data) {
                    $data[] = array(
                        "status" => '1',
                        "msg" => "Added Successfully",
                    );
                } else {
                    $data[] = array(
                        "status" => '0',
                        "msg" => "Something Went To Wrong!",
                    );
                }
            } else {
                $data[] = array(
                    "status" => '1',
                    "msg" => "Beneficiary Already Exist!",
                );
            }
        } catch (Exception $e) {
            $data[] = array(
                "status" => '10',
                "msg" => "Could not register Mobile number. Please try again!",
                'error' => "Error: " . $e->getMessage()
            );
        }
        echo json_encode(array("result" => $data));
    }
    
    
    
        public function add_payee_agent() {
        try {
            $data = array();
            $post_data = $this->input->post();


            $this->db->select('*');
            $this->db->where(['uid' => $post_data['user_id']]);
            $query = $this->db->get('register_agent');
            $num_rows = $query->num_rows();
            if ($num_rows > 0) {
                $re = $query->result_array();
                $user_id = $re[0]['id'];
          
            $this->db->select('*');
            $this->db->where(['user_id' => $user_id, 'ifsc_code' => $post_data['ifsc_code'], 'account_no' => $post_data['account_no'], 'status' => '1']);
            $querya = $this->db->get('payee_list_agent');
            $num_rowsa = $querya->num_rows();
            // echo $this->db->last_query();exit;
            if ($num_rowsa == 0) {
                $sendData = array(
                    'user_id' => $user_id,
                    'name' => $post_data['name'],
                    'mobile_no' => $post_data['mobile_no'],
                    'bank_name' => $post_data['bank_name'],
                    'ifsc_code' => $post_data['ifsc_code'],
                    'account_no' => $post_data['account_no'],
                    'address' => $post_data['address']
                );

                $saved_data = $this->json_model->Add_Payee_Agent($sendData);
                if ($saved_data) {
                    $data[] = array(
                        "status" => '1',
                        "msg" => "Added Successfully",
                    );
                } else {
                    $data[] = array(
                        "status" => '0',
                        "msg" => "Something Went To Wrong!",
                    );
                }
            } else {
                $data[] = array(
                    "status" => '0',
                    "msg" => "Beneficiary Already Exist!",
                );
            }
        }else{
            $data[] = array(
                    "status" => '0',
                    "msg" => "UnAuthorized !",
                );
        }
        } catch (Exception $e) {
            $data[] = array(
                "status" => '10',
                "msg" => "Could not register Mobile number. Please try again!",
                'error' => "Error: " . $e->getMessage()
            );
        }
        echo json_encode(array("result" => $data));
    }

    public function beneficary() {
        try {
            $data = array();
            $user_id = $this->input->post('uid');
            $ftoken = $this->input->post('ftoken');
            $token = $this->input->post('token');

            if(empty($uid)){
                $query = $this->db->query("select * from register_agent where ftoken='$ftoken' and uid='$user_id' and user_status='1'");
                $num_rows = $query->num_rows();
                if ($num_rows > 0) {
                    $result = $query->row();
                    
                    $this->db->select('*');
                    $this->db->where(['token' => $token, 'status' => 1]);
                    $queryt = $this->db->get('apptoken');
                    $num_rowt = $queryt->num_rows();
                    if ($num_rowt > 0) {
        
                        $re = $query->result_array();
                        $post_data = $re[0]['id'];
                        
                        $saved_data = $this->json_model->getBeneficaryList($post_data);
                            if ($saved_data) {
                            $data['code'] = '0';
                            $data['msg'] = "Beneficary List";
                            $data['beneficiary_list'] = $saved_data;
                            }else{
                            $data['code'] = '1';
                            $data['msg'] = "Data not available!";
                            }
                        
                    } else {
                        $data['code'] = '1';
                        $data['msg'] = "Unauthorized Token!";
                    }
                } else {
                $data['code'] = '1';
                $data['msg'] = "User not available!";
                }
            }else{
                $data['code'] = '1';
                $data['msg'] = "User ID Blank.";
            }
        } catch (Exception $e) {
            $data['code'] = '10';
            $data['msg'] = "Could not register Mobile number. Please try again!";
            $data['error'] = "Error: " . $e->getMessage();
        }
        echo json_encode($data);
    }

    public function transaction_history() {
        try {
            $data = array();
            $post_data = $this->input->post('user_id');
            $this->db->select('*');
            $this->db->where(['uid' => $post_data]);

            $query = $this->db->get('register_users');
            $re = $query->result_array();
            $user_id = $re[0]['id'];
            $saved_data = $this->json_model->transaction_history($user_id);

            if ($saved_data) {
                $data['code'] = '0';
                $data['msg'] = "Transaction History";
                $data['transaction_history'] = $saved_data;
            } else {
                $data['code'] = '1';
                $data['msg'] = "Data not available!";
                $data['transaction_history'] = array();
            }
        } catch (Exception $e) {
            $data['code'] = '10';
            $data['msg'] = "Could not register Mobile number. Please try again!";
            $data['error'] = "Error: " . $e->getMessage();
        }
        echo json_encode($data);
    }

    public function transaction_details() {
        try {
            $data = array();
            $post_data = $this->input->post('transaction_id');
            $saved_data = $this->json_model->transaction_history_by_id($post_data);
            $cr_array[] = array(
                'trans_type' => "CR",
                'request_date' => $saved_data->request_date,
                'card_bank' => ($saved_data->payment_mode_main) ? $saved_data->payment_mode_main : "NA",
                'card_holder_name' => $saved_data->card_holder_name,
                'card_type' => $saved_data->card_type,
                'card_no' => $saved_data->card_no,
                'amount' => $saved_data->amount,
                'dispute_date_time' => ($saved_data->debited_date) ? $saved_data->debited_date : "NA",
                'swipe_machine' => $saved_data->swipe_machine,
                'company_commision_percent' => $saved_data->company_commision_percent,
                'transferable_amount' => $saved_data->bank_amount,
                'bank_refence_no' => $saved_data->bank_refence_no,
            );
            $dr_array[] = array(
                'trans_type' => "DR",
                'request_date' => ($saved_data->request_date) ? $saved_data->request_date : "NA",
                'bank_name' => ($saved_data->bank_name) ? $saved_data->bank_name : "NA",
                'payment_mode' => "Bank",
                'holder_name' => ($saved_data->holder_name) ? $saved_data->holder_name : "NA",
                'account_no' => ($saved_data->account_no) ? $saved_data->account_no : "NA",
                'ifsc_code' => ($saved_data->ifsc_code) ? $saved_data->ifsc_code : "NA",
                'Amount' => ($saved_data->bank_amount) ? $saved_data->bank_amount : "NA",
                'dispute_date_time' => ($saved_data->debited_date) ? $saved_data->debited_date : "NA",
                'Net Amt' => ($saved_data->bank_amount) ? $saved_data->bank_amount : "NA",
                'bank_refence_no' => $saved_data->bank_refence_no,
                'Total Amt Due' => ($saved_data->bank_amount != "0.00") ? $saved_data->bank_amount - $saved_data->bank_amount : "0.00"
            );

            $dr_array1[] = array(
                'trans_type' => "DR",
                'request_date' => ($saved_data->request_date) ? $saved_data->request_date : "NA",
                'payment_mode' => "Cash",
                'Net Amt' => ($saved_data->cash_amount) ? $saved_data->cash_amount : "NA",
                'Total Amt Due' => "0.00"
            );

            $final_array = array(
                'cr' => $cr_array,
                'dr' => $dr_array,
                'dr1' => $dr_array1
            );

            if ($saved_data) {
                $data['code'] = '0';
                $data['msg'] = "Transaction Details";
                $data['transaction_details'] = $final_array;
            } else {
                $data['code'] = '1';
                $data['msg'] = "Data not available!";
                $data['transaction_history'] = array();
            }
        } catch (Exception $e) {
            $data['code'] = '10';
            $data['msg'] = "Could not register Mobile number. Please try again!";
            $data['error'] = "Error: " . $e->getMessage();
        }
        echo json_encode($data);
    }

    public function forgot_password11() {
        try {
            $data = array();
            $mobile_no = $this->input->post('mobile_no');
            $password = $this->input->post('password');

            $check_mobile = $this->auth_model->CheckMobileExits($mobile_no);
            if ($check_mobile != "") {

                $update_data = array(
                    'password' => md5($password),
                    'plain_text' => $password
                );

                $saved_data = $this->json_model->UpdatePassword($update_data, $mobile_no);
                if ($saved_data) {
                    $data[] = array(
                        "status" => '1',
                        "msg" => "Password Update Successfully",
                    );
                } else {
                    $data[] = array(
                        "status" => '0',
                        "msg" => "Something Went To Wrong!",
                    );
                }
            } else {
                $data[] = array(
                    "status" => '0',
                    "msg" => "Could not register Mobile number. Please try again!!",
                );
            }
        } catch (Exception $e) {
            $data['code'] = '10';
            $data['msg'] = "Could not register Mobile number. Please try again!";
            $data['error'] = "Error: " . $e->getMessage();
        }
        echo json_encode(array("result" => $data));
    }

    public function user_documents() {
        try {
            $data = array();
            $userid = $this->input->post('user_id');

            $this->db->select('*');
            $this->db->where('uid', $userid);
            $q = $this->db->get('register_users');
            $r = $q->result_array();
            $user_id = $r[0]['id'];
            $send_data = $this->json_model->getUsersDocuments($user_id);

            if ($send_data) {
                $details[] = array(
                    'mobile_no' => $send_data->mobile_no,
                    'pancard_image' => ($send_data->pancard_image) ? base_url('assets/uploads/pancards/' . $send_data->pancard_image) : "",
                    'adharcard_front_image' => ($send_data->adharcard_front_image) ? base_url('assets/uploads/adharcards/' . $send_data->adharcard_front_image) : "",
                    'adharcard_back_image' => ($send_data->adharcard_back_image) ? base_url('assets/uploads/adharcards/' . $send_data->adharcard_back_image) : "",
                    'img_self' => ($send_data->selfee_image) ? base_url('assets/uploads/selfee/' . $send_data->selfee_image) : "",
                );
                if ($send_data) {
                    $data[] = array(
                        "status" => '1',
                        "msg" => "Documents List",
                        'documents_list' => $details
                    );
                }
            } else {
                $data[] = array(
                    "status" => '0',
                    "msg" => "Data Not Available!",
                    'documents_list' => []
                );
            }
        } catch (Exception $e) {
            $data['code'] = '10';
            $data['msg'] = "Could not register Mobile number. Please try again!";
            $data['error'] = "Error: " . $e->getMessage();
        }
        echo json_encode(array("result" => $data));
    }
    
    
    public function user_documents_agent() {
        try {
            $data = array();
            $userid = $this->input->post('user_id');

            $this->db->select('*');
            $this->db->where('uid', $userid);
            $q = $this->db->get('register_agent');
            $r = $q->result_array();
            $user_id = $r[0]['id'];
            $send_data = $this->json_model->getAgentDocuments($user_id);

            if ($send_data) {
                $details[] = array(
                    'mobile_no' => $send_data->mobile_no,
                    'pancard_image' => ($send_data->pancard_image) ? base_url('assets/uploads/agent/pancards/' . $send_data->pancard_image) : "",
                    'adharcard_front_image' => ($send_data->adharcard_front_image) ? base_url('assets/uploads/agent/adharcards/' . $send_data->adharcard_front_image) : "",
                    'adharcard_back_image' => ($send_data->adharcard_back_image) ? base_url('assets/uploads/agent/adharcards/' . $send_data->adharcard_back_image) : "",
                    'img_self' => ($send_data->cancel_cheque) ? base_url('assets/uploads/agent/cancel_cheque/' . $send_data->cancel_cheque) : "",
                    'img5' => ($send_data->office_in) ? base_url('assets/uploads/agent/office_in/' . $send_data->office_in) : "",
                    'img6' => ($send_data->office_out) ? base_url('assets/uploads/agent/office_out/' . $send_data->office_out) : "",
                );
                if ($send_data) {
                    $data[] = array(
                        "status" => '1',
                        "msg" => "Documents List",
                        'documents_list' => $details
                    );
                }
            } else {
                $data[] = array(
                    "status" => '0',
                    "msg" => "Data Not Available!",
                    'documents_list' => []
                );
            }
        } catch (Exception $e) {
            $data['code'] = '10';
            $data['msg'] = "Could not register Mobile number. Please try again!";
            $data['error'] = "Error: " . $e->getMessage();
        }
        echo json_encode(array("result" => $data));
    }

    public function check_user_kyc() {
        try {
            $data = array();
            $userid = $this->input->post('user_id');
            $this->db->select('*');
            $this->db->where('uid', $userid);
            $q = $this->db->get('register_users');
            $r = $q->result_array();
            $user_id = $r[0]['id'];
            $send_data = $this->json_model->getUsersDocuments($user_id);
            if ($send_data) {
                if ($send_data->pancard_status == "1" && $send_data->adhar_card_front_status == "1" && $send_data->adhar_card_back_status == "1" && $send_data->selfee_image_status == "1") {
                    $data[] = array(
                        "status" => '1',
                        "msg" => "Your KYC Is Done",
                    );
                } else if ($send_data->pancard_status == "1" || $send_data->adhar_card_front_status == "1" || $send_data->adhar_card_back_status == "1" || $send_data->selfee_image_status == "1") {
                    $data[] = array(
                        "status" => '3',
                        "msg" => "Your KYC Done Now You can Start Your Transation",
                    );
                } else if ($send_data->pancard_status == "2" && $send_data->adhar_card_front_status == "2" && $send_data->adhar_card_back_status == "2" && $send_data->selfee_image_status == "2") {
                    $data[] = array(
                        "status" => '2',
                        "msg" => "Your KYC Approval is Pending",
                    );
                } else if ($send_data->pancard_status == "2" || $send_data->adhar_card_front_status == "2" || $send_data->adhar_card_back_status == "2" || $send_data->selfee_image_status == "2") {
                    $data[] = array(
                        "status" => '4',
                        "msg" => "Your KYC is Pending",
                    );
                } else if ($send_data->pancard_status == "0" && $send_data->adhar_card_front_status == "0" && $send_data->adhar_card_back_status == "0" && $send_data->selfee_image_status == "0") {
                    $data[] = array(
                        "status" => '0',
                        "msg" => "Your Document Is Rejected",
                    );
                }
            } else {
                $data[] = array(
                    "status" => '0',
                    "msg" => "Your KYC Not Done!",
                );
            }
        } catch (Exception $e) {
            $data['code'] = '10';
            $data['msg'] = "Could not register Mobile number. Please try again!";
            $data['error'] = "Error: " . $e->getMessage();
        }
        echo json_encode(array("result" => $data));
    }

    public function check_user_kyc_agent() {
        try {
            $data = array();
            $userid = $this->input->post('user_id');
            $this->db->select('*');
            $this->db->where('uid', $userid);
            $q = $this->db->get('register_agent');
            $r = $q->result_array();
            $user_id = $r[0]['id'];
            $send_data = $this->json_model->getAgentDocuments($user_id);
            if ($send_data) {
                if ($send_data->pancard_status == "1" && $send_data->adhar_card_front_status == "1" && $send_data->adhar_card_back_status == "1" && $send_data->cancel_cheque_status == "1" && $send_data->office_in_status == "1" && $send_data->office_out_status == "1") {
                    $data[] = array(
                        "status" => '1',
                        "msg" => "Your KYC Is Done",
                    );
                } else if ($send_data->pancard_status == "1" || $send_data->adhar_card_front_status == "1" || $send_data->adhar_card_back_status == "1" || $send_data->cancel_cheque_status == "1" || $send_data->office_in_status == "1" || $send_data->office_out_status == "1") {
                    $data[] = array(
                        "status" => '3',
                        "msg" => "Your KYC Done Now You can Start Your Transation",
                    );
                } else if ($send_data->pancard_status == "2" && $send_data->adhar_card_front_status == "2" && $send_data->adhar_card_back_status == "2" && $send_data->cancel_cheque_status == "2" && $send_data->office_in_status == "2" && $send_data->office_out_status == "2") {
                    $data[] = array(
                        "status" => '2',
                        "msg" => "Your KYC Approval is Pending",
                    );
                } else if ($send_data->pancard_status == "2" || $send_data->adhar_card_front_status == "2" || $send_data->adhar_card_back_status == "2" || $send_data->cancel_cheque_status == "2" || $send_data->office_in_status == "2" || $send_data->office_out_status == "2") {
                    $data[] = array(
                        "status" => '4',
                        "msg" => "Your KYC is Pending",
                    );
                } else if ($send_data->pancard_status == "0" && $send_data->adhar_card_front_status == "0" && $send_data->adhar_card_back_status == "0" && $send_data->cancel_cheque_status == "0" && $send_data->office_out_status == "0" && $send_data->office_in_status == "0") {
                    $data[] = array(
                        "status" => '0',
                        "msg" => "Your Document Is Rejected",
                    );
                }
            } else {
                $data[] = array(
                    "status" => '0',
                    "msg" => "Your KYC Not Done!",
                );
            }
        } catch (Exception $e) {
            $data['code'] = '10';
            $data['msg'] = "Could not register Mobile number. Please try again!";
            $data['error'] = "Error: " . $e->getMessage();
        }
        echo json_encode(array("result" => $data));
    }

    public function user_bank_details() {
        try {
            $data = array();
            $post_data = $this->input->post();

            $cancel_check_img = base64_decode($this->input->post("check_image"));
            if ($this->input->post("check_image") != '') {
                $check_img = $post_data['user_id'];
                $filename_check = $check_img . '.' . 'png';
                $path5 = 'assets/uploads/bank_details/';
                file_put_contents($path5 . $filename_check, $cancel_check_img);
            } else {
                $check_users1 = $this->json_model->checkBankByUserId($post_data['user_id']);
                $filename_check = $check_users1->check_image;
            }
            $sendData = array(
                'user_id' => $post_data['user_id'],
                'ifsc_code' => $post_data['ifsc_code'],
                'bank_name' => $post_data['bank_name'],
                'holder_name' => $post_data['holder_name'],
                'account_no' => $post_data['account_no'],
                'branch_name' => $post_data['branch_name'],
                'pin_code' => $post_data['pin_code'],
                'check_image' => $filename_check,
            );
            $check_users = $this->json_model->checkBankByUserId($post_data['user_id']);
            if ($check_users) {
                $saved_data = $this->json_model->update_bank_details($sendData, $post_data['user_id']);
                if ($saved_data) {
                    $data[] = array(
                        "status" => '1',
                        "msg" => "Bank Details Updated Successfully",
                    );
                } else {
                    $data[] = array(
                        "status" => '0',
                        "msg" => "Something Went To Wrong!",
                    );
                }
            } else {
                $saved_data = $this->json_model->insert_bank_details($sendData, $post_data['user_id']);
                if ($saved_data) {
                    $data[] = array(
                        "status" => '1',
                        "msg" => "Bank Details Added Successfully",
                    );
                } else {
                    $data[] = array(
                        "status" => '0',
                        "msg" => "Something Went To Wrong!",
                    );
                }
            }
        } catch (Exception $e) {
            $data[] = array(
                "status" => '10',
                "msg" => "Could not request Payment. Please try again!",
                'error' => "Error: " . $e->getMessage()
            );
        }
        echo json_encode(array("result" => $data));
    }

    public function get_user_bank_details() {
        try {
            $data = array();
            $post_data = $this->input->post('user_id');
            $saved_data = $this->json_model->checkBankByUserId($post_data);
            if ($saved_data) {
                $se_array[] = array(
                    "user_id" => $saved_data->user_id,
                    "ifsc_code" => $saved_data->ifsc_code,
                    "bank_name" => $saved_data->bank_name,
                    "holder_name" => $saved_data->holder_name,
                    "account_no" => $saved_data->account_no,
                    "branch_name" => $saved_data->branch_name,
                    "pin_code" => $saved_data->pin_code,
                    "check_image" => base_url('assets/uploads/bank_details/' . $saved_data->check_image),
                );
                $data[] = array(
                    "status" => '1',
                    "msg" => "User Bank Details",
                    "user_bank_details" => $se_array,
                );
            } else {
                $data[] = array(
                    "status" => '0',
                    "msg" => "Data not available!",
                    "user_bank_details" => array(),
                );
            }
        } catch (Exception $e) {
            $data['code'] = '10';
            $data['msg'] = "Could not register Mobile number. Please try again!";
            $data['error'] = "Error: " . $e->getMessage();
        }
        echo json_encode(array("result" => $data));
    }

    public function update_user_photo() {
        try {
            $data = array();
            $post_data = $this->input->post();
            $cancel_check_img = base64_decode($this->input->post("user_photo"));

            if ($this->input->post("user_photo") != '') {
                $check_img = $post_data['user_id'];
                $filename_check = $check_img . '.' . 'png';
                $path5 = 'assets/uploads/user_photos/';
                file_put_contents($path5 . $filename_check, $cancel_check_img);
            }
            $sendData = array(
                'user_photo' => $filename_check,
            );
            $saved_data = $this->json_model->update_user_photo($sendData, $post_data['user_id']);
            if ($saved_data) {
                $data[] = array(
                    "status" => '1',
                    "msg" => "Photo uploaded Successfully",
                );
            } else {
                $data[] = array(
                    "status" => '0',
                    "msg" => "Something Went to Wrong!",
                );
            }
        } catch (Exception $e) {
            $data['code'] = '10';
            $data['msg'] = "Could not register Mobile number. Please try again!";
            $data['error'] = "Error: " . $e->getMessage();
        }
        echo json_encode(array("result" => $data));
    }

    public function get_referral_users() {
        try {
            $data = array();
            $post_data = $this->input->post('user_id');

            $saved_data = $this->json_model->getReferralUsers($post_data);
            if ($saved_data) {
                $data[] = array(
                    "status" => '1',
                    "msg" => "User Bank Details",
                    "user_bank_details" => $saved_data,
                );
            } else {
                $data[] = array(
                    "status" => '0',
                    "msg" => "Data not available!",
                    "user_bank_details" => array(),
                );
            }
        } catch (Exception $e) {
            $data['code'] = '10';
            $data['msg'] = "Could not register Mobile number. Please try again!";
            $data['error'] = "Error: " . $e->getMessage();
        }
        echo json_encode(array("result" => $data));
    }

    public function change_password() {
        try {
            $data = array();
            $post_data = $this->input->post();
            $check_old_password = $this->auth_model->CheckOldPassword(md5($post_data['old_password']), $post_data['user_id']);
            if ($check_old_password) {
                $updata = array(
                    'password' => md5($post_data['new_password']),
                    'plain_text' => $post_data['new_password']
                );
                $send_passwd = $this->auth_model->UpdateUserPassword($updata, $post_data['user_id']);
                if ($send_passwd) {
                    $data[] = array(
                        "status" => '1',
                        "msg" => "Password Changed Successfully!",
                    );
                }
            } else {
                $data[] = array(
                    "status" => '0',
                    "msg" => "Password Not Match!",
                );
            }
        } catch (Exception $e) {

            $data[] = array(
                "status" => '0',
                "msg" => "Could not register Mobile number. Please try again!!",
                "error" => "Error: " . $e->getMessage()
            );
        }
        echo json_encode(array("result" => $data));
    }

    public function delete_beneficiary() {
        try {
            $data = array();
            $post_data = $this->input->post();

            $check_user_exist = $this->json_model->getUsersById($post_data['user_id']);
            if ($check_user_exist) {

                $delete_beneficiary = $this->json_model->deleteBeneficiary($post_data['beneficiary_id'], $post_data['user_id']);
                if ($delete_beneficiary) {
                    $data[] = array(
                        "status" => '1',
                        "msg" => "Beneficiary deleted Successfully!",
                    );
                } else {
                    $data[] = array(
                        "status" => '0',
                        "msg" => "Something went to Wrong!",
                    );
                }
            } else {
                $data[] = array(
                    "status" => '0',
                    "msg" => "Data Not Matched!",
                );
            }
        } catch (Exception $e) {

            $data[] = array(
                "status" => '0',
                "msg" => "Could not register Mobile number. Please try again!!",
                "error" => "Error: " . $e->getMessage()
            );
        }
        echo json_encode(array("result" => $data));
    }

    public function referal_user_list() {
        try {
            $data = array();
            $post_data = $this->input->post();
            $referral_array = array();
            $check_user_exist = $this->json_model->get_users_by_referral_code($post_data['user_id']);
            if ($check_user_exist) {
                foreach ($check_user_exist as $check_user_exists) {
                    $get_user_exis = $this->json_model->getUsersById($check_user_exists->used_user_id);
                    $referral_array[] = array(
                        'name' => $get_user_exis->first_name . ' ' . $get_user_exis->last_name,
                        'register_date' => $get_user_exis->created_at,
                        'mobile_no' => $get_user_exis->mobile_no,
                        'credited_amt' => ($check_user_exists->credit_amt) ? $check_user_exists->credit_amt : "0"
                    );
                }
                if ($check_user_exist) {
                    $data[] = array(
                        "status" => '1',
                        "msg" => "Referral List!",
                        'referral_list' => $referral_array
                    );
                } else {
                    $data[] = array(
                        "status" => '0',
                        "msg" => "Data Not Matched!",
                    );
                }
            } else {
                $data[] = array(
                    "status" => '0',
                    "msg" => "Data Not Matched!",
                );
            }
        } catch (Exception $e) {
            $data[] = array(
                "status" => '0',
                "msg" => "Could not register Mobile number. Please try again!!",
                "error" => "Error: " . $e->getMessage()
            );
        }
        echo json_encode(array("result" => $data));
    }

    public function wallet_trasation_web_view($id) {
        $data = array();
        $this->data['wallet_transation'] = $this->users_model->getWalletTransationByUser($id);
        $bc = array(array('link' => base_url(), 'page' => 'Dashboard'));
        $meta = array('page_title' => 'Wallet Transation', 'bc' => $bc);
        $this->page_construct_web('admin/transfer_request/wallet_transation', $meta, $this->data);
    }

    public function users_address() {
        try {
            $data = array();
            $post_data = $this->input->post();

            $sendData = array(
                'user_id' => $post_data['user_id'],
                'country' => $post_data['country'],
                'state' => $post_data['state'],
                'city' => $post_data['city'],
                'pin_code' => $post_data['pin_code'],
                'address' => $post_data['address'],
            );
            $check_users = $this->json_model->getUsersAddress($post_data['user_id']);
            if ($check_users) {
                $saved_data = $this->json_model->Update_User_address($sendData);
            } else {
                $saved_data = $this->json_model->Add_User_address($sendData);
            }
            if ($saved_data) {
                $data[] = array(
                    "status" => '1',
                    "msg" => "Added Successfully",
                );
            } else {
                $data[] = array(
                    "status" => '0',
                    "msg" => "Something Went To Wrong!",
                );
            }
        } catch (Exception $e) {
            $data[] = array(
                "status" => '10',
                "msg" => "Could not register Mobile number. Please try again!",
                'error' => "Error: " . $e->getMessage()
            );
        }
        echo json_encode(array("result" => $data));
    }

    public function get_users_address() {
        try {
            $data = array();
            $post_data = $this->input->post('user_id');

            $saved_data = $this->json_model->getUsersAddress($post_data);
            if ($saved_data) {
                $data[] = array(
                    "status" => '1',
                    "msg" => "Address",
                    "user_address" => $saved_data,
                );
            } else {
                $data[] = array(
                    "status" => '0',
                    "msg" => "Data not available!",
                    "user_address" => array(),
                );
            }
        } catch (Exception $e) {
            $data[] = array(
                "status" => '0',
                "msg" => "Could not register Mobile number. Please try again!",
                "error" => "Error: " . $e->getMessage()
            );
        }
        echo json_encode(array("result" => $data));
    }

    public function block_user() {
        try {
            $data = array();
            $post_data = $this->input->post('user_id');

            $user_details = $this->json_model->getUsersById($post_data);
            if ($user_details->user_status == 1) {
                $data[] = array(
                    "status" => '1',
                    "msg" => "User Unblock"
                );
            } else {
                $data[] = array(
                    "status" => '0',
                    "msg" => "User Block"
                );
            }
        } catch (Exception $e) {
            $data[] = array(
                "status" => '0',
                "msg" => "Could not register Mobile number. Please try again!",
                "error" => "Error: " . $e->getMessage()
            );
        }
        echo json_encode(array("result" => $data));
    }

    public function remitter_details() {
        $ftoken = $operator = $this->input->post('ftoken');
        $token = $operator = $this->input->post('token');
        $mobile_number = $this->input->post('mobile');
        $uid = $this->input->post('uid');




        $query = $this->db->query("select * from register_users where ftoken='$ftoken' and uid='$uid' and user_status='1'");
        $num_rows = $query->num_rows();
        if ($num_rows > 0) {
            $result = $query->result_array();
            $id = $result[0]['id'];


            $this->db->select('*');
            $this->db->where(['token' => $token, 'status' => 1]);
            $queryt = $this->db->get('apptoken');
            $num_rowt = $queryt->num_rows();
            if ($num_rowt > 0) {



                $querydown = $this->db->query("select * from register_users where user_status='1'");
                $num_rowsdown = $querydown->num_rows();
                if ($num_rowsdown > 0) {

                    $tokan = "a6618b6239a62af3f40d81627993bfa5";


                    $api_url = 'https://www.instantpay.in/ws/dmi/remitter_details';
                    $arr = array('token' => $tokan, 'request' => array('mobile' => $mobile_number));

                    $data_string = json_encode($arr);
                    //echo "<pre>";print_r($data_string);exit;

                    $ch = curl_init($api_url);
                    curl_setopt($ch, CURLOPT_POST, 1);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, "$data_string");
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                    curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json', 'Accept: application/json'));



                    $result = curl_exec($ch);
                    $info = curl_getinfo($ch);
                    //	echo "<pre>result=";print_r($info);
                    //	var_dump($info);


                    $response = json_decode($result);
                    $status = $response->status;
                    //echo "<pre>";print_r($response);
                    $txn = $response->statuscode;
                    $status = $response->status;
                    //echo "<pre>";print_r($addInfojson);echo "</pre>";exit;
                    if ($txn == 'TXN') {
                        $is_verified = $response->data->remitter->is_verified;
                        $sender_id = $response->data->remitter->id;
                        if ($is_verified == '1') {

                            $remaininglimit = $response->data->remitter->remaininglimit;
                            $data[] = array("status" => 1, "msg" => $status, 'sender_id' => $sender_id, 'limit' => $remaininglimit);
                        } else {
                            $data[] = array("status" => 2, "msg" => $status, 'sender_id' => $sender_id);
                        }
                    } else {
                        $data[] = array("status" => 0, "msg" => $status);
                    }
                } else {
                    $data[] = array('status' => "0", 'msg' => "Service Temporarily Down");
                }
            } else {
                $data[] = array('status' => "0", 'msg' => "Unauthorized User1");
            }
        } else {
            $data[] = array('status' => "0", 'msg' => "Unauthorized User");
        }
        echo json_encode(array("result" => $data));
    }

    public function remitter_validate() {
        $ftoken = $operator = $this->input->post('ftoken');
        $token = $operator = $this->input->post('token');
        $mobile_number = $this->input->post('mobile');
        $uid = $operator = $this->input->post('uid');
        $otp = $this->input->post('varify_otc');
        $rid = $this->input->post('rid');


        $query = $this->db->query("select * from register_users where ftoken='$ftoken' and uid='$uid' and user_status='1'");
        $num_rows = $query->num_rows();
        if ($num_rows > 0) {
            $result = $query->result_array();
            $id = $result[0]['id'];

            $this->db->select('*');
            $this->db->where(['token' => $token, 'status' => 1]);
            $queryt = $this->db->get('apptoken');
            $num_rowt = $queryt->num_rows();
            if ($num_rowt > 0) {

                if ($otp) {

                    $tokan = "a6618b6239a62af3f40d81627993bfa5";


                    $api_url = 'https://www.instantpay.in/ws/dmi/remitter_validate';
                    $arr = array('token' => $tokan, 'request' => array('remitterid' => $rid, 'mobile' => $mobile_number, 'otp' => $otp, 'outletid' => '11100'));

                    $data_string = json_encode($arr);
                    //echo "<pre>";print_r($data_string);exit;

                    $ch = curl_init($api_url);
                    curl_setopt($ch, CURLOPT_POST, 1);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, "$data_string");
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                    curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json', 'Accept: application/json'));



                    $result = curl_exec($ch);
                    $info = curl_getinfo($ch);
                    //	echo "<pre>result=";print_r($info);
                    //	var_dump($info);


                    $response = json_decode($result);

                    if ($response) {
                        //echo "<pre>result=";print_r($response);
                        $txn = $response->statuscode;
                        $status = $response->status;
                        if ($txn == "TXN") {
                            $data[] = array('status' => "1", 'msg' => $status);
                        } else {
                            $data[] = array('status' => "0", 'msg' => $status);
                        }
                    } else {
                        $data[] = array('status' => "0", 'msg' => "Server Error");
                    }
                } else {
                    $data[] = array('status' => "0", 'msg' => "Enter otp");
                }
            } else {
                $data[] = array('status' => "0", 'msg' => "Unauthorized User");
            }
        } else {
            $data[] = array('status' => "0", 'msg' => "Unauthorized User");
        }
        echo json_encode(array("result" => $data));
    }


 public function recharge_history() {
        $data = array();
        $arrData = array();
        $ftoken = $this->input->post('ftoken');
        $token = $this->input->post('token');
        $uid = $this->input->post('uid');

        $query = $this->db->query("select * from register_users where ftoken='$ftoken' and uid='$uid' and user_status='1'");
        $num_rows = $query->num_rows();
        if ($num_rows > 0) {
            $result = $query->row();
            
            $this->db->select('*');
            $this->db->where(['token' => $token, 'status' => 1]);
            $queryt = $this->db->get('apptoken');
            $num_rowt = $queryt->num_rows();
            if ($num_rowt > 0) {
                $recharge_history = $this->json_model->getRechargeHistory($result->id);
                if($recharge_history) {
                    foreach($recharge_history as $recharge_historys){
                        $arrData['data'][] = array(
                            'recharge_date' => $recharge_historys->created_at,
                            'opname' => $recharge_historys->operator_name,
                            'mobile_number' => $recharge_historys->recharge_number,
                            'amount' => $recharge_historys->amount,
                            'reference number' => $recharge_historys->operator_id,
                            'status' => $recharge_historys->status
                        );
                    }
                    $data[] = array('status'=>1,'msg'=>"success",'details'=>$arrData);
                } else {
                    $data[] = array('status'=>0,'msg'=>"Data Not Founds..");
                }
            } else {
                $data[] = array(
                    "status" => '0',
                    "msg" => "Unauthorized User!",
                );
            }
        } else {
            $data[] = array(
                "status" => '0',
                "msg" => "Unauthorized User!",
            );
        }
        echo json_encode(array("result" => $data));
    }
    

    public function available_limit() {
        $ftoken = $this->input->post('ftoken');
        $token = $this->input->post('token');
        $uid = $this->input->post('uid');
        $mobile_number = $this->input->post('mobile_number');

        $query = $this->db->query("select * from register_users where ftoken='$ftoken' and uid='$uid' and user_status='1'");
        $num_rows = $query->num_rows();
        if ($num_rows > 0) {
            $result = $query->result_array();
            $id = $result[0]['id'];

            $this->db->select('*');
            $this->db->where(['token' => $token, 'status' => 1]);
            $queryt = $this->db->get('apptoken');
            $num_rowt = $queryt->num_rows();
            if ($num_rowt > 0) {

                if ($uid) {

                    $tokan = "a6618b6239a62af3f40d81627993bfa5";


                    $api_url = 'https://www.instantpay.in/ws/dmi/remitter_details';
                    $arr = array('token' => $tokan, 'request' => array('mobile' => $mobile_number));

                    $data_string = json_encode($arr);
                    //echo "<pre>";print_r($data_string);exit;

                    $ch = curl_init($api_url);
                    curl_setopt($ch, CURLOPT_POST, 1);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, "$data_string");
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                    curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json', 'Accept: application/json'));



                    $result = curl_exec($ch);
                    $info = curl_getinfo($ch);
                    //	echo "<pre>result=";print_r($info);
                    //	var_dump($info);


                    $response = json_decode($result);
                    $status = $response->status;
                    //echo "<pre>";print_r($response);
                    $txn = $response->statuscode;
                    $status = $response->status;
                    //echo "<pre>";print_r($addInfojson);echo "</pre>";exit;
                    if ($txn == 'TXN') {
                        $is_verified = $response->data->remitter->is_verified;
                        $remitterId = $response->data->remitter->id;
                        $remaininglimit = $response->data->remitter->remaininglimit;
                        $data[] = array('status' => "1", 'msg' => $status, 'sender_id' => $remitterId, 'remaning_amt' => $remaininglimit);
                    } else {

                        $consumedlimit = 0;
                        $remaininglimit = 0;

                        $data[] = array('status' => "0", 'msg' => $status, 'sender_id' => '', 'remaning_amt' => $remaininglimit);
                    }
                } else {
                    $data[] = array('status' => "0", 'msg' => "User id Required.");
                }
            } else {
                $data[] = array('status' => "0", 'msg' => "Unauthorized User");
            }
        } else {
            $data[] = array('status' => "0", 'msg' => "Unauthorized User");
        }
        echo json_encode(array("result" => $data));
    }

    public function remitter_add() {
        $ftoken = $operator = $this->input->post('ftoken');
        $token = $this->input->post('token');
        $mobile_number = $this->input->post('mobile');
        $uid = $operator = $this->input->post('uid');
        $fName = $this->input->post('fname');
        $pin = $this->input->post('pincode');
        $lName = $this->input->post('lname');


        $query = $this->db->query("select * from register_users where ftoken='$ftoken' and uid='$uid' and user_status='1'");
        $num_rows = $query->num_rows();
        if ($num_rows > 0) {
            $result = $query->result_array();
            $id = $result[0]['id'];

            $this->db->select('*');
            $this->db->where(['token' => $token, 'status' => 1]);
            $queryt = $this->db->get('apptoken');
            $num_rowt = $queryt->num_rows();
            if ($num_rowt > 0) {

                if ($mobile_number) {
                    if ($fName) {
                        if ($lName) {
                            if ($pin) {

                                $tokan = "a6618b6239a62af3f40d81627993bfa5";


                                $api_url = 'https://www.instantpay.in/ws/dmi/remitter';
                                $arr = array('token' => $tokan, 'remitter_otp' => 1, 'request' => array('mobile' => $mobile_number, 'name' => $fName, 'surname' => $lName, 'pincode' => $pin));

                                //$arr = array('token'=>$tokan,'request'=>array('mobile'=>$mobile_number,'name'=>$fname,'pincode'=>$pin));

                                $data_string = json_encode($arr);
                                //	echo "<pre>";print_r($data_string);exit;

                                $ch = curl_init('https://www.instantpay.in/ws/dmi/remitter');
                                curl_setopt($ch, CURLOPT_POST, 1);
                                curl_setopt($ch, CURLOPT_POSTFIELDS, "$data_string");
                                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                                curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json', 'Accept: application/json'));



                                $result = curl_exec($ch);
                                $info = curl_getinfo($ch);
                                //	echo "<pre>result=";print_r($info);
                                //	var_dump($info);


                                $response = json_decode($result);

                                if ($response) {
                                    //echo "<pre>result=";print_r($response);
                                    $txn = $response->statuscode;
                                    $status = $response->status;
                                    if ($txn == "TXN") {
                                        $rid = $response->data->remitter->id;
                                        $isverify = $response->data->remitter->is_verified;
                                        $data[] = array('status' => "1", 'msg' => $status, 'rid' => $rid, 'isverify' => $isverify);
                                    } else {
                                        $data[] = array('status' => "0", 'msg' => $status);
                                    }
                                } else {
                                    $data[] = array('status' => "0", 'msg' => "Server Error");
                                }
                            } else {
                                $data[] = array('status' => "0", 'msg' => "Enter Pincode");
                            }
                        } else {
                            $data[] = array('status' => "0", 'msg' => "Enter Last Name");
                        }
                    } else {
                        $data[] = array('status' => "0", 'msg' => "Enter First Name");
                    }
                } else {
                    $data[] = array('status' => "0", 'msg' => "Enter Mobile Number");
                }
            } else {
                $data[] = array('status' => "0", 'msg' => "Unauthorized User");
            }
        } else {
            $data[] = array('status' => "0", 'msg' => "Unauthorized User");
        }
        echo json_encode(array("result" => $data));
    }

    public function beneficiary_register() {
        $ftoken = $this->input->post('ftoken');
        $token = $this->input->post('token');
        $uid = $this->input->post('uid');
        $rid = $this->input->post('rid');

        $mobile_number = $this->input->post('mobile');
        $benName = $this->input->post('name');
        $IFSC = $this->input->post('ifsc');
        $benAccount = $this->input->post('acno');
        $bank_name = $this->input->post('bank_name');


        $query = $this->db->query("select * from register_users where ftoken='$ftoken' and uid='$uid' and user_status='1'");
        $num_rows = $query->num_rows();
        if ($num_rows > 0) {
            $result = $query->result_array();
            $id = $result[0]['id'];

            $this->db->select('*');
            $this->db->where(['token' => $token, 'status' => 1]);
            $queryt = $this->db->get('apptoken');
            $num_rowt = $queryt->num_rows();
            if ($num_rowt > 0) {

                if ($mobile_number) {
                    if ($benName) {
                        if ($IFSC) {
                            if ($benAccount) {

                                $tokan = "a6618b6239a62af3f40d81627993bfa5";


                                $api_url = 'https://www.instantpay.in/ws/dmi/beneficiary_register';
                                $arr = array('token' => $tokan, 'request' => array('remitterid' => $rid, 'name' => $benName, 'mobile' => $mobile_number, 'ifsc' => $IFSC, 'account' => $benAccount));

                                $data_string = json_encode($arr);
                                //echo "<br>----------------------------Request------------------------------------";
                                //echo "<pre>";print_r($data_string);

                                $ch = curl_init($api_url);
                                curl_setopt($ch, CURLOPT_POST, 1);
                                curl_setopt($ch, CURLOPT_POSTFIELDS, "$data_string");
                                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                                curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json', 'Accept: application/json'));



                                $result = curl_exec($ch);
                                $info = curl_getinfo($ch);
                                //	echo "<pre>result=";print_r($info);
                                //	var_dump($info);


                                $response = json_decode($result);

                                if ($response) {
                                    //echo "<pre>result=";print_r($response);
                                    $txn = $response->statuscode;
                                    $status = $response->status;
                                    if ($txn == "TXN") {
                                        $benid = $response->data->beneficiary->id;
                                        $data[] = array('status' => "1", 'msg' => $status, 'benid' => $benid);
                                    } else {
                                        $data[] = array('status' => "0", 'msg' => $status, 'benid' => '');
                                    }
                                } else {
                                    $data[] = array('status' => "0", 'msg' => "Server Error");
                                }
                            } else {
                                $data[] = array('status' => "0", 'msg' => "Enter Account Number");
                            }
                        } else {
                            $data[] = array('status' => "0", 'msg' => "Enter IFSC");
                        }
                    } else {
                        $data[] = array('status' => "0", 'msg' => "Enter Name");
                    }
                } else {
                    $data[] = array('status' => "0", 'msg' => "Enter Mobile Number");
                }
            } else {
                $data[] = array('status' => "0", 'msg' => "Unauthorized User");
            }
        } else {
            $data[] = array('status' => "0", 'msg' => "Unauthorized User");
        }
        echo json_encode(array("result" => $data));
    }
    
    
    public function invoice($tr_id){
        $data = array();
        $data['invoice_details'] = $this->transfer_request_model->invoice_transation_details($tr_id);
        $this->load->view('admin/transfer_request/invoice',$data);
    }
    
    public function user_kyc_card_image(){
        
        $transation_id = $this->input->post('tras_id');
        $card_address = $this->input->post('card_address');
        $ftoken = $operator = $this->input->post('ftoken');
        $token = $this->input->post('token');
        $uid = $operator = $this->input->post('uid');


        $query = $this->db->query("select * from register_users where ftoken='$ftoken' and uid='$uid' and user_status='1'");
        $num_rows = $query->num_rows();
        if ($num_rows > 0) {
            $result = $query->result_array();
            $id = $result[0]['id'];

            $this->db->select('*');
            $this->db->where(['token' => $token, 'status' => 1]);
            $queryt = $this->db->get('apptoken');
            $num_rowt = $queryt->num_rows();
            if ($num_rowt > 0) {
                $filename_card = "";
                 $card_img = base64_decode($this->input->post("image"));
                    if ($card_img != '') {
                        $c_img = strtolower($result[0]['first_name'] . '_' . $result[0]['last_name'] . '_' . $transation_id);
                        $filename_card = $c_img . '.' . 'png';
                        $path1 = 'assets/uploads/card_image/';
                        file_put_contents($path1 . $filename_card, $card_img);
                    }
                    $sendData = array(
                        'card_status' => '2',
                        'card_address' => $card_address,
                        'card_image' => $filename_card,
                    );
                    $update_data = $this->json_model->update_request_data($sendData,$transation_id);
                    if($update_data) {
                        $data[] = array('status' => "1");
                    } else {
                         $data[] = array('status' => "0");
                    }
            } else {
                $data[] = array('status' => "0", 'msg' => "Unauthorized User");
            }
        } else {
            $data[] = array('status' => "0", 'msg' => "Unauthorized User");
        }
        echo json_encode(array("result" => $data));
    }
        
        
        
       /* public function getIFSC(){
		
	    $this->db->select("*");
		$q = $this->db->get('bank_details');
		$rr = $q->num_rows();
		if(1==1){
		    $result = $q->result_array();
		    foreach($result as $result){
    		    $bank_name = $result['bank_name'];
    		    $ifsc = $result['ifsc'];
    		    $image='';
    		    $res[] = array("operator_code"=>$ifsc,"operator_name"=>$bank_name,"image"=>$image);
		    }
		    echo json_encode(array("operators"=>$res));
		}
		
           
    }*/
    
    
   public function payment_request_by_app(){
        try {
            $data = array();
            $post_data = $this->input->post();
                $check_users = $this->json_model->check_users_block($post_data['user_id']);
                if ($check_users) {
                        $sendData = array(
                            'user_id' => $post_data['user_id'],
                            'amount' => $post_data['amount'],
                            'charge_amount' => $post_data['charge_amount'],
                            'payment_mode' => $post_data['payment_mode'],
                            'account_no' => $post_data['account_no'],
                            'holder_name' => $post_data['holder_name'],
                            'bank_name' => $post_data['bank_name'],
                            'ifsc_code' => $post_data['ifsc_code'],
                            'purpose' => $post_data['purpose'],
                            'address' => $post_data['address'],
                            'service' => $post_data['service'],
                            'razorpay_trans_id' => $post_data['razorpay_trans_id'],
                            'card_number' => $post_data['card_number'],
                            'payment_channel' => $post_data['payment_channel'],
                            'payment_mode_main' => $post_data['payment_mode_main'],
                            'request_date' => date('Y-m-d H:i:s'),
                            'cdate' => date('Y-m-d'),
                            'card_image' => 'NA',
                            'card_status' => '0',
                            'card_address' => 'NA',
                        );
                    $saved_data = $this->json_model->payment_request($sendData);
                    if ($saved_data) {
                        $data[] = array(
                            "status" => '1',
                            "msg" => "Request Sent Successfully",
                        );
                    } else {
                        $data[] = array(
                            "status" => '0',
                            "msg" => "Something Went To Wrong!",
                        );
                    }
                } else {
                    $data[] = array(
                        "status" => '0',
                        "msg" => "Unauthorized User!",
                    );
                }
            
        } catch (Exception $e) {
            $data[] = array(
                "status" => '10',
                "msg" => "Could not request Payment. Please try again!",
                'error' => "Error: " . $e->getMessage()
            );
        }
        echo json_encode(array("result" => $data));
    }
    
    
    public function getIFSC(){
		
	    $this->db->select("*");
		$q = $this->db->get('bank_details');
		$rr = $q->num_rows();
		if(1==1){
		    $result = $q->result_array();
		    foreach($result as $result){
    		    $bank_name = $result['bank_name'];
    		    $ifsc = $result['ifsc'];
    		    $image='';
    		    $res[] = array("operator_code"=>$ifsc,"operator_name"=>$bank_name,"image"=>$image);
		    }
		    echo json_encode(array("operators"=>$res));
		}
		
           
    }
    
    public function EzbWireCallBack(){
        $postData = json_decode(file_get_contents('php://input'), true);
        if($postData) {
            $amount = $postData['data']['amount'];
            $status = $postData['data']['status'];
            $unique_request_number = $postData['data']['unique_request_number'];
            $unique_transaction_reference = $postData['data']['unique_transaction_reference'];
            $narration = $postData['data']['narration'];
            if($narration=="ST"){
                if($status=="failure" || $status=="failed" || $status=="Failure" || $status=="Failed"){
                    $update_array = array(
                    'satelment' => 0,
                    'settlement_result'=>$status
                );
                $update = $this->json_model->update_settlement_details($update_array, $unique_request_number);
                }else{
                     $update_array = array(
                    'settlement_result'=>$status,
                    'settlement_no'=>$unique_transaction_reference
                );
                $update = $this->json_model->update_settlement_details($update_array, $unique_request_number);
                }
            }else{
                
                $this->db->select('*');
            $this->db->from('transfer_request');
            $this->db->where('ref_no',$unique_request_number);
            $query = $this->db->get();
            $num_rowt = $query->num_rows();
            if ($num_rowt > 0) {
                $result = $query->row();
                
                $update_array = array(
                    'bank_refence_no' => $status.'+'.$unique_transaction_reference
                );
                $update = $this->transfer_request_model->update_trastion_details($update_array, $result->id);
                if($update) {
                    $this->db->select('*');
                    $this->db->from('register_users');
                    $this->db->where('id',$result->user_id);
                    $query_user = $this->db->get(); 
                    $result_user = $query_user->row();
                    if($status == 'success') {
                        $mobile_no = $result_user->mobile_no;
                        $api_url = "https://2factor.in/API/R1/?module=TRANS_SMS&apikey=938b2f31-2485-11ee-addf-0200cd936042&to=$mobile_no&from=PAYMYC&templatename=payment+proceed&var1=$amount&var2=$unique_transaction_reference";
                        $ch = curl_init($api_url);
                        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "GET");
                        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/xml'));
                        $result = curl_exec($ch);
                    }elseif($status == 'failure'){
                        $update_array_status = array(
                            'status' => '0'
                        );
                        $update_status = $this->transfer_request_model->update_trastion_details($update_array_status, $result->id);
                    }
                }
            }
            
            }
            
            
        }
    }
    
    public function check_rcode() {
        try {
            $data = array();
            $rcode = $this->input->post('rcode');
            $this->db->select('*');
            $this->db->where('referral_no', $rcode);
            $q = $this->db->get('register_users');
            $r = $q->row();
            
            if(empty($r)){
                $data[] = array(
                        "status" => '0',
                    );
            }else {
                $data[] = array(
                        "status" => '1',
                    );
            }
        } catch (Exception $e) {
            $data[]['code'] = '10';
            $data[]['msg'] = "Could not register Mobile number. Please try again!";
            $data[]['error'] = "Error: " . $e->getMessage();
        }
        echo json_encode(array("result" => $data));
    }
    
    
    public function referralAmtWithdrawRequest(){
        try {
            $data = array();
            $post_data = $this->input->post();
            $token = $post_data['token'];
            $ftoken = $post_data['ftoken'];
            
            $amount = $post_data['amount'];
            $account_number = $post_data['account_number'];
            $account_holder_name = $post_data['account_holder_name'];
            $bank_name = $post_data['bank_name'];
            $address = $post_data['address'];
            $ifscCode = $post_data['ifsc_code'];
            
            $this->db->select('*');
            $this->db->where(['token' => $token, 'status' => 1]);
            $queryt = $this->db->get('apptoken');
            $num_rowt = $queryt->num_rows();
            if ($num_rowt > 0) {
                $this->db->select('*');
                $this->db->where(['uid' => $post_data['user_id'], 'ftoken' => $ftoken]);
                $query = $this->db->get('register_users');
                $num_rows = $query->num_rows();
                if ($num_rows > 0) {
                    $re = $query->row();
                    $userid = $re->id;
                    $mobile_no = $re->mobile_no;
                    
                    if($re->referral_wallet == $amount){
                        $insert = array(
                            'user_id' => $userid,
                            'amount' => $amount,
                            'account_number' => $account_number,
                            'account_holder_name' => $account_holder_name,
                            'bank_name' => $bank_name,
                            'address' => $address,
                            'ifsc_code' => $ifscCode
                        );
                        
                        $insertData = $this->db->insert('referral_request',$insert);
                        if($insertData) {
                            $wallet_historyA = array(
                                'user_id' => $userid,
                                'transation_id' => rand(100000,999999),
                                'opening_balance' => ($re->referral_wallet) ? $re->referral_wallet : 0,
                                'credit_balance' => 0,
                                'debit_balance' => $amount,
                                'closing_balance' => $re->referral_wallet - $amount,
                                'remark' => "Sent to bank account",
                                'tr_date' => date('Y-m-d')
                            );
                            $wallet_transtionA = $this->transfer_request_model->referral_wallet_transtion($wallet_historyA);
                            if($wallet_transtionA){
                                $update_walletA = array(
                                    'referral_wallet' => $re->referral_wallet - $amount,
                                );
                                $this->transfer_request_model->update_wallet($update_walletA,$userid);
                            }
                           $data[] = array(
                                "status" => '1',
                                "msg" => "Successfully Debited Referral Amount!",
                                "request_id" => "NA"
                            ); 
                        }
                    } else {
                        $data[] = array(
                            "status" => '0',
                            "msg" => "Enter Valid Amount!",
                            "request_id" => "NA"
                        );
                    }
                } else {
                    $data[] = array(
                        "status" => '0',
                        "msg" => "Unauthorized User!",
                        "request_id" => "NA"
                    );
                }
            } else {
                $data[] = array(
                    "status" => '0',
                    "msg" => "Unauthorized User!",
                    "request_id" => "NA"
                );
            }
        } catch (Exception $e) {
            $data[] = array(
                "status" => '10',
                "msg" => "Could not request Payment. Please try again!",
                'error' => "Error: " . $e->getMessage()
            );
        }
        echo json_encode(array("result" => $data));
    }
    
    public function referral_link(){
        $transaction_id = base64_encode($this->input->post('txnid'));
        $amount = base64_encode($this->input->post('amount'));
        $email = base64_encode($this->input->post('email'));
        $phone = base64_encode($this->input->post('phone'));
        
        $link = '<a href="'.base_url('pay/'.$transaction_id.'/'.$amount.'/'.$email.'/'.$phone).'">Click Here </a>';
        
        echo $link;
    }
    
    public function make_payment($txn_id,$amount,$email,$phone){
        $postData = array(
            'txnid' => base64_decode($txn_id),
            'amount' => base64_decode($amount),
            'email' => base64_decode($email),
            'phone' => base64_decode($phone)
        );
        $this->data['postData'] = $postData;
        $bc = array(array('link' => base_url(), 'page' => 'Dashboard'));
        $meta = array('page_title' => 'Make Payment', 'bc' => $bc);
        $this->page_construct_web('admin/transfer_request/payment', $meta, $this->data);
        
    }
    
    public function recharge_gateway_transaction(){
        try {
            $data = array();
            $post_data = $this->input->post();
            $token = $post_data['token'];
            $ftoken = $post_data['ftoken'];
            $user_id=$post_data['user_id'];
            
            if(!empty($token)){
                $this->db->select('*');
                $this->db->where(['token' => $token, 'status' => '1']);
                $queryt = $this->db->get('apptoken');
                $num_rowt = $queryt->num_rows();
                if ($num_rowt > 0) {
                
                $this->db->select('*');
                $this->db->where(['uid' => $user_id, 'ftoken' => $ftoken]);
                $queryt1 = $this->db->get('register_users');
                $num_rowt1 = $queryt1->num_rows();
                // echo $this->db->last_query(); 
                if (!empty($num_rowt1)) {
                    // echo "in...";
                        $re = $queryt1->result_array();
                        $u_id = $re[0]['id'];
                        $email=$re[0]['email'];
                        $phone=$re[0]['mobile_no'];
                        
                        $this->db->select('*');
                        $this->db->where(['transaction_id' => $post_data['transaction_id']]);
                        $queryt2 = $this->db->get('recharge_gateway_transaction');
                        $num_rowt2 = $queryt2->num_rows();
                        if ($num_rowt2 > 0) {
                            $data[] = array(
                                    "status" => '0',
                                    "msg" => "already exist",
                                     "request_id" => "NA"
                                );
                        }else{
                                $sendData = array(
                                    'user_id' => $u_id,
                                    'amount' => $post_data['amount'],
                                    'holder_name' => $post_data['holder_name'],
                                    'address' => $post_data['address'],
                                    'card_number' => $post_data['card_number'],
                                    'payment_channel' => $post_data['payment_channel'],
                                    'payment_mode' => $post_data['payment_mode'],
                                    'mobile_number' => $post_data['mobile_number'],
                                    'operator_id' => $post_data['operator_id'],
                                    'transaction_id' => $post_data['transaction_id'],
                                    'merchant_id' => $post_data['merchant_id'],
                                    'response_message' => $post_data['response_message'],
                                );
                                $saved_data = $this->db->insert('recharge_gateway_transaction', $sendData);
                                $lastid = $this->db->insert_id();
                                
                                // $data[] = array(
                                //     "status" => '1',
                                //     "msg" => "Request Sent Successfully",
                                //     "request_id" => "$saved_data"
                                // );
                                
                                $amount_float=$post_data['amount']. ".0";
                                  $hashvalue = 'NCJSW96VLZ|'.$post_data['transaction_id'].'|'.$amount_float.'|'.$email.'|'.$phone.'|I7SH065KJY';
                                   $hashed_value = hash('sha512', $hashvalue);
                               
                                $passArray = array(
                                    'key' => "NCJSW96VLZ",
                                    'hash' => $hashed_value,
                                    'txnid' => $post_data['transaction_id'],
                                    'amount' => $post_data['amount'],
                                    'email' => $email,
                                    'phone' => $phone,
                                    
                                );
                               
                                  $encodeArray = json_encode($passArray);
                                //  print_r($encodeArray);
                               
                                $curl = curl_init();
                                curl_setopt_array($curl, array(
                                    CURLOPT_URL => 'https://dashboard.easebuzz.in/transaction/v1/retrieve',
                                    CURLOPT_RETURNTRANSFER => true,
                                    CURLOPT_ENCODING => '',
                                    CURLOPT_MAXREDIRS => 10,
                                    CURLOPT_TIMEOUT => 0,
                                    CURLOPT_FOLLOWLOCATION => true,
                                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                    CURLOPT_CUSTOMREQUEST => 'POST',
                                    CURLOPT_POSTFIELDS => "$encodeArray",
                                    CURLOPT_HTTPHEADER => array(
                                        'Content-Type: application/json',
                                        'Accept: application/json'
                                        // 'Authorization:'.$hashed_value
                                    )
                                ));
                
                                  $response = curl_exec($curl); 
                                curl_close($curl);
                                 $jsonDecode = json_decode($response);
                                //  print_r($jsonDecode);
                                
                                   
                                //  $jsonDecode->status;
                                // exit;
                                if($jsonDecode->status=="true" || $jsonDecode->status==1){
                                    $error = $jsonDecode->msg->error;
                                    if($error = "ResponseCode : 00 (Transaction Successful) - Successful transaction" || $error="Success"){
                                        
                                        $this->db->select('*');
                                    $this->db->where(['recharge_status' => '0','user_id'=>$u_id]);
                                    $queryt4 = $this->db->get('recharge_gateway_transaction');
                                    $num_rowt4 = $queryt4->num_rows();
                                    if ($num_rowt4 > 0) {
                                        // echo "recharge status in";
                                        $arrData = array(
                                        'recharge_status' => "1"
                                        );
                                        //echo "<pre>";print_r($arrData);exit;
                                        $this->db->where(['recharge_status' => 0,'user_id'=>$u_id]);
                                        $this->db->update('recharge_gateway_transaction', $arrData);
                                    }
                                
                                
                                        //----------make recharge fun copy----------------//
                                        
                                        $data = array();
                                        // $uid = $this->input->post('uid');
                                        // $token = $this->input->post('token');
                                        // $ftoken = $this->input->post('ftoken');
                                        // $amount = $this->input->post('amount');
                                        $opname = $post_data['operator_id'];
                                        // $mobile_number = $this->input->post('mobile_number');
                                        $order_id = mt_rand();
                                        
                                        $op_id = 0;
                                        $operatorName = "";
                                        $query = $this->db->query("select * from register_users where ftoken='$ftoken' and uid='$user_id' and user_status='1'");
                                        $num_rows = $query->num_rows();
                                        if ($num_rows > 0) {
                                            $result = $query->row();
                                            
                                            $query_kyc = $this->db->query("select * from users_documents where pancard_status='1' and adhar_card_front_status='1' and adhar_card_back_status='1' and selfee_image_status='1' and user_id = '".$result->id."'");
                                            $num_rows_kyc = $query_kyc->num_rows();
                                            if ($num_rows_kyc > 0) {
                                                
                                            $this->db->select('*');
                                            $this->db->where(['token' => $token, 'status' => 1]);
                                            $queryt = $this->db->get('apptoken');
                                            $num_rowt = $queryt->num_rows();
                                            if ($num_rowt > 0) {
                                                // if($result->wallet >= $post_data['amount']) {
                                                    $checkService = $this->json_model->checkService($post_data['operator_id']);
                                                    if(empty($checkService)) {
                                                        $data[] = array(
                                                            "status" => '0',
                                                            "msg" => "Service Down Now!",
                                                        ); 
                                                    } else {
                                                    
                                                    if($opname == "airtel_prepaid"){
                                                        $op_id = '1';
                                                        $operatorName = "Airtel Prepaid";
                                                    } else if($opname == "idea_prepaid"){
                                                        $op_id = '3';
                                                        $operatorName = "Idea Prepaid";
                                                    } else if($opname == "vodafone_prepaid"){
                                                        $op_id = '3';
                                                        $operatorName = "Vodafone Prepaid";
                                                    } else if($opname == "jio_prepaid"){
                                                        $op_id = '8';
                                                        $operatorName = "Jio Prepaid";
                                                    } else if($opname == "idea_postpaid"){
                                                        $op_id = '49';
                                                        $operatorName = "Idea Postpaid";
                                                    } else if($opname == "airtel_postpaid") {
                                                         $op_id = '48';
                                                         $operatorName = "Airtel Postpaid";
                                                    }else if($opname == "vodafone_postpaid") {
                                                        $op_id = '29';
                                                        $operatorName = "Vodafone Postpaid";
                                                    }
                                                    $amount_final= intval($jsonDecode->msg->amount);
                                                    $api_url = "";
                                                    if($opname == "idea_postpaid" || $opname == "airtel_postpaid" || $opname == "vodafone_postpaid"){
                                                        $api_url = "https://www.kwikapi.com/api/v2/bills/recharge.php?api_key=55bd32-b2d22f-362a09-09680b-3c89ed&number=".$post_data['mobile_number']."&amount=".$amount_final."&opid=".$op_id."&state_code=0&order_id=".$order_id."";
                                                    } else {
                                                        $api_url = "https://www.kwikapi.com/api/v2/recharge.php?api_key=55bd32-b2d22f-362a09-09680b-3c89ed&number=".$post_data['mobile_number']."&amount=".$amount_final."&opid=".$op_id."&state_code=0&order_id=".$order_id."";
                                                    }
                                
                                        			$ch = curl_init($api_url);
                                        			curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "GET");
                                        			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                                        			curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/xml'));
                                        			$result_response = curl_exec($ch);
                                        			$response = json_decode($result_response);
                                        			if($response->status == 'PENDING' || $response->status == 'SUCCESS') {
                                        			    $recharge = array(
                                        			        'rdate' => date('Y-m-d'),
                                        			        'user_id' => $result->id,
                                        			        /*'recharge_number' => $response->number,*/
                                        			        
                                        			        'recharge_number' => $post_data['mobile_number'],
                                        			        
                                        			        'operator_name' => $operatorName,
                                        			        'operator_id' => ($response->opr_id == '') ? 'PENDING' : $response->opr_id,
                                        			        'amount' => $response->amount,
                                        			        'opening_balance' => $result->wallet,
                                        			        'closing_balance' => $result->wallet,
                                        			        'api_orderid' => $response->order_id,
                                        			        'my_orderid' => $order_id,
                                        			        'message' => $response->message,
                                        			        'status' => $response->status
                                        			        );
                                        			     $insertRecharge = $this->json_model->insert_rechage_info($recharge);   
                                        			     //if($insertRecharge) {
                                        			     //   $wallet_history = array(
                                                //                 'user_id' => $result->id,
                                                //                 'transation_id' => rand(100000,999999),
                                                //                 'opening_balance' => $result->wallet,
                                                //                 'credit_balance' => 0,
                                                //                 'debit_balance' => $response->amount,
                                                //                 'closing_balance' => $result->wallet - $response->amount,
                                                //                 'remark' => "Successful Mobile Recharge",
                                                //                 'tr_date' => date('Y-m-d')
                                                //                 );
                                                            // $wallet_transtion = $this->transfer_request_model->wallet_transtion($wallet_history);
                                                           
                                        			         if($insertRecharge) {
                                        			               
                                                                    $data[] = array(
                                                                        "status" => '1',
                                                                        "msg" => $response->message,
                                                                    );
                                                                
                                        			        }
                                        			     
                                        			         
                                        			     
                                        			        
                                        			} else if($response->status == 'FAILED') {
                                        			    
                                        			   $recharge = array(
                                        			        'rdate' => date('Y-m-d'),
                                        			        'user_id' => $result->id,
                                        			        'recharge_number' => $post_data['mobile_number'],
                                        			        'operator_name' => $operatorName,
                                        			        'operator_id' => 'NA',
                                        			        'amount' => $jsonDecode->msg->amount,
                                        			        'opening_balance' => $result->wallet,
                                        			        'closing_balance' => $result->wallet + $jsonDecode->msg->amount,
                                        			        'api_orderid' => 'NA',
                                        			        'my_orderid' => $order_id,
                                        			        'message' => $response->message,
                                        			        'status' => $response->status
                                        			        );
                                        			     $insertRecharge = $this->json_model->insert_rechage_info($recharge);  
                                        			     
                                        			     //---------------------callback----------------//
                                        			      $wallet_history = array(
                                                            'user_id' => $u_id,
                                                            'transation_id' => rand(100000,999999),
                                                            'opening_balance' => $result->wallet,
                                                            'credit_balance' => $jsonDecode->msg->amount,
                                                            'debit_balance' => 0,
                                                            'closing_balance' => $result->wallet + $jsonDecode->msg->amount,
                                                            'remark' => "Refund amount of failed Mobile Recharge",
                                                            'tr_date' => date('Y-m-d')
                                                            );
                                                        $wallet_transtion = $this->transfer_request_model->wallet_transtion($wallet_history);
                                                        $updateA = array(
                                                		    'wallet' => $result->wallet + $jsonDecode->msg->amount
                                                	    );
                                                        $updateWallet= $this->json_model->update_user_photo($updateA,$u_id); 
                                                        
                                        			      if($insertRecharge) {
                                        			        $data[] = array(
                                                                "status" => '0',
                                                                "msg" => $response->message,
                                                            );
                                        			    }
                                        			}
                                                }
                                                } else {
                                                  $data[] = array(
                                                        "status" => '0',
                                                        "msg" => "Low Wallet Balance!",
                                                    );  
                                                }
                                            } else {
                                                $data[] = array(
                                                    "status" => '0',
                                                    "msg" => "Unauthorized User!",
                                                ); 
                                            }
                                        } else {
                                            $data[] = array(
                                                "status" => '0',
                                                "msg" => "Unauthorized User!",
                                            );
                                        }
                                    } else {
                                      $data[] = array(
                                                "status" => '0',
                                                "msg" => "Unauthorized User!",
                                            ); 
                                    }
                                        echo json_encode(array("result" => $data));
    
                                        
                                
                                
                                    }
                            } 
                        }
                    
                    else {
                    $data[] = array(
                        "status" => '0',
                        "msg" => "Unauthorized User register!",
                        "request_id" => "NA"
                    );
                }
                } else {
                    $data[] = array(
                        "status" => '0',
                        "msg" => "Unauthorized User apptoken!",
                        "request_id" => "NA"
                    );
                }
          }else{
              $data[] = array(
                    "status" => '0',
                    "msg" => "Unauthorized User!",
                    "request_id" => "NA"
                );
          }
            
        } catch (Exception $e) {
            $data[] = array(
                "status" => '0',
                "msg" => "Could not request Payment. Please try again!",
                'error' => "Error: " . $e->getMessage()
            );
        }
        
        
        echo json_encode(array("result" => $data));
        
        
    }
    
    public function make_recharge(){
        $data = array();
        $uid = $this->input->post('uid');
        $token = $this->input->post('token');
        $ftoken = $this->input->post('ftoken');
        $amount = $this->input->post('amount');
        $opname = $this->input->post('opname');
        $mobile_number = $this->input->post('mobile_number');
        $order_id = mt_rand();
        
        $op_id = 0;
        $operatorName = "";
        $query = $this->db->query("select * from register_users where ftoken='$ftoken' and uid='$uid' and user_status='1'");
        $num_rows = $query->num_rows();
        if ($num_rows > 0) {
            $result = $query->row();
            
            $query_kyc = $this->db->query("select * from users_documents where pancard_status='1' and adhar_card_front_status='1' and adhar_card_back_status='1' and selfee_image_status='1' and user_id = '".$result->id."'");
            $num_rows_kyc = $query_kyc->num_rows();
            if ($num_rows_kyc > 0) {
            $this->db->select('*');
            $this->db->where(['token' => $token, 'status' => 1]);
            $queryt = $this->db->get('apptoken');
            $num_rowt = $queryt->num_rows();
            if ($num_rowt > 0) {
                if($result->wallet >= $amount) {
                    $checkService = $this->json_model->checkService($opname);
                    if(empty($checkService)) {
                        $data[] = array(
                            "status" => '0',
                            "msg" => "Service Down Now!",
                        ); 
                    } else {
                    
                    if($opname == "airtel_prepaid"){
                        $op_id = '1';
                        $operatorName = "Airtel Prepaid";
                    } else if($opname == "idea_prepaid"){
                        $op_id = '3';
                        $operatorName = "Idea Prepaid";
                    } else if($opname == "vodafone_prepaid"){
                        $op_id = '3';
                        $operatorName = "Vodafone Prepaid";
                    } else if($opname == "jio_prepaid"){
                        $op_id = '8';
                        $operatorName = "Jio Prepaid";
                    } else if($opname == "idea_postpaid"){
                        $op_id = '49';
                        $operatorName = "Idea Postpaid";
                    } else if($opname == "airtel_postpaid") {
                         $op_id = '48';
                         $operatorName = "Airtel Postpaid";
                    }else if($opname == "vodafone_postpaid") {
                        $op_id = '29';
                        $operatorName = "Vodafone Postpaid";
                    }
                    
                    $api_url = "";
                    if($opname == "idea_postpaid" || $opname == "airtel_postpaid" || $opname == "vodafone_postpaid"){
                        $api_url = "https://www.kwikapi.com/api/v2/bills/recharge.php?api_key=55bd32-b2d22f-362a09-09680b-3c89ed&number=".$mobile_number."&amount=".$amount."&opid=".$op_id."&state_code=0&order_id=".$order_id."";
                    } else {
                        $api_url = "https://www.kwikapi.com/api/v2/recharge.php?api_key=55bd32-b2d22f-362a09-09680b-3c89ed&number=".$mobile_number."&amount=".$amount."&opid=".$op_id."&state_code=0&order_id=".$order_id."";
                    }

        			$ch = curl_init($api_url);
        			curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "GET");
        			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        			curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/xml'));
        			$result_response = curl_exec($ch);
        			$response = json_decode($result_response);
        			if($response->status == 'PENDING' || $response->status == 'SUCCESS') {
        			    $recharge = array(
        			        'rdate' => date('Y-m-d'),
        			        'user_id' => $result->id,
        			       /* 'recharge_number' => $response->number,*/
        			       
        			       'recharge_number' => $mobile_number,
        			       
        			        'operator_name' => $operatorName,
        			        'operator_id' => ($response->opr_id == '') ? 'PENDING' : $response->opr_id,
        			        'amount' => $response->amount,
        			        'opening_balance' => $result->wallet,
        			        'closing_balance' => $result->wallet - $response->amount,
        			        'api_orderid' => $response->order_id,
        			        'my_orderid' => $order_id,
        			        'message' => $response->message,
        			        'status' => $response->status
        			        );
        			     $insertRecharge = $this->json_model->insert_rechage_info($recharge);   
        			     if($insertRecharge) {
        			        $wallet_history = array(
                                'user_id' => $result->id,
                                'transation_id' => rand(100000,999999),
                                'opening_balance' => $result->wallet,
                                'credit_balance' => 0,
                                'debit_balance' => $response->amount,
                                'closing_balance' => $result->wallet - $response->amount,
                                'remark' => "Successful Mobile Recharge",
                                'tr_date' => date('Y-m-d')
                                );
                            $wallet_transtion = $this->transfer_request_model->wallet_transtion($wallet_history);
        			     
        			         if($wallet_transtion) {
        			               $update = array(
        			                    'wallet' => $result->wallet - $response->amount
        			               );
                                $updateWallet= $this->json_model->update_user_photo($update,$result->id);
                                if($updateWallet){
                                    $data[] = array(
                                        "status" => '1',
                                        "msg" => $response->message,
                                    );
                                }
        			        }
        			     }
        			        
        			} else if($response->status == 'FAILED') {
        			    
        			   $recharge = array(
        			        'rdate' => date('Y-m-d'),
        			        'user_id' => $result->id,
        			        'recharge_number' => $mobile_number,
        			        'operator_name' => $operatorName,
        			        'operator_id' => 'NA',
        			        'amount' => $amount,
        			        'opening_balance' => $result->wallet,
        			        'closing_balance' => $result->wallet,
        			        'api_orderid' => 'NA',
        			        'my_orderid' => $order_id,
        			        'message' => $response->message,
        			        'status' => $response->status
        			        );
        			     $insertRecharge = $this->json_model->insert_rechage_info($recharge);    
        			      if($insertRecharge) {
        			        $data[] = array(
                                "status" => '0',
                                "msg" => $response->message,
                            );
        			    }
        			}
                }
                } else {
                   $data[] = array(
                        "status" => '0',
                        "msg" => "Low Wallet Balance!",
                    );  
                }
            } else {
                $data[] = array(
                    "status" => '0',
                    "msg" => "Unauthorized User!",
                ); 
            }
        } else {
            $data[] = array(
                "status" => '0',
                "msg" => "Unauthorized User!",
            );
        }
    } else {
       $data[] = array(
                "status" => '0',
                "msg" => "Unauthorized User!",
            ); 
    }
        echo json_encode(array("result" => $data));
    }
    
    public function wallet_transaction() {
        $data = array();
        $arrData = array();
        $ftoken = $this->input->post('ftoken');
        $token = $this->input->post('token');
        $uid = $this->input->post('uid');

        $query = $this->db->query("select * from register_users where ftoken='$ftoken' and uid='$uid' and user_status='1'");
        $num_rows = $query->num_rows();
        if ($num_rows > 0) {
            $result = $query->row();
            
            $this->db->select('*');
            $this->db->where(['token' => $token, 'status' => 1]);
            $queryt = $this->db->get('apptoken');
            $num_rowt = $queryt->num_rows();
            if ($num_rowt > 0) {
                $wallet_history = $this->json_model->getWalletTransation($result->id);
                if($wallet_history) {
                    foreach($wallet_history as $wallet_historys){
                        $arrData['data'][] = array(
                            'date' => $wallet_historys->credited_at,
                            'transation_id' => $wallet_historys->transation_id,
                            'opening_balance' => $wallet_historys->opening_balance,
                            'credit_balance' => $wallet_historys->credit_balance,
                            'debit_balance' => $wallet_historys->debit_balance,
                            'closing_balance' => $wallet_historys->closing_balance,
                            'remark' => $wallet_historys->remark
                        );
                    }
                    $data[] = array('status'=>1,'msg'=>"success","total_amount"=>$result->wallet,'details'=>$arrData);
                } else {
                    $data[] = array('status'=>0,'msg'=>"Data Not Founds..");
                }
            }
        }
        echo json_encode(array("result" => $data));
    }
    
    public function link_request_ezb(){
        $arrData = array();
        $post_data = $this->input->post();
        $ftoken = $this->input->post('ftoken');
        $token = $this->input->post('token');
        $uid = $this->input->post('uid');
        $name = $this->input->post('name');
        $description = $this->input->post('description');
        $mobile = $this->input->post('mobile');
        $amount = $this->input->post('amount');
       
        
        $atoz=chr(rand(65,90));
        $number=rand(0000000000001,9999999999999);

        $merchant_id = $atoz.$number;
        
        $query = $this->db->query("select * from register_agent where ftoken='$ftoken' and uid='$uid' and user_status='1'");
        $num_rows = $query->num_rows();
        if ($num_rows > 0) {
            $result = $query->row();
            
            $this->db->select('*');
            $this->db->where(['token' => $token, 'status' => 1]);
            $queryt = $this->db->get('apptoken');
            $num_rowt = $queryt->num_rows();
            if ($num_rowt > 0) {
                $sendData = array(
                    'uid' => $result->id,
                    'name' => $post_data['name'],
                    'description' => $post_data['description'],
                    'mobile' => $post_data['mobile'],
                    'amount' => $post_data['amount'].".0",
                    'mer_id' => $merchant_id,
                    'api_name' => "Easebuzz"
                );
                $saved_data = $this->db->insert('link_request', $sendData);
                $lastid = $this->db->insert_id();
                $query1 = $this->db->query("select created_date,id,status from link_request where id='$lastid'");
                $num_rows1 = $query1->num_rows();
                 $result1 = $query1->row();
                if($saved_data){
                    $fname=base64_encode($result->fname);
                    $m_id=base64_encode($merchant_id);
                    $amt=base64_encode($post_data['amount'].".0");
                    $no=base64_encode($mobile);
                    $mail=base64_encode($name.'@gmail.com');
                    $time=base64_encode($result1->created_date);
                    $id=base64_encode($result1->id);
                    $status= $result1->status;
                    //  $link="https://paymychoice.com/adminP/pay/".base64_decode($merchant_id)."/".base64_decode($amount)."/".base64_decode($mobile);
                $data[] = array('status'=>1,'link'=>"https://payyourchoice.com/adminP/pay_terms/$id");
                    echo json_encode(array("result" => $data));
                }else{
                    $data[] = array('status'=>0,'msg'=>"Data Not Founds..");
                    echo json_encode(array("result" => $data));
                }
            }else{
                $data[] = array('status'=>0,'msg'=>"Ftoken not match");
                echo json_encode(array("result" => $data));
            }
        }else{
            $data[] = array('status'=>0,'msg'=>"User not found..");
            echo json_encode(array("result" => $data));
        }
                                
    }
    
    
    public function link_request_amxc(){
        $arrData = array();
        $post_data = $this->input->post();
        $ftoken = $this->input->post('ftoken');
        $token = $this->input->post('token');
        $uid = $this->input->post('uid');
        $name = $this->input->post('name');
        $description = $this->input->post('description');
        $mobile = $this->input->post('mobile');
        $amount = $this->input->post('amount');
       
        
        $atoz=chr(rand(65,90));
        $number=rand(0000000000001,9999999999999);

        $merchant_id = $atoz.$number;
        
        $query = $this->db->query("select * from register_agent where ftoken='$ftoken' and uid='$uid' and user_status='1'");
        $num_rows = $query->num_rows();
        if ($num_rows > 0) {
            $result = $query->row();
            
            $this->db->select('*');
            $this->db->where(['token' => $token, 'status' => 1]);
            $queryt = $this->db->get('apptoken');
            $num_rowt = $queryt->num_rows();
            if ($num_rowt > 0) {
                $sendData = array(
                    'uid' => $result->id,
                    'name' => $post_data['name'],
                    'description' => $post_data['description'],
                    'mobile' => $post_data['mobile'],
                    'amount' => $post_data['amount'].".0",
                    'mer_id' => $merchant_id,
                    'api_name' => "Easebuzz"
                );
                $saved_data = $this->db->insert('link_request', $sendData);
                $lastid = $this->db->insert_id();
                $query1 = $this->db->query("select created_date,id,status from link_request where id='$lastid'");
                $num_rows1 = $query1->num_rows();
                 $result1 = $query1->row();
                if($saved_data){
                    $fname=base64_encode($result->fname);
                    $m_id=base64_encode($merchant_id);
                    $amt=base64_encode($post_data['amount'].".0");
                    $no=base64_encode($mobile);
                    $mail=base64_encode($name.'@gmail.com');
                    $time=base64_encode($result1->created_date);
                    $id=base64_encode($result1->id);
                    $status= $result1->status;
                    //  $link="https://paymychoice.com/adminP/pay/".base64_decode($merchant_id)."/".base64_decode($amount)."/".base64_decode($mobile);
                $data[] = array('status'=>1,'link'=>"https://payyourchoice.com/adminP/pay_terms2/$id");
                    echo json_encode(array("result" => $data));
                }else{
                    $data[] = array('status'=>0,'msg'=>"Data Not Founds..");
                    echo json_encode(array("result" => $data));
                }
            }else{
                $data[] = array('status'=>0,'msg'=>"Ftoken not match");
                echo json_encode(array("result" => $data));
            }
        }else{
            $data[] = array('status'=>0,'msg'=>"User not found..");
            echo json_encode(array("result" => $data));
        }
                                
    }
    
    
    public function payment_terms($id){
        $postData = array(
            
            'id' => base64_decode($id),
        );
        $this->data['postData'] = $postData;
        $bc = array(array('link' => base_url(), 'page' => 'Dashboard'));
        $meta = array('page_title' => 'Payment Terms', 'bc' => $bc);
        $this->page_construct_web('admin/transfer_request/payment_terms', $meta, $this->data);
        
    }
    
     public function payment_terms2($id){
        $postData = array(
            
            'id' => base64_decode($id),
        );
        $this->data['postData'] = $postData;
        $bc = array(array('link' => base_url(), 'page' => 'Dashboard'));
        $meta = array('page_title' => 'Payment Terms', 'bc' => $bc);
        $this->page_construct_web('admin/transfer_request/payment_terms2', $meta, $this->data);
        
    }
    
    public function get_agent_bene(){
        $data = array();
        $ftoken = $this->input->post('ftoken');
        $token = $this->input->post('token');
        $uid = $this->input->post('uid');

        $query = $this->db->query("select * from register_agent where ftoken='$ftoken' and uid='$uid' and user_status='1'");
        $num_rows = $query->num_rows();
        if ($num_rows > 0) {
            $result = $query->row();
            $this->db->select('*');
            $this->db->where(['token' => $token, 'status' => 1]);
            $queryt = $this->db->get('apptoken');
            $num_rowt = $queryt->num_rows();
            if ($num_rowt > 0) {
                $saved_data = $this->json_model->getAgentBeneficaryList($result->id);
                if ($saved_data) {
                    $data[] = array(
                        "status" => '1',
                        "ac_name" => $saved_data->name,
                        "bank_name" => $saved_data->bank_name,
                        "ifsc_code" => $saved_data->ifsc_code,
                        "ac_number" => $saved_data->account_no,
                        "mobile_no" => $saved_data->mobile_no
                    );
                } else {
                    $data[] = array(
                        "status" => '0',
                        "ac_name" => 'NA',
                        "bank_name" => 'NA',
                        "ifsc_code" => 'NA',
                        "ac_number" => 'NA',
                        "mobile_no" => 'NA'
                    );
                }
            } else {
                $data[] = array(
                    "status" => '10',
                    "msg" => "Could not user. Please try again!",
                    'error' => "Error: " . $e->getMessage()
                );
            }
        }
        echo json_encode(array("result" => $data));
    }
    
    public function ShortHistory(){
        $data = array();
        $ftoken = $this->input->post('ftoken');
        $token = $this->input->post('token');
        $uid = $this->input->post('uid');
        $fdate = $this->input->post('fdate');
        $tdate = $this->input->post('tdate');
        $taka = $this->input->post('taka');
        
        $query = $this->db->query("select * from register_agent where ftoken='$ftoken' and uid='$uid' and user_status='1'");
        $num_rows = $query->num_rows();
        if ($num_rows > 0) {
            $result = $query->row();
            $this->db->select('*');
            $this->db->where(['token' => $token, 'status' => 1]);
            $queryt = $this->db->get('apptoken');
            $num_rowt = $queryt->num_rows();
            if ($num_rowt > 0) {
                $saved_data_paid = $this->json_model->get_total_amount_paid($fdate,$tdate,$result->id); 
                $saved_data_recive = $this->json_model->get_total_amount_recive($fdate,$tdate,$result->id); 
                // print_r($saved_data_paid); print_r($saved_data_recive);
                // echo $this->db->last_query(); exit;
                if(!empty($saved_data_recive->total)){
                    // $rec_val=$saved_data_recive->total-($saved_data_recive->total * $taka)/100 ;
                    //  $recived_value = ''.round($rec_val,2).'';
                    $recived_value=$saved_data_recive->total;
                }else{
                    $recived_value = '0.00';
                }
                
                if (!empty($saved_data_paid->total)) {
                    $data[] = array(
                        "status" => '1',
                        "paid" => $saved_data_paid->total,
                        "recive" => $recived_value
                    );
                } else {
                    $data[] = array(
                        "status" => '0',
                        "paid" => '0.00',
                        "recive" => $recived_value
                    );
                }
            }else{
                $data[] = array(
                        "status" => '0',
                        "paid" => '0.00',
                        "recive" => '0.00'
                    );
            }
        }else{
            $data[] = array(
                        "status" => '0',
                        "paid" => '0.00',
                        "recive" => '0.00'
                    );
        }
        echo json_encode(array("result" => $data));
    }
    
    public function PaidHistory(){
           $uid = $this->input->post('uid');
           $token = $this->input->post('token');
           $ftoken = $this->input->post('ftoken');
           $fdate = $this->input->post('fdate');
           $tdate = $this->input->post('tdate');
           
           $this->db->select('*');
           $this->db->where(['uid'=>$uid, 'ftoken'=>$ftoken,'user_status'=>'1']);
           $query = $this->db->get('register_agent');
           $num_row = $query->num_rows();
                if($num_row > 0){
                    $this->db->select('*');
                   $this->db->where(['token'=>$token,'status'=>1]);
                   $queryt = $this->db->get('apptoken');
                   $num_rowt = $queryt->num_rows();
                        if($num_rowt > 0){
                           $login_id = $query->result_array();
                            $userid = $login_id[0]['id'];
                        //   $allUser = $this->json_model->getAllAgentData($fdate,$tdate,$result->id);
                   
                   
                   
                   if($fdate){ 
                       $fdate = "$fdate 00:00:00";
                       if($tdate){ 
                           $tdate = "$tdate 23:59:59";
                           $aadata = array();
                           $this->db->select('*');
                           if($uid == '8696956855336699'){
                               
                           }else{
                               $this->db->where('uid',$userid);
                           }
                           if(!empty($fdate) && empty($tdate))
                               {
                                   $this->db->where("created_date",$fdate);
                               }
                               elseif(!empty($tdate) && empty($fdate))
                               {
                                   $this->db->where("created_date",$tdate);
                               }
                               elseif(!empty($fdate) && !empty($tdate))
                               {
                                   $this->db->where("created_date >=",$fdate);
                                   $this->db->where("created_date <=",$tdate);
                               }else{
                                   $this->db->where("created_date >=",date('Y-m-d h:i:s'));
                                   $this->db->where("created_date <=",date('Y-m-d h:i:s'));
                               }
                               $this->db->order_by('id desc');
                               $query1  = $this->db->get('link_request');
                                $num_rows = $query1->num_rows();
                            //echo $last = $this->db->last_query();exit;
                                if($num_rows > 0){
                                   $aadata = $query1->result_array();
                               
                                $userData=$aadata;
                                $arrDatas = array();
                                //echo "<pre>";print_r($aadata);exit;
                                   $operator_name='';$unamee='';$regid='';$TransactionId='';$operator='';
                                   if(!empty($aadata)){
                                            foreach($aadata as $row){
                                                if(!empty($row['name'])){
                                                    $name=$row['name'];
                                                }else{
                                                    $name='NA';
                                                }
                                                if(!empty($row['description'])){
                                                    $description=$row['description'];
                                                }else{
                                                    $description='NA';
                                                }
                                                if(!empty($row['mobile'])){
                                                    $mobile=$row['mobile'];
                                                }else{
                                                    $mobile='NA';
                                                }
                                                if(!empty($row['amount'])){
                                                    $amount=$row['amount'];
                                                }else{
                                                    $amount='NA';
                                                }
                                                // if($row['status']){
                                                    $status=$row['status'];
                                                // }else{
                                                //     $status='NA';
                                                // }
                                                if(!empty($row['mer_id'])){
                                                    $mer_id=$row['mer_id'];
                                                }else{
                                                    $mer_id='NA';
                                                }
                                                if(!empty($row['transaction_id'])){
                                                    $transaction_id=$row['transaction_id'];
                                                }else{
                                                    $transaction_id='NA';
                                                }
                                                if(!empty($row['payment_mode'])){
                                                    $payment_mode=$row['payment_mode'];
                                                }else{
                                                    $payment_mode='NA';
                                                }
                                                if(!empty($row['payment_type'])){
                                                    $payment_type=$row['payment_type'];
                                                }else{
                                                    $payment_type='NA';
                                                }
                                                if(!empty($row['card_number'])){
                                                    $card_number=$row['card_number'];
                                                }else{
                                                    $card_number='NA';
                                                }
                                                if(!empty($row['holder_name'])){
                                                    $holder_name=$row['holder_name'];
                                                }else{
                                                    $holder_name='NA';
                                                }
                                                if(!empty($row['bank_ref_no'])){
                                                    $bank_ref_no=$row['bank_ref_no'];
                                                }else{
                                                    $bank_ref_no='NA';
                                                }
                                                // if(!empty($row['satelment'])){
                                                    $satelment=$row['satelment'];
                                                // }else{
                                                //     $satelment='NA';
                                                // }
                                                if(!empty($row['settlement_datetime'])){
                                                    $settlement_datetime=$row['settlement_datetime'];
                                                }else{
                                                    $settlement_datetime='NA';
                                                }
                                                // if(!empty($row['settlement_no'])){
                                                    $settlement_no=$row['settlement_no'];
                                                // }else{
                                                //     $settlement_no='NA';
                                                // }
                                                // if(!empty($row['settlement_amount'])){
                                                    $settlement_amount=$row['settlement_amount'];
                                                // }else{
                                                //     $settlement_amount='NA';
                                                // }
                                                
                                                if(!empty($row['status'])){
                                                    $status=$row['status'];
                                                    if($status==1){
                                                        $responce_msg="Success";
                                                    }else{
                                                        $responce_msg='NA';
                                                    }
                                                    
                                                }else{
                                                    $responce_msg='NA';
                                                }
                                                if(!empty($row['trans_date'])){
                                                    $trans_date=$row['trans_date'];
                                                }else{
                                                    $trans_date='NA';
                                                }
                                                 $created_date=$row['created_date'];
                                               $arrData['data'][] = array(
                                                               'id' => $row['id'],
                                                               'username' => $name,
                                                               'description' => $description,
                                                               'mobile' => $mobile,
                                                               'amount' => $amount,
                                                               'status' => $status,
                                                               'mer_id' => $mer_id,
                                                               'transaction_id' => $transaction_id,
                                                               'payment_mode' => $payment_mode,
                                                               'payment_type' => $payment_type,
                                                               'card_number' => $card_number,
                                                               'holder_name' => $holder_name,
                                                               'bank_ref_no' => $bank_ref_no,
                                                               'satelment' => $satelment,
                                                               'settlement_datetime' => $settlement_datetime,
                                                               'settlement_no' => $settlement_no,
                                                               'settlement_amount' => $settlement_amount,
                                                               'responce_msg' => $responce_msg,
                                                               'created_date'=>$created_date,
                                                               'trans_date'=>$trans_date
                                                           );
                                            }
                                   }
                       
                       
                           $data[] = array('status'=>1,'msg'=>"success",'details'=>$arrData);
                        }else{
                            $data[] = array('status'=>0,'msg'=>"no data present");
                        }
                       }else{
                           $data[] = array('status'=>0,'msg'=>"Enter To Date..");
                       }
                   }else{
                       $data[] = array('status'=>0,'msg'=>"Enter From Date..");
                   }
                    }else{
                        $data[] = array('status'=>0,'msg'=>"Unauthorized User");
                    }
                       
        }else{
               $data[] = array('status'=>0,'msg'=>"Unauthorized User1");
           }
        
           
                echo json_encode(array("result"=>$data));
            }
            
    public function recharge_detail(){
           $uid = $this->input->post('uid');
           $token = $this->input->post('token');
           $ftoken = $this->input->post('ftoken');
           $id = $this->input->post('id');
           
           $this->db->select('*');
           $this->db->where(['uid'=>$uid, 'ftoken'=>$ftoken,'user_status'=>'1']);
           $query = $this->db->get('register_agent');
           $num_row = $query->num_rows();
                if($num_row > 0){
                    $this->db->select('*');
                   $this->db->where(['token'=>$token,'status'=>1]);
                   $queryt = $this->db->get('apptoken');
                   $num_rowt = $queryt->num_rows();
                        if($num_rowt > 0){
                           $login_id = $query->result_array();
                            $userid = $login_id[0]['id'];
                            $query1 = $this->db->query("select * from link_request where id='$id'");
                            $num_rows1 = $query1->num_rows();
                             $result1 = $query1->row();
                            if($num_rows1){
                                $float_amount=round($result1->amount);
                                $transaction_id=$result1->transaction_id;
                                $mobile=$result1->mobile;
                                $amount=$float_amount. ".0";
                                $email=$result1->name.'@gmail.com';
                                
                                  $hashvalue = 'NCJSW96VLZ|'.$transaction_id.'|'.$amount.'|'.$email.'|'.$mobile.'|I7SH065KJY';
                                    $hashed_value = hash('sha512', $hashvalue);
                               
                                $passArray = array(
                                    'key' => "NCJSW96VLZ",
                                    'hash' => $hashed_value,
                                    'txnid' => $transaction_id,
                                    'amount' => $amount,
                                    'email' => $email,
                                    'phone' => $mobile,
                                    
                                );
                               
                                  $encodeArray = json_encode($passArray);
                                //  print_r($encodeArray);
                               
                                $curl = curl_init();
                                curl_setopt_array($curl, array(
                                    CURLOPT_URL => 'https://dashboard.easebuzz.in/transaction/v1/retrieve',
                                    CURLOPT_RETURNTRANSFER => true,
                                    CURLOPT_ENCODING => '',
                                    CURLOPT_MAXREDIRS => 10,
                                    CURLOPT_TIMEOUT => 0,
                                    CURLOPT_FOLLOWLOCATION => true,
                                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                    CURLOPT_CUSTOMREQUEST => 'POST',
                                    CURLOPT_POSTFIELDS => "$encodeArray",
                                    CURLOPT_HTTPHEADER => array(
                                        'Content-Type: application/json',
                                        'Accept: application/json'
                                        // 'Authorization:'.$hashed_value
                                    )
                                ));
                
                                  $response = curl_exec($curl); 
                                //   print_r($curl);
                                curl_close($curl);
                                 $jsonDecode = json_decode($response);
                                //  print_r($jsonDecode);
                                
                                if($jsonDecode->status==1){
                                    $txnid = $jsonDecode->msg->txnid;
                                    $amount = $jsonDecode->msg->amount;
                                    $mode = $jsonDecode->msg->mode;
                                    $easepayid = $jsonDecode->msg->easepayid;
                                    $name_on_card = $jsonDecode->msg->name_on_card;
                                    $cardnum = $jsonDecode->msg->cardnum;
                                    $error_Message = $jsonDecode->msg->error_Message;
                                    $addedon = $jsonDecode->msg->addedon;
                                    
                                
                                $arrData = array(
                                        'txnid' => $txnid,
                                        'amount' => $amount,
                                        'mode' => $mode,
                                        'easepayid' => $easepayid,
                                        'name_on_card' => $name_on_card,
                                        'cardnum' => $cardnum,
                                        'error_Message' => $error_Message,
                                        'addedon' => $addedon
                                        );
                                        $data[] = array('status'=>1,'msg'=>"success",'details'=>$arrData);
                                }
                                
                            // $data[] = array('status'=>1,'link'=>"https://paymychoice.com/adminP/pay_terms/$m_id/$amt/$mail/$no/$fname/$time/$id/$status");
                                echo json_encode(array("result" => $data));
                            }else{
                                $data[] = array('status'=>0,'msg'=>"Data Not Founds..");
                                echo json_encode(array("result" => $data));
                            }
                        }
                }
    }
    
    public function satelment_history(){
           $uid = $this->input->post('uid');
           $token = $this->input->post('token');
           $ftoken = $this->input->post('ftoken');
           $fdate = $this->input->post('fdate');
           $tdate = $this->input->post('tdate');
           
           $this->db->select('*');
           $this->db->where(['uid'=>$uid, 'ftoken'=>$ftoken,'user_status'=>'1']);
           $query = $this->db->get('register_agent');
           $num_row = $query->num_rows();
                if($num_row > 0){
                    $this->db->select('*');
                   $this->db->where(['token'=>$token,'status'=>1]);
                   $queryt = $this->db->get('apptoken');
                   $num_rowt = $queryt->num_rows();
                        if($num_rowt > 0){
                           $login_id = $query->result_array();
                            $userid = $login_id[0]['id'];
                        //   $allUser = $this->json_model->getAllAgentData($fdate,$tdate,$result->id);
                   
                   
                   
                   if($fdate){ 
                       $fdate = "$fdate 00:00:00";
                       if($tdate){ 
                           $tdate = "$tdate 23:59:59";
                           $aadata = array();
                           $this->db->select('*');
                           if($uid == '8696956855336699'){
                               
                           }else{
                               $this->db->where('uid',$userid);
                           }
                           if(!empty($fdate) && empty($tdate))
                               {
                                   $this->db->where("settlement_datetime",$fdate);
                               }
                               elseif(!empty($tdate) && empty($fdate))
                               {
                                   $this->db->where("settlement_datetime",$tdate);
                               }
                               elseif(!empty($fdate) && !empty($tdate))
                               {
                                   $this->db->where("settlement_datetime >=",$fdate);
                                   $this->db->where("settlement_datetime <=",$tdate);
                               }else{
                                   $this->db->where("settlement_datetime >=",date('Y-m-d h:i:s'));
                                   $this->db->where("settlement_datetime <=",date('Y-m-d h:i:s'));
                               }
                               $this->db->order_by('id desc');
                               $query1  = $this->db->get('link_request');
                                $num_rows = $query1->num_rows();
                            //echo $last = $this->db->last_query();exit;
                                if($num_rows > 0){
                                   $aadata = $query1->result_array();
                               
                                $userData=$aadata;
                                $arrDatas = array();
                                //echo "<pre>";print_r($aadata);exit;
                                   $operator_name='';$unamee='';$regid='';$TransactionId='';$operator='';
                                   if(!empty($aadata)){
                                            foreach($aadata as $row){
                                                if(!empty($row['name'])){
                                                    $name=$row['name'];
                                                }else{
                                                    $name='NA';
                                                }
                                                if(!empty($row['description'])){
                                                    $description=$row['description'];
                                                }else{
                                                    $description='NA';
                                                }
                                                if(!empty($row['mobile'])){
                                                    $mobile=$row['mobile'];
                                                }else{
                                                    $mobile='NA';
                                                }
                                                if(!empty($row['amount'])){
                                                    $amount=$row['amount'];
                                                }else{
                                                    $amount='NA';
                                                }
                                                // if($row['status']){
                                                    $status=$row['status'];
                                                // }else{
                                                //     $status='NA';
                                                // }
                                                if(!empty($row['mer_id'])){
                                                    $mer_id=$row['mer_id'];
                                                }else{
                                                    $mer_id='NA';
                                                }
                                                if(!empty($row['transaction_id'])){
                                                    $transaction_id=$row['transaction_id'];
                                                }else{
                                                    $transaction_id='NA';
                                                }
                                                if(!empty($row['payment_mode'])){
                                                    $payment_mode=$row['payment_mode'];
                                                }else{
                                                    $payment_mode='NA';
                                                }
                                                if(!empty($row['payment_type'])){
                                                    $payment_type=$row['payment_type'];
                                                }else{
                                                    $payment_type='NA';
                                                }
                                                if(!empty($row['card_number'])){
                                                    $card_number=$row['card_number'];
                                                }else{
                                                    $card_number='NA';
                                                }
                                                if(!empty($row['holder_name'])){
                                                    $holder_name=$row['holder_name'];
                                                }else{
                                                    $holder_name='NA';
                                                }
                                                if(!empty($row['bank_ref_no'])){
                                                    $bank_ref_no=$row['bank_ref_no'];
                                                }else{
                                                    $bank_ref_no='NA';
                                                }
                                                // if(!empty($row['satelment'])){
                                                    $satelment=$row['satelment'];
                                                // }else{
                                                //     $satelment='NA';
                                                // }
                                                if(!empty($row['settlement_datetime'])){
                                                    $settlement_datetime=$row['settlement_datetime'];
                                                }else{
                                                    $settlement_datetime='NA';
                                                }
                                                // if(!empty($row['settlement_no'])){
                                                    $settlement_no=$row['settlement_no'];
                                                // }else{
                                                //     $settlement_no='NA';
                                                // }
                                                // if(!empty($row['settlement_amount'])){
                                                    $settlement_amount=$row['settlement_amount'];
                                                // }else{
                                                //     $settlement_amount='NA';
                                                // }
                                                if(!empty($row['settlement_result'])){
                                                    $responce_msg=$row['settlement_result'];
                                                }else{
                                                    $responce_msg='NA';
                                                }
                                                if(!empty($row['trans_date'])){
                                                    $trans_date=$row['trans_date'];
                                                }else{
                                                    $trans_date='NA';
                                                }
                                                 $created_date=$row['created_date'];
                                               $arrData['data'][] = array(
                                                               'id' => $row['id'],
                                                               'username' => $name,
                                                               'description' => $description,
                                                               'mobile' => $mobile,
                                                               'amount' => $amount,
                                                               'status' => $status,
                                                               'mer_id' => $mer_id,
                                                               'transaction_id' => $transaction_id,
                                                               'payment_mode' => $payment_mode,
                                                               'payment_type' => $payment_type,
                                                               'card_number' => $card_number,
                                                               'holder_name' => $holder_name,
                                                               'bank_ref_no' => $bank_ref_no,
                                                               'satelment' => $satelment,
                                                               'settlement_datetime' => $settlement_datetime,
                                                               'settlement_no' => $settlement_no,
                                                               'settlement_amount' => $settlement_amount,
                                                               'responce_msg' => $responce_msg,
                                                               'created_date'=>$created_date,
                                                               'trans_date'=>$trans_date
                                                           );
                                            }
                                   }
                       
                       
                           $data[] = array('status'=>1,'msg'=>"success",'details'=>$arrData);
                        }else{
                            $data[] = array('status'=>0,'msg'=>"no data present");
                        }
                       }else{
                           $data[] = array('status'=>0,'msg'=>"Enter To Date..");
                       }
                   }else{
                       $data[] = array('status'=>0,'msg'=>"Enter From Date..");
                   }
                    }else{
                        $data[] = array('status'=>0,'msg'=>"Unauthorized User");
                    }
                       
        }else{
               $data[] = array('status'=>0,'msg'=>"Unauthorized User1");
           }
        
           
                echo json_encode(array("result"=>$data));
            }
            
            
    public function send_link(){
                
        $uid = $this->input->post('uid');
        $token = $this->input->post('token');
        $ftoken = $this->input->post('ftoken');
        $mobile_number = $this->input->post('number');
        $amount = $this->input->post('amount');
        $link = $this->input->post('link');
        
        $this->db->select('*');
        $this->db->where(['uid'=>$uid, 'ftoken'=>$ftoken,'user_status'=>'1']);
        $query = $this->db->get('register_agent');
        $num_row = $query->num_rows();
        if($num_row > 0){
            $this->db->select('*');
            $this->db->where(['token'=>$token,'status'=>1]);
            $queryt = $this->db->get('apptoken');
            $num_rowt = $queryt->num_rows();
            if($num_rowt > 0){
                $login_id = $query->result_array();
                $userid = $login_id[0]['id']; 
                
                $api_url = "https://2factor.in/API/R1/?module=TRANS_SMS&apikey=938b2f31-2485-11ee-addf-0200cd936042&to=$mobile_number&from=PAYMYC&templatename=send+link&var1=$amount&var2=$link";
                $ch = curl_init($api_url);
                curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "GET");
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/xml'));
                $result = curl_exec($ch);
                $response = json_decode($result);
                if($response->Status == 'Success') {
                    $data[] = array('status'=>'1');
                } else {
                    $data[] = array('status'=>'0');
                }
                 
            } else {
                $data[] = array('status'=>'0');
            }
        }else {
            $data[] = array('status'=>'0');
        }
        
        echo json_encode(array("result"=>$data));
            
    }
    
    public function paid_history_webview($uid,$from_date="",$to_date=""){
        $data = array();
        
        $this->db->where('uid',$uid);
        $query = $this->db->get('register_agent');
        $num_row = $query->num_rows();
        $result = $query->row();
        
        
        if($from_date || $to_date){
            $querylink = $this->db->query("SELECT * FROM `link_request` WHERE `uid` = '$result->id' AND DATE(`trans_date`) >= '$from_date' AND DATE(`trans_date`) <= '$to_date'");
        } else {
            $querylink = $this->db->query("SELECT * FROM `link_request` WHERE `uid` = '$result->id' AND status = '1'");
        }
        
        $num_rowlink = $querylink->num_rows();
        $resultlink = $querylink->result();

        $this->data['wallet_transation'] = $resultlink;
        
        $bc = array(array('link' => base_url(), 'page' => 'Dashboard'));
        $meta = array('page_title' => 'Paid History', 'bc' => $bc);
        $this->page_construct_web('admin/transfer_request/paid_history_web_view', $meta, $this->data);
    }
    
    
    public function paid_recive_history_webview($uid,$from_date="",$to_date=""){
        $data = array();
        
        $this->db->where('uid',$uid);
        $query = $this->db->get('register_agent');
        $num_row = $query->num_rows();
        $result = $query->row();
        
        
        if($from_date || $to_date){
            $querylink = $this->db->query("SELECT * FROM `link_request` WHERE `uid` = '$result->id' AND DATE(`trans_date`) >= '$from_date' AND DATE(`trans_date`) <= '$to_date' AND satelment = '1'");
        } else {
            $querylink = $this->db->query("SELECT * FROM `link_request` WHERE `uid` = '$result->id' AND satelment = '1'");
        }
        
        $num_rowlink = $querylink->num_rows();
        $resultlink = $querylink->result();

        $this->data['wallet_transation'] = $resultlink;
        
        $bc = array(array('link' => base_url(), 'page' => 'Dashboard'));
        $meta = array('page_title' => 'Paid History', 'bc' => $bc);
        $this->page_construct_web('admin/transfer_request/paid_recive_history_web_view', $meta, $this->data);
    }
    
    
    public function paid_recive_All_history_webview($uid,$from_date="",$to_date=""){
        $data = array();
        
        $this->db->where('uid',$uid);
        $query = $this->db->get('register_agent');
        $num_row = $query->num_rows();
        $result = $query->row();
        
        
        if($from_date || $to_date){
            $querylink = $this->db->query("SELECT * FROM `link_request` WHERE `uid` = '$result->id' AND DATE(`trans_date`) >= '$from_date' AND DATE(`trans_date`) <= '$to_date'");
        } else {
            $querylink = $this->db->query("SELECT * FROM `link_request` WHERE `uid` = '$result->id'");
        }
        
        $num_rowlink = $querylink->num_rows();
        $resultlink = $querylink->result();

        $this->data['wallet_transation'] = $resultlink;
        
        $bc = array(array('link' => base_url(), 'page' => 'Dashboard'));
        $meta = array('page_title' => 'Paid History', 'bc' => $bc);
        $this->page_construct_web('admin/transfer_request/paid_recive_all_history_web_view', $meta, $this->data);
    }
    
    public function link_request(){
        
        $arrData = array();
        $post_data = $this->input->post();
        $ftoken = $this->input->post('ftoken');
        $token = $this->input->post('token');
        $uid = $this->input->post('uid');
        $name = $this->input->post('name');
        $description = $this->input->post('description');
        $mobile = $this->input->post('mobile');
        $amount = $this->input->post('amount');
        $front = base64_decode($this->input->post('front'));
        $back = base64_decode($this->input->post('back'));
        
        if(!empty($front) && $front!="NA"){
            $front_img = strtolower($name . '_' . $mobile);
            $filename_front = $front_img . '.' . 'png';
            $path1 = 'assets/uploads/agent_user_kyc/front/';
            file_put_contents($path1 . $filename_front, $front);
        }else{
            $filename_front="NA";
        }
        if(!empty($back) && $back!="NA"){
            $back_img = strtolower($name . '_' . $mobile);
            $filename_back = $back_img . '.' . 'png';
            $path2 = 'assets/uploads/agent_user_kyc/back/';
            file_put_contents($path2 . $filename_back, $back);
        }else{
            $filename_back="NA";
        }
        
        $atoz=chr(rand(65,90));
        $number=rand(000000000001,999999999999);

        $merchant_id = $atoz.$number;
        
        $query = $this->db->query("select * from register_agent where ftoken='$ftoken' and uid='$uid' and user_status='1'");
        $num_rows = $query->num_rows();
        if ($num_rows > 0) {
            $result = $query->row();
            
            $this->db->select('*');
            $this->db->where(['token' => $token, 'status' => 1]);
            $queryt = $this->db->get('apptoken');
            $num_rowt = $queryt->num_rows();
            if ($num_rowt > 0) {
                $sendData = array(
                    'uid' => $result->id,
                    'name' => $post_data['name'],
                    'description' => $post_data['description'],
                    'mobile' => $post_data['mobile'],
                    'amount' => $post_data['amount'].".0",
                    'mer_id' => $merchant_id,
                    'front_img' => $filename_front,
                    'back_img' => $filename_back,
                );
                $saved_data = $this->db->insert('link_request', $sendData);
                $lastid = $this->db->insert_id();
                $query1 = $this->db->query("select created_date,id,status from link_request where id='$lastid'");
                $num_rows1 = $query1->num_rows();
                 $result1 = $query1->row();
                if($saved_data){
                    $this->db->select('*');
                    $querynew = $this->db->get('agentApiService');
                    $num_rowsnew = $querynew->result_array();
                    // print_r($num_rowsnew);
                    // if($num_rowsnew[2]['status']==0){
                    //     $api_name="Balue Enterprises";
                    // }elseif($num_rowsnew[2]['status']==1){
                    //     $api_name="PAYMYCHOICE";
                    // }else{
                    //     $api_name="PAYMYCHOICE";
                    // }
                    // if($num_rowsnew[2]['status']==1){
                    //      $api_name="PAYMYCHOICE";
                    // }elseif($num_rowsnew[3]['status']==1){
                    //     $api_name="Balue Enterprises";
                    // }elseif($num_rowsnew[4]['status']==1){
                    //     $api_name="Sun Enterprises";
                    // }elseif($num_rowsnew[5]['status']==1){
                    //     $api_name="Surya Enterprises";
                    // }else{
                    //     $api_name="PAYMYCHOICE";
                    // }
                    $api_name="Surya Enterprises";
                    
                    $fname=base64_encode($result->fname);
                    $m_id=base64_encode($merchant_id);
                    $amt=base64_encode($post_data['amount'].".0");
                    $no=base64_encode($mobile);
                    $mail="";
                    $time=base64_encode($result1->created_date);
                    $id=base64_encode($result1->id);
                    $api_name_b=base64_encode($api_name);
                    $status= $result1->status;
                    //  $link="https://paymychoice.com/adminP/pay/".base64_decode($merchant_id)."/".base64_decode($amount)."/".base64_decode($mobile);
                $data[] = array('status'=>1,'link'=>"https://payyourchoice.com/adminP/pay_terms_razorpay/$m_id/$amt/$no/$fname/$time/$id/$status/$api_name_b");
                    echo json_encode(array("result" => $data));
                }else{
                    $data[] = array('status'=>0,'msg'=>"Data Not Founds..");
                    echo json_encode(array("result" => $data));
                }
            }else{
                $data[] = array('status'=>0,'msg'=>"Ftoken not match");
                echo json_encode(array("result" => $data));
            }
        }else{
            $data[] = array('status'=>0,'msg'=>"User not found..");
            echo json_encode(array("result" => $data));
        }
                                
    
    }
    
    
    public function link_request_amxcc(){
        
        $arrData = array();
        $post_data = $this->input->post();
        $ftoken = $this->input->post('ftoken');
        $token = $this->input->post('token');
        $uid = $this->input->post('uid');
        $name = $this->input->post('name');
        $description = $this->input->post('description');
        $mobile = $this->input->post('mobile');
        $amount = $this->input->post('amount');
        $front = base64_decode($this->input->post('front'));
        $back = base64_decode($this->input->post('back'));
        
        if(!empty($front) && $front!="NA"){
            $front_img = strtolower($name . '_' . $mobile);
            $filename_front = $front_img . '.' . 'png';
            $path1 = 'assets/uploads/agent_user_kyc/front/';
            file_put_contents($path1 . $filename_front, $front);
        }else{
            $filename_front="NA";
        }
        if(!empty($back) && $back!="NA"){
            $back_img = strtolower($name . '_' . $mobile);
            $filename_back = $back_img . '.' . 'png';
            $path2 = 'assets/uploads/agent_user_kyc/back/';
            file_put_contents($path2 . $filename_back, $back);
        }else{
            $filename_back="NA";
        }
        
        $atoz=chr(rand(65,90));
        $number=rand(00000000001,99999999999);

        $merchant_id = $atoz.$number;
        
        $query = $this->db->query("select * from register_agent where ftoken='$ftoken' and uid='$uid' and user_status='1'");
        $num_rows = $query->num_rows();
        if ($num_rows > 0) {
            $result = $query->row();
            
            $this->db->select('*');
            $this->db->where(['token' => $token, 'status' => 1]);
            $queryt = $this->db->get('apptoken');
            $num_rowt = $queryt->num_rows();
            if ($num_rowt > 0) {
                $sendData = array(
                    'uid' => $result->id,
                    'name' => $post_data['name'],
                    'description' => $post_data['description'],
                    'mobile' => $post_data['mobile'],
                    'amount' => $post_data['amount'].".0",
                    'mer_id' => $merchant_id,
                    'front_img' => $filename_front,
                    'back_img' => $filename_back,
                );
                $saved_data = $this->db->insert('link_request', $sendData);
                $lastid = $this->db->insert_id();
                $query1 = $this->db->query("select created_date,id,status from link_request where id='$lastid'");
                $num_rows1 = $query1->num_rows();
                 $result1 = $query1->row();
                if($saved_data){
                    $this->db->select('*');
                    $querynew = $this->db->get('agentApiService');
                    $num_rowsnew = $querynew->result_array();
                    // print_r($num_rowsnew);
                    // if($num_rowsnew[2]['status']==0){
                    //     $api_name="Balue Enterprises";
                    // }elseif($num_rowsnew[2]['status']==1){
                    //     $api_name="PAYMYCHOICE";
                    // }else{
                    //     $api_name="PAYMYCHOICE";
                    // }
                    if($num_rowsnew[2]['status']==1){
                         $api_name="Balue Enterprises";
                    }elseif($num_rowsnew[3]['status']==1){
                        $api_name="Balue Enterprises";
                    }elseif($num_rowsnew[4]['status']==1){
                        $api_name="Balue Enterprises";
                    }elseif($num_rowsnew[5]['status']==1){
                        $api_name="Balue Enterprises";
                    }else{
                        $api_name="Balue Enterprises";
                    }
                    
                    $fname=base64_encode($result->fname);
                    $m_id=base64_encode($merchant_id);
                    $amt=base64_encode($post_data['amount'].".0");
                    $no=base64_encode($mobile);
                    $mail="";
                    $time=base64_encode($result1->created_date);
                    $id=base64_encode($result1->id);
                    $api_name_b=base64_encode($api_name);
                    $status= $result1->status;
                    //  $link="https://paymychoice.com/adminP/pay/".base64_decode($merchant_id)."/".base64_decode($amount)."/".base64_decode($mobile);
                $data[] = array('status'=>1,'link'=>"https://payyourchoice.com/adminP/pay_terms_razorpay/$m_id/$amt/$no/$fname/$time/$id/$status/$api_name_b");
                    echo json_encode(array("result" => $data));
                }else{
                    $data[] = array('status'=>0,'msg'=>"Data Not Founds..");
                    echo json_encode(array("result" => $data));
                }
            }else{
                $data[] = array('status'=>0,'msg'=>"Ftoken not match");
                echo json_encode(array("result" => $data));
            }
        }else{
            $data[] = array('status'=>0,'msg'=>"User not found..");
            echo json_encode(array("result" => $data));
        }
                                
    
    }
    
    public function payment_terms_razorpay($txn_id,$amount,$phone,$fname,$time,$id,$status,$api_name_b){
        $postData = array(
            'txnid' => base64_decode($txn_id),
            'amount' => base64_decode($amount),
           
            'phone' => base64_decode($phone),
            'fname' => base64_decode($fname),
            'time' => base64_decode($time),
            'id' => base64_decode($id),
            'api_name' => base64_decode($api_name_b),
            'status' => $status
        );
        $this->data['postData'] = $postData;
        $bc = array(array('link' => base_url(), 'page' => 'Dashboard'));
        $meta = array('page_title' => 'Payment Terms', 'bc' => $bc);
        $this->page_construct_web('admin/transfer_request/pay_terms_razorpay', $meta, $this->data);
        
    }
    
         public function payment_razorpay_feiled($trans_id){
             $datetime=date("Y-m-d  G:i:s");
            //  $trans_id = $this->input->post('txnid');
             
             $query="update link_request set status='2',responce_msg='razorpay_faied',trans_date='$datetime' where mer_id='$trans_id'";
            $result1 = $conn->query($query);
            
            $postData = array(
            'amount' =>$amount,
            'datetime' => $datetime,
        );
        $this->data['postData'] = $postData;  
            $bc = array(array('link' => base_url(), 'page' => 'Dashboard'));
        $meta = array('page_title' => 'Payment Terms', 'bc' => $bc);
        $this->page_construct_web('admin/transfer_request/razorpay_feiled', $meta, $this->data);
    }
    
    public function payment_razorpay_succsess($trans_id_o,$amount,$mer_id,$api_name_b){
            $datetime=date("Y-m-d  G:i:s");
              $amount = base64_decode($amount);
             $trans_id = base64_decode($trans_id_o);
              $mer_id=base64_decode($mer_id);
               $api_name=base64_decode($api_name_b);
           
                    // print_r($num_rowsnew);
                    if($api_name == 0){
                         $Basic="cnpwX2xpdmVfWmEwbXBwbDZiR0V1bGM6aVA2ZkdJQ0huM2owc0RhcndhTExaVjVz";
                         $final_api_name="Balue Enterprises";
                    }elseif($api_name == 1){
                         $Basic="cnpwX2xpdmVfN2tnaU50Nm9Pa2tKRDE6UmtQMEN5TU9LTnFLTzdZVlZGemxacmdJ";
                         $final_api_name="PAYMYCHOICE";
                    }elseif($api_name == 2){
                         $Basic="cnpwX2xpdmVfRkhpR3JqdktwTEV2Z2w6WW5IZDM0Z1pwclpCN0EzTUVhNXdCMUVM";
                         $final_api_name="Sun Enterprises";
                    }elseif($api_name == 3){
                         $Basic="cnpwX2xpdmVfUUVvZjVFOVpuWGsycVE6eHpUalRhZmt4S01BNTFwa1dWcUtyTUFO";
                         $final_api_name="Surya Enterprises";
                    }else{
                        $Basic="";
                        $final_api_name="";
                    }
                    
             
             $curl = curl_init();

            curl_setopt_array($curl, array(
              CURLOPT_URL => 'https://api.razorpay.com/v1/payments/'.$mer_id.'/card',
              CURLOPT_RETURNTRANSFER => true,
              CURLOPT_ENCODING => '',
              CURLOPT_MAXREDIRS => 10,
              CURLOPT_TIMEOUT => 0,
              CURLOPT_FOLLOWLOCATION => true,
              CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
              CURLOPT_CUSTOMREQUEST => 'GET',
              CURLOPT_HTTPHEADER => array(
                'Authorization: Basic '.$Basic
              ),
            ));
            
             $response = curl_exec($curl);
            $jsonDecode = json_decode($response);
            curl_close($curl);
            
             
            $pay_mode=$jsonDecode->type;
            $card_no=$jsonDecode->last4;
            $holder_name=$jsonDecode->name;
            $bank_ref_no="NA";
            // $deduction_percentage=1.80;
            $pay_type_id=$jsonDecode->network;
            $sub_type=$jsonDecode->sub_type;
            $res_msg="NA";
            
            $this->db->select('normal_card,amex_card,business_card');
            $query_app = $this->db->get('latest_news_agent');
            $num_rows_app = $query_app->num_rows();
            if ($num_rows_app > 0) {
                $re_app = $query_app->result_array();
                if($pay_type_id=="American Express" && $sub_type=="consumer"){
                    $deduction_percentage=$re_app[0]["amex_card"];
                }elseif($sub_type=="business" || $sub_type=="corporate"){
                    $deduction_percentage=$re_app[0]["business_card"];
                }else{
                    $deduction_percentage=$re_app[0]["normal_card"];
                }
            }else{
                $deduction_percentage=0.00;
            }
            
            $this->db->select('b.charges as charges,b.mobile_no mobile_no,b.amex_charges as amex_charges,b.bussiness_charge as bussiness_charge,b.fname as fname');
            $this->db->where(['a.mer_id' => $trans_id]);
            $this->db->join('register_agent b','a.uid=b.id');
            $query = $this->db->get('link_request a');
            $num_rows = $query->num_rows();
            if ($num_rows > 0) {
                $re = $query->result_array();
                if($pay_type_id=="American Express" && $sub_type=="consumer"){
                    $charges=$re[0]["amex_charges"];
                }elseif($pay_type_id=="RuPay" && $sub_type=="consumer"){
                    $charges=$re[0]["amex_charges"];
                }elseif($sub_type=="business" || $sub_type=="corporate"){
                    $charges=$re[0]["bussiness_charge"];
                }else{
                    $charges=$re[0]["charges"];
                }
                $mobile_no=$re[0]["mobile_no"];
                $fname=$re[0]["fname"];
                $firm_name = str_replace(' ', '', $fname);
            }else{
                $charges=0.00;
                $mobile_no='';
                $fname='';
                $firm_name='';
            }
            
            $settlement_amount=$amount - (($charges * $amount)/100);
            $sat_amt=round($settlement_amount,2);
            
            $deduction_per=$amount - (($deduction_percentage * $amount)/100);
            $gateway_charges=round($deduction_per,2);
                      
            $arrData = array(
                            'status' => '1',
                            'transaction_id'=>$mer_id,
                            'payment_mode'=>$pay_mode,
                            'payment_type'=>$pay_type_id,
                            'card_number'=>$card_no,
                            'holder_name'=>$holder_name,
                            'bank_ref_no'=>$bank_ref_no,
                            'settlement_amount'=>$settlement_amount,
                            'responce_msg'=>$res_msg,
                            'gateway_charges'=>$gateway_charges,
                            'trans_date'=>$datetime,
                            'api_name'=>$final_api_name,
                            'per_charge'=>$charges
                            
                        );
                        // echo "<pre>";print_r($arrData);exit;
                        $this->db->where(['mer_id' => $trans_id]);
                        $this->db->update('link_request', $arrData);
                        
            //  $query="update link_request set bank_ref_no='bank_ref_no',settlement_amount='$sat_amt',responce_msg='$res_msg',gateway_charges='$gateway_charges',trans_date='$datetime' where mer_id='$trans_id'";
            // $result1 = $conn->query($query);
            
            // $api_url = "https://2factor.in/API/R1/?module=TRANS_SMS&apikey=938b2f31-2485-11ee-addf-0200cd936042&to=$mobile_no&from=PAYMYC&templatename=Agent+Update&var1=$amount";
            $api_url = "https://2factor.in/API/R1/?module=TRANS_SMS&apikey=938b2f31-2485-11ee-addf-0200cd936042&to=$mobile_no&from=PAYCHO&templatename=agent+user+transaction+done&var1=$amount&var2=$firm_name&var3=$mer_id";
                            $ch = curl_init($api_url);
                            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "GET");
                            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                            curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/xml'));
                            $result = curl_exec($ch);
                            
            //--------------------------online agent settlement-----------------------------------//
            $this->db->select('a.*,c.ifsc_code as ifsc_code,c.account_no as account_no,c.name as p_name,c.mobile_no as mobile_no');
            $this->db->where(['a.status' => '1' , 'b.user_auto_transaction_status'=>'1','a.mer_id'=>$trans_id]);
            $this->db->join('register_agent b','a.uid=b.id');
            $this->db->join('payee_list_agent c','a.uid=c.user_id');
            $query_s = $this->db->get('link_request a');
            $num_rows_s = $query_s->num_rows();
            // echo $this->db->last_query(); exit;
            if ($num_rows_s > 0) {
                $re_s = $query_s->result_array();
                $date=date_create($re_s[0]["created_date"]);
                $created_date=date_format($date,"d-m-Y");
                $today_date=date("d-m-Y");
                if($re_s[0]["satelment"] == 0){
                    if($created_date == $today_date){
                        $ifsc_code=$re_s[0]["ifsc_code"];
                        $account_no=$re_s[0]["account_no"];
                        $mobile=$re_s[0]["mobile_no"];
                        $beneficiary_name=$re_s[0]["p_name"];
                  
                        $this->db->select('status');
                        $this->db->where(['id' => 9]);
                        $querynew = $this->db->get('agentApiService');
                        $num_rowsnew = $querynew->result_array();
                        
                        if($num_rowsnew[0]['status']==1){
                            $keyy="C38AF3551B";
                            $saalt="8E8771ED8B";
                        }else{
                            $keyy="";
                            $saalt="";
                        }
                        
                          $hashvalue = $keyy.'|'.$account_no.'|'.$ifsc_code.'||'.$trans_id.'|'.$settlement_amount.'|'.$saalt;
                        // $hashed_value = "d8889618234cc478375222cfef9c6dda75dac7c8472b0349e088111b6b90677c876b0a3814cc00b6f1fd6ae678462936f3a5c02b283b7559697f1bb604a618ac";
                        $hashed_value = hash('sha512', $hashvalue);
                        
                        if($settlement_amount > 200000.00){
                            $pay_mode="RTGS";
                        }elseif($settlement_amount <= 200000.00){
                            $pay_mode="IMPS";
                        }else{
                            $pay_mode="IMPS";
                        }
                        
                        $passArray = array(
                            'key' => $keyy,
                            'beneficiary_type' => "bank_account",
                            'beneficiary_name' => $beneficiary_name,
                            'account_number' => $account_no,
                            'ifsc' => $ifsc_code,
                            'upi_handle' => "",
                            'unique_request_number' => $trans_id,
                            'payment_mode' => $pay_mode,
                            'amount' => $settlement_amount,
                            'narration' => "ST"
                        );
                        // print_r($passArray);
                        $encodeArray = json_encode($passArray);
                        
                        $curl = curl_init();
                        curl_setopt_array($curl, array(
                            CURLOPT_URL => 'https://wire.easebuzz.in/api/v1/quick_transfers/initiate/',
                            CURLOPT_RETURNTRANSFER => true,
                            CURLOPT_ENCODING => '',
                            CURLOPT_MAXREDIRS => 10,
                            CURLOPT_TIMEOUT => 0,
                            CURLOPT_FOLLOWLOCATION => true,
                            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                            CURLOPT_CUSTOMREQUEST => 'POST',
                            CURLOPT_POSTFIELDS => "$encodeArray",
                            CURLOPT_HTTPHEADER => array(
                                'Content-Type: application/json',
                                'Accept: application/json',
                                'Authorization:'.$hashed_value
                            )
                        ));
        
                        $response = curl_exec($curl);
                        // print_r($response);
                        curl_close($curl);
                        $jsonDecode = json_decode($response);
                        // exit;
                         if($jsonDecode->success==true){
                           if($jsonDecode->data->transfer_request->status=="accepted" || $jsonDecode->data->transfer_request->status=="success" || $jsonDecode->data->transfer_request->status=="pending"){
                                             $unique_transaction_reference = $jsonDecode->data->transfer_request->unique_transaction_reference;
                                            $status=$jsonDecode->data->transfer_request->status;
                                            $settlement_datetime=date("Y-m-d  G:i:s");
                                           
                                        // $query11="update link_request set satelment='1',settlement_datetime='$settlement_datetime',settlement_no='$unique_transaction_reference',settlement_result='$status',settlement_unique_no='$mer_id' where mer_id='$trans_id'";
                                        // $result11 = $conn->query($query11);
                                        
                                         $arrData = array(
                                    'satelment' => '1',
                                    'settlement_datetime'=>$settlement_datetime,
                                    'settlement_no'=>$unique_transaction_reference,
                                    'settlement_result'=>$status,
                                    'settlement_unique_no'=>$trans_id,
                                    
                                );
                                //echo "<pre>";print_r($arrData);exit;
                                $this->db->where(['mer_id' => $trans_id]);
                                $this->db->update('link_request', $arrData);
                                       
                                        
                           }
                       }
                    }
                    
                }
               
            }
            
         $postData = array(
            'txnid' => $mer_id,
            'amount' =>$amount,
            'datetime' => $datetime,
            'pay_type_id' => $pay_type_id,
            'phone' => $mobile_no,
            'fname'=>$fname,
        );
        $this->data['postData'] = $postData;   
        $bc = array(array('link' => base_url(), 'page' => 'Dashboard'));
        $meta = array('page_title' => 'Payment Terms', 'bc' => $bc);
        $this->page_construct_web('admin/transfer_request/razorpay_succsess', $meta, $this->data);
    }
    
    public function razorpay_payment(){
        
                    $this->db->select('*');
                    $query_key = $this->db->get('razorpay_key');
                    $num_rows_key = $query_key->result_array();
                     $api_name=$this->input->post('api_name');
                    // print_r($num_rows_key);
                    if($api_name == 0){
                        $key=$num_rows_key[0]['razorpay_balue_key'];
                        $secret=$num_rows_key[0]['razorpay_balue_secret'];
                        // echo "bb";
                    }elseif($api_name == 1){
                        $key=$num_rows_key[0]['razorpay_paymychoice_key'];
                        $secret=$num_rows_key[0]['razorpay_paymychoice_secret'];
                        // echo "ppp";
                    }elseif($api_name == 2){
                        $key=$num_rows_key[0]['razorpay_sun_key'];
                        $secret=$num_rows_key[0]['razorpay_sun_secret'];
                        // echo "ppp";
                    }elseif($api_name == 3){
                        $key=$num_rows_key[0]['razorpay_surya_key'];
                        $secret=$num_rows_key[0]['razorpay_surya_secret'];
                        // echo "ppp";
                    }else{
                        $key="";
                        $secret="";
                    }
                    
    //   $api = new Api('rzp_live_7kgiNt6oOkkJD1', 'RkP0CyMOKNqKO7YVVFzlZrgI');
       $api = new Api($key, $secret);
    /**
     * You can calculate payment amount as per your logic
     * Always set the amount from backend for security reasons
     */
    $_SESSION['payable_amount'] = $this->input->post('amount');
    $trans_id=$this->input->post('txnid');
    $razorpayOrder = $api->order->create(array(
      'receipt'         => rand(),
      'amount'          => $_SESSION['payable_amount'] * 100, // 2000 rupees in paise
      'currency'        => 'INR',
      'payment_capture' => 1 // auto capture
    ));
    $amount = $razorpayOrder['amount'];
    $f_amount=$this->input->post('amount');
    $razorpayOrderId = $razorpayOrder['id'];
    $_SESSION['razorpay_order_id'] = $razorpayOrderId;
      $api_name_new=$this->input->post('api_name');
    $data = $this->prepareData($amount,$razorpayOrderId,$api_name_new);
    // $this->load->view('admin/transfer_request/rezorpay',array('data' => $data,'amount'=>$f_amount,'trans_id'=>$trans_id,'api_name'=>$api_name_new));
  }
  /**
   * This function verifies the payment,after successful payment
   */
  public function verify()
  {
    $success = true;
    $error = "payment_failed";
     $api_name=$_POST['api_name'];
    if (empty($_POST['razorpay_payment_id']) === false) {
                    $this->db->select('*');
                    $query_key = $this->db->get('razorpay_key');
                    $num_rows_key = $query_key->result_array();

                    // print_r($num_rowsnew);
                    if($api_name == 0){
                        $key=$num_rows_key[0]['razorpay_balue_key'];
                        $secret=$num_rows_key[0]['razorpay_balue_secret'];
                    }elseif($api_name == 1){
                        $key=$num_rows_key[0]['razorpay_paymychoice_key'];
                        $secret=$num_rows_key[0]['razorpay_paymychoice_secret'];
                    }elseif($api_name == 2){
                        $key=$num_rows_key[0]['razorpay_sun_key'];
                        $secret=$num_rows_key[0]['razorpay_sun_secret'];
                        // echo "ppp";
                    }elseif($api_name == 3){
                        $key=$num_rows_key[0]['razorpay_surya_key'];
                        $secret=$num_rows_key[0]['razorpay_surya_secret'];
                        // echo "ppp";
                    }else{
                        $key="";
                        $secret="";
                    }
                    
       $api = new Api($key, $secret);
    //   $api = new Api('rzp_live_7kgiNt6oOkkJD1', 'RkP0CyMOKNqKO7YVVFzlZrgI');
    try {
        $attributes = array(
          'razorpay_order_id' => $_SESSION['razorpay_order_id'],
          'razorpay_payment_id' => $_POST['razorpay_payment_id'],
          'razorpay_signature' => $_POST['razorpay_signature']
        );
        $api->utility->verifyPaymentSignature($attributes);
      } catch(SignatureVerificationError $e) {
        $success = false;
        $error = 'Razorpay_Error : ' . $e->getMessage();
      }
    }
    if ($success === true) {
      /**
       * Call this function from where ever you want
       * to save save data before of after the payment
       */
    //   $this->setRegistrationData();
    $trans_id=base64_encode($_POST['trans_id']);
    $amount_f=base64_encode($_POST['amount']);
    $pay_id=base64_encode($_POST['razorpay_payment_id']);
    $api_name_b=base64_encode($_POST['api_name']);
      redirect(base_url().'json/payment_razorpay_succsess'.'/'.$trans_id.'/'.$amount_f.'/'.$pay_id.'/'.$api_name_b);
    }
    else {
      redirect(base_url().'json/payment_razorpay_feiled'.'/'.$trans_id);
    }

    }
    
    public function prepareData($amount,$razorpayOrderId,$api_name)
  {
     
                    $this->db->select('*');
                    $query_key = $this->db->get('razorpay_key');
                    $num_rows_key = $query_key->result_array();
                    // print_r($num_rowsnew);
                    if($api_name == 0){
                        $key=$num_rows_key[0]['razorpay_balue_key'];
                        $name="Balue Enterprises";
                    }elseif($api_name == 1){
                        $key=$num_rows_key[0]['razorpay_paymychoice_key'];
                        $name="PAYMYCHOICE";
                    }elseif($api_name == 2){
                        $key=$num_rows_key[0]['razorpay_sun_key'];
                        $name="Sun Enterprises";
                    }elseif($api_name == 3){
                        $key=$num_rows_key[0]['razorpay_surya_key'];
                        $name="Surya Enterprises";
                    }else{
                        $key="";
                        $secret="";
                    }
       
    $data = array(
      "key" => $key,
      "amount" => $amount,
      "name" => $name,
      "description" => "Utility Payment Service",
      "image" => "https://payyourchoice.com/adminP/assets/images/logo.png",
      "prefill" => array(
        "name"  => $this->input->post('name'),
        "email"  => $this->input->post('email'),
        "contact" => $this->input->post('contact'),
      ),
      "notes"  => array(
        "address"  => "NA",
        "merchant_order_id" => rand(),
      ),
      "theme"  => array(
        "color"  => "#00FFFF"
      ),
      "order_id" => $razorpayOrderId,
    );
    return $data;
  }
  
  public function razorpay_request_responce_test(){
    //   curl -u <YOUR_KEY_ID>:<YOUR_KEY_SECRET>-X 
    //   GET https://api.razorpay.com/v1/payments/pay_DtFYPi3IfUTgsL/card
    // $this->load->view('admin/transfer_request/razorpay_response_test');
    
    
    
    // $api = new Api($key_id, $secret);
    // $card = $api->card->fetch($card_id);

    // $order  = $client->order->create([
    //   'receipt' => 'order_rcptid_11',
    //   'amount'  => 50000,
    //   'currency' => 'INR'
    // ]);
   
    // $api = new Api("rzp_live_7kgiNt6oOkkJD1", "RkP0CyMOKNqKO7YVVFzlZrgI"); 
    // $payment = $api->card->fetch('pay_GmtPY7Zl5xq6xs'); 
    // $abc=$payment->capture(array('amount' => 1000, 'currency' => 'INR')); 
    
    // print_r($payment);
    // print_r($abc);
    // exit;
    // curl -u <YOUR_KEY_ID>:<YOUR_SECRET> \
    // -X POST https://api.razorpay.com/v1/orders \
    // -H "content-type: application/json" \
    // -d '{
    //   "amount": 50000,
    //   "currency": "INR",
    //   "receipt": "receipt#1"
    // }'
    $mer_id="pay_GlhUCYbEMcIicv";
    $curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'https://api.razorpay.com/v1/payments/'.$mer_id.'/card',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'GET',
  CURLOPT_HTTPHEADER => array(
    'Authorization: Basic cnpwX2xpdmVfN2tnaU50Nm9Pa2tKRDE6UmtQMEN5TU9LTnFLTzdZVlZGemxacmdJ'
  ),
));

echo $response = curl_exec($curl);
$jsonDecode = json_decode($response);
curl_close($curl);


  }
  
  public function check_c_code(){
      $ftoken = $this->input->post('ftoken');
        $token = $this->input->post('token');
        $uid = $this->input->post('uid');
        $c_code = $this->input->post('c_code');
        
        $query = $this->db->query("select * from register_users where ftoken='$ftoken' and uid='$uid' and user_status='1'");
        $num_rows = $query->num_rows();
        if ($num_rows > 0) {
            $result = $query->row();
            $u_id=$result->id;
            $this->db->select('*');
            $this->db->where(['token' => $token, 'status' => 1]);
            $queryt = $this->db->get('apptoken');
            $num_rowt = $queryt->num_rows();
            if ($num_rowt > 0) {
                $query_coopen = $this->db->query("select * from coopen where user_id='$u_id' and coopen_code='$c_code' and status='0'");
                $num_rows_coopen = $query_coopen->num_rows();
                if ($num_rows_coopen > 0) {
                    $result_coopen = $query_coopen->row();
                    
                    $discount_percentage=$result_coopen->discount_percentage;
                    $description=$result_coopen->description;
                    
                    $data[] = array('status'=>1,'discount_percentage'=>$discount_percentage,'description'=>$description);
                    echo json_encode(array("result" => $data));
                }else{
                    $data[] = array('status'=>0,'discount_percentage'=>"NA",'description'=>"NA");
                    echo json_encode(array("result" => $data));
                }
            }else{
                $data[] = array('status'=>0,'msg'=>"Ftoken not match");
                echo json_encode(array("result" => $data));
            }
        }else{
            $data[] = array('status'=>0,'msg'=>"User not found..");
            echo json_encode(array("result" => $data));
        }
  }
  
  public function link_request_cashfree_seamless(){
        $arrData = array();
        $post_data = $this->input->post();
        $ftoken = $this->input->post('ftoken');
        $token = $this->input->post('token');
        $uid = $this->input->post('uid');
        $name = $this->input->post('name');
        $description = $this->input->post('description');
        $mobile = $this->input->post('mobile');
        $amount = $this->input->post('amount');
       
        
        $atoz=chr(rand(65,90));
        $number=rand(0000000000001,9999999999999);

        $merchant_id = $atoz.$number;
        
        $query = $this->db->query("select * from register_agent where ftoken='$ftoken' and uid='$uid' and user_status='1'");
        $num_rows = $query->num_rows();
        if ($num_rows > 0) {
            $result = $query->row();
            
            $this->db->select('*');
            $this->db->where(['token' => $token, 'status' => 1]);
            $queryt = $this->db->get('apptoken');
            $num_rowt = $queryt->num_rows();
            if ($num_rowt > 0) {
                $sendData = array(
                    'uid' => $result->id,
                    'name' => $post_data['name'],
                    'description' => $post_data['description'],
                    'mobile' => $post_data['mobile'],
                    'amount' => $post_data['amount'].".0",
                    'mer_id' => $merchant_id,
                    'api_name' => "cashfree_seamless"
                );
                $saved_data = $this->db->insert('link_request', $sendData);
                $lastid = $this->db->insert_id();
                $query1 = $this->db->query("select created_date,id,status from link_request where id='$lastid'");
                $num_rows1 = $query1->num_rows();
                 $result1 = $query1->row();
                if($saved_data){
                    $fname=base64_encode($result->fname);
                    $m_id=base64_encode($merchant_id);
                    $amt=base64_encode($post_data['amount'].".0");
                    $no=base64_encode($mobile);
                    $mail=base64_encode($name.'@gmail.com');
                    $time=base64_encode($result1->created_date);
                    $id=base64_encode($result1->id);
                    $status= $result1->status;
                    //  $link="https://paymychoice.com/adminP/pay/".base64_decode($merchant_id)."/".base64_decode($amount)."/".base64_decode($mobile);
                $data[] = array('status'=>1,'link'=>"https://payyourchoice.com/adminP/pay_terms_cashfree_seamless/$id");
                    echo json_encode(array("result" => $data));
                }else{
                    $data[] = array('status'=>0,'msg'=>"Data Not Founds..");
                    echo json_encode(array("result" => $data));
                }
            }else{
                $data[] = array('status'=>0,'msg'=>"Ftoken not match");
                echo json_encode(array("result" => $data));
            }
        }else{
            $data[] = array('status'=>0,'msg'=>"User not found..");
            echo json_encode(array("result" => $data));
        }
                                
    }
    
    public function pay_terms_cashfree_seamless($id){
        $postData = array(
            'id' => base64_decode($id),
        );
        $this->data['postData'] = $postData;
        $bc = array(array('link' => base_url(), 'page' => 'Dashboard'));
        $meta = array('page_title' => 'Payment Terms', 'bc' => $bc);
        $this->page_construct_web('admin/transfer_request/pay_terms_cashfree_seamless', $meta, $this->data);
        
    }
    
    public function agent_account_wallet(){
        $arrData = array();
        $post_data = $this->input->post();
        $ftoken = $this->input->post('ftoken');
        $token = $this->input->post('token');
        $uid = $this->input->post('uid');
        
        $query = $this->db->query("select * from register_agent where ftoken='$ftoken' and uid='$uid' and user_status='1'");
        $num_rows = $query->num_rows();
        if ($num_rows > 0) {
            $result = $query->row();
            
            $this->db->select('*');
            $this->db->where(['token' => $token, 'status' => 1]);
            $queryt = $this->db->get('apptoken');
            $num_rowt = $queryt->num_rows();
            if ($num_rowt > 0) {
                $uid=$result->id;
                
                $this->db->select('*');
                $this->db->where('agnet_id', $uid);
                // $this->db->order_by('agent_id','DESC');
                // $this->db->limit($config["per_page"],$page);
            	$querynew  = $this->db->get('agent_temp_wallet');
            	$num_rowsnew = $querynew->result_array();
            	if($num_rowsnew){
            	foreach($num_rowsnew as $row){
            	   // echo "<pre>"; echo $row['id'];
            	   $recharge_balance=$row['amount'];
            	   $id=$row['id'];
            	   $link_sr_id=$row['link_sr_id'];
            	   
            	   $agnet_id=$row['agnet_id'];
            	    $query_acc = $this->db->query("select current_balance from agent_account where agent_id='$uid'");
                    $num_rows_acc = $query_acc->num_rows();
                    $result_acc = $query_acc->row();
                    $current_balance=$result_acc->current_balance;
                    
                    
                    $closing_balance= $current_balance + $recharge_balance;
                    $today_date=date("d-m-Y");
                    $sendData = array(
                        'agent_id' => $uid,
                        'opening_bal' => $current_balance,
                        'closing_bal' => $closing_balance,
                        'credit_amount' => $recharge_balance,
                        'debit_amount' => "0.00",
                        'acc_no' => "NA",
                        'ifsc' => "NA",
                        'holder_name' => "NA",
                        'status' => "NA",
                        'distributor_mob' => "NA",
                        'distributor_name' => "NA",
                        'remark' =>"Transaction Against Link ID ".$link_sr_id,
                        'callback_date' => $today_date
                    );
                    $saved_data = $this->db->insert('agent_wallet_history', $sendData);
                    if($saved_data){
                        $this->db->where('id', $id);
                         $delete_data=$this->db->delete('agent_temp_wallet');
                       
                            $insert_array = array(
                    	        'current_balance' => $closing_balance
                    	   );
                            $this->db->where('agent_id', $agnet_id);
                            $update_data=$this->db->update('agent_account', $insert_array);
                            // echo $this->db->last_query();
                        
                    }
            	}
                	$data[] = array('status'=>1,'msg'=>"wallet credited..");
                    echo json_encode(array("result" => $data));
            	}else{
                    $data[] = array('status'=>0,'msg'=>"data not available in Temp");
                    echo json_encode(array("result" => $data));
            }
            }else{
                $data[] = array('status'=>0,'msg'=>"token not match");
                echo json_encode(array("result" => $data));
            }
        }else{
            $data[] = array('status'=>0,'msg'=>"User not found..");
            echo json_encode(array("result" => $data));
        }
    }
    
    
    public function app_wallet_topup(){
        try{
        $arrData = array();
        $post_data = $this->input->post();
        $ftoken = $this->input->post('ftoken');
        $token = $this->input->post('token');
        $uid = $this->input->post('uid');
        
        if(!empty($uid)){
        $query = $this->db->query("select * from register_agent where ftoken='$ftoken' and uid='$uid' and user_status='1'");
        $num_rows = $query->num_rows();
        if ($num_rows > 0) {
            $result = $query->row();
            
            $this->db->select('*');
            $this->db->where(['token' => $token, 'status' => 1]);
            $queryt = $this->db->get('apptoken');
            $num_rowt = $queryt->num_rows();
            if ($num_rowt > 0) {
                $uid=$result->id;
                $email=$result->email;
                $phone=$result->mobile_no;
                $charges=$result->charges;
                
                $this->db->select('*');
                        $this->db->where(['transaction_id' => $post_data['transaction_id']]);
                        $queryt2 = $this->db->get('app_wallet_topup');
                        $num_rowt2 = $queryt2->num_rows();
                        if ($num_rowt2 > 0) {
                            $data[] = array(
                                    "status" => '0',
                                    "msg" => "already exist",
                                     "request_id" => "NA"
                                );
                        }else{
                            $amount_float=$post_data['amount']. ".0";
                                   $hashvalue = 'NCJSW96VLZ|'.$post_data['transaction_id'].'|'.$amount_float.'|'.$email.'|'.$phone.'|I7SH065KJY';
                                    $hashed_value = hash('sha512', $hashvalue);
                               
                                $passArray = array(
                                    'key' => "NCJSW96VLZ",
                                    'hash' => $hashed_value,
                                    'txnid' => $post_data['transaction_id'],
                                    'amount' => $post_data['amount'],
                                    'email' => $email,
                                    'phone' => $phone,
                                    
                                );
                               
                                  $encodeArray = json_encode($passArray);
                                //  print_r($encodeArray);
                               
                                $curl = curl_init();
                                curl_setopt_array($curl, array(
                                    CURLOPT_URL => 'https://dashboard.easebuzz.in/transaction/v1/retrieve',
                                    CURLOPT_RETURNTRANSFER => true,
                                    CURLOPT_ENCODING => '',
                                    CURLOPT_MAXREDIRS => 10,
                                    CURLOPT_TIMEOUT => 0,
                                    CURLOPT_FOLLOWLOCATION => true,
                                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                    CURLOPT_CUSTOMREQUEST => 'POST',
                                    CURLOPT_POSTFIELDS => "$encodeArray",
                                    CURLOPT_HTTPHEADER => array(
                                        'Content-Type: application/json',
                                        'Accept: application/json'
                                        // 'Authorization:'.$hashed_value
                                    )
                                ));
                
                                  $response = curl_exec($curl); 
                                curl_close($curl);
                                 $jsonDecode = json_decode($response);
                                 
                                //  print_r($response);
                                 if($jsonDecode->status=="true" || $jsonDecode->status==1){
                                    $error = $jsonDecode->msg->error;
                                    
                                    $sendData = array(
                                    'agent_id' => $uid,
                                    'transaction_id' => $post_data['transaction_id'],
                                    'amount' => $amount_float,
                                    'holder_name' => $post_data['holder_name'],
                                    'card_number' => $post_data['card_number'],
                                    'payment_mode' => $post_data['payment_mode'],
                                    'merchant_id' => $post_data['merchant_id'],
                                    'response_message' => $post_data['response_message'],
                                );
                                $saved_data = $this->db->insert('app_wallet_topup', $sendData);
                                $lastid = $this->db->insert_id();
                                
                                
                                if($post_data['payment_mode']=="Debit Card")
                                {
                                    $charges=1.60;
                                }
                                
                                
                                if($saved_data){
                                    $settlement_amount=$amount_float - (($charges * $amount_float)/100);
                                    $sat_amt=round($settlement_amount,2);
                                    
                                    $query_acc = $this->db->query("select current_balance from agent_account where agent_id='$uid'");
                                    $num_rows_acc = $query_acc->num_rows();
                                    $result_acc = $query_acc->row();
                                    $current_balance=$result_acc->current_balance;
                                    
                                    $closing_balance= $current_balance + $sat_amt;
                                    $today_date=date("d-m-Y");
                                    $sendData = array(
                                        'agent_id' => $uid,
                                        'opening_bal' => $current_balance,
                                        'closing_bal' => $closing_balance,
                                        'credit_amount' => $sat_amt,
                                        'debit_amount' => "0.00",
                                        'acc_no' => "NA",
                                        'ifsc' => "NA",
                                        'holder_name' => "NA",
                                        'status' => "NA",
                                        'distributor_mob' => "NA",
                                        'distributor_name' => "NA",
                                        'remark' =>"App to Wallet TxnId ".$post_data['transaction_id'],
                                        'callback_date' => $today_date
                                    );
                                    $saved_data_wallet_history = $this->db->insert('agent_wallet_history', $sendData);
                                    if($saved_data_wallet_history){
                                        $insert_array = array(
                                	        'current_balance' => $closing_balance
                                	     );
                                        $this->db->where('agent_id', $uid);
                                        $update_data=$this->db->update('agent_account', $insert_array);
                                        if($update_data){
                                            $insert_array = array(
                                    	        'status' => "1"
                                    	     );
                                            $this->db->where('id', $lastid);
                                            $update_data_status=$this->db->update('app_wallet_topup', $insert_array);
                                            if($update_data_status){
                                                $data[] = array(
                                                    "status" => '1',
                                                    "msg" => "Data inserted Successful.",
                                                    "request_id" => "NA"
                                                );
                                            }
                                        }
                                    }
                                }
                                
                                 }else{
                                     $data[] = array(
                                        "status" => $jsonDecode->status,
                                        "msg" => $jsonDecode->msg,
                                        "request_id" => "NA"
                                    );
                                 }
                                 
                        }
            }else{
                $data[] = array(
                    "status" => '0',
                    "msg" => "Unauthorized User apptoken!",
                    "request_id" => "NA"
                );
            }
        }else{
              $data[] = array(
                    "status" => '0',
                    "msg" => "Unauthorized User!",
                    "request_id" => "NA"
                );
          }
        }
    } catch (Exception $e) {
            $data[] = array(
                "status" => '0',
                "msg" => "Could not request Payment. Please try again!",
                'error' => "Error: " . $e->getMessage()
            );
        }
        echo json_encode(array("result" => $data));
    }
    
    public function app_pin_otp(){
        try{
        $arrData = array();
        $post_data = $this->input->post();
        $ftoken = $this->input->post('ftoken');
        $token = $this->input->post('token');
        $uid = $this->input->post('uid');
        $datetime=date("Y-m-d  G:i:s");
        
        if(!empty($uid)){
        $query = $this->db->query("select * from register_agent where ftoken='$ftoken' and uid='$uid' and user_status='1'");
        $num_rows = $query->num_rows();
        if ($num_rows > 0) {
            $result = $query->row();
            
            $this->db->select('*');
            $this->db->where(['token' => $token, 'status' => 1]);
            $queryt = $this->db->get('apptoken');
            $num_rowt = $queryt->num_rows();
            if ($num_rowt > 0) {
                $uid=$result->id;
                $phone=$result->mobile_no;
                
                $randomString = rand(111111, 999999);
                $otp = rand(1111, 9999);
                $card_number=substr($phone, 0, 2);
                $ref_no=$card_number .''. $randomString;
                
                $api_url = "https://2factor.in/API/R1/?module=TRANS_SMS&apikey=938b2f31-2485-11ee-addf-0200cd936042&to=$phone&from=PAYMYC&templatename=forgot+password&var1=$otp";
                            $ch = curl_init($api_url);
                            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "GET");
                            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                            curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/xml'));
                        $result = curl_exec($ch);
                        if($result){
                            $query = $this->db->query("select * from app_pin_otp where uid='$uid'");
                            $num_rows = $query->num_rows();
                            if ($num_rows > 0) {
                                $arrData = array(
                                    'mobile_no' => $phone,
                                    'ref_no'=>$ref_no,
                                    'otp'=>$otp,
                                    'updated_at'=>$datetime,
                                    
                                );
                                // echo "<pre>";print_r($arrData);exit;
                                $this->db->where(['uid' => $uid]);
                                $update_lr=$this->db->update('app_pin_otp', $arrData);
                                
                                $data[] = array(
                                            "status" => '1',
                                            "msg" => "Data Updated Successful!",
                                            "request_id" => $ref_no
                                        );
                            }else{
                                $sendData = array(
                                    'uid' => $uid,
                                    'mobile_no' => $phone,
                                    'ref_no'=>$ref_no,
                                    'otp'=>$otp,
                                );
                                $saved_data = $this->db->insert('app_pin_otp', $sendData);
                                $lastid = $this->db->insert_id();
                                if($lastid){
                                        $data[] = array(
                                            "status" => '1',
                                            "msg" => "Data Inserted Successful!",
                                            "request_id" => $ref_no
                                        );
                                }
                            }
                        }else{
                            $data[] = array(
                                            "status" => '0',
                                            "msg" => "OTP not send",
                                            "request_id" => "NA"
                                        );
                        }
                            
            }else{
                $data[] = array(
                    "status" => '0',
                    "msg" => "Unauthorized User apptoken!",
                    "request_id" => "NA"
                );
            }
        }else{
              $data[] = array(
                    "status" => '0',
                    "msg" => "Unauthorized User!",
                    "request_id" => "NA"
                );
          }
        }
    } catch (Exception $e) {
            $data[] = array(
                "status" => '0',
                "msg" => "Could not request Payment. Please try again!",
                'error' => "Error: " . $e->getMessage()
            );
        }
        echo json_encode(array("result" => $data));
    }
    
   
    
    public function verify_bene_agent(){
        try{
        $arrData = array();
        $post_data = $this->input->post();
        $ftoken = $this->input->post('ftoken');
        $token = $this->input->post('token');
        $uid = $this->input->post('uid');
        $mobile = $this->input->post('mobile');
        $acount_no = $this->input->post('acount_no');
        $ifsc = $this->input->post('ifsc');
        $datetime=date("Y-m-d  G:i:s");
        
        if(!empty($uid)){
        $query = $this->db->query("select * from register_agent where ftoken='$ftoken' and uid='$uid' and user_status='1'");
        $num_rows = $query->num_rows();
        if ($num_rows > 0) {
            $result = $query->row();
            
            $this->db->select('*');
            $this->db->where(['token' => $token, 'status' => 1]);
            $queryt = $this->db->get('apptoken');
            $num_rowt = $queryt->num_rows();
            if ($num_rowt > 0) {
                $user_id=$result->id;
                
                $query_agent_account = $this->db->query("select * from agent_account where agent_id='$user_id' and status='0'");
                $num_rows_agent_account = $query_agent_account->num_rows();
                // echo $this->db->last_query(); exit;
                if ($num_rows_agent_account > 0) {
                    
                    $result_agent_account = $query_agent_account->row();
                  $current_balance=$result_agent_account->current_balance;
                 if($current_balance >= "3.50"){
                 $closing_balance= $current_balance - 3.50;
                
                            $apiToken = '7H8ACO0LUPJQNB6MIXKE';
                            
                            $RefID = rand();
                            
                            
                            if($apiToken != "" || $mobile != "" || $acount_no != "" || $ifsc != "" || $RefID != ""){
                                
                                $requestResponse = array();
                                $curl = curl_init();
                                curl_setopt_array($curl, array(
                                    CURLOPT_URL => "https://clicktopay.in/api/App_json_MT/account_validate",
                                    CURLOPT_RETURNTRANSFER => true,
                                    CURLOPT_ENCODING => "",
                                    CURLOPT_MAXREDIRS => 10,
                                    CURLOPT_TIMEOUT => 0,
                                    CURLOPT_FOLLOWLOCATION => true,
                                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                    CURLOPT_CUSTOMREQUEST => "POST",
                                    CURLOPT_POSTFIELDS => array('apiToken' => $apiToken,'remittermobile' => $mobile,'account' => $acount_no,'ifsc' => $ifsc,'refid' => $RefID),
                                ));
                                $response = curl_exec($curl);
                                curl_close($curl);
                                $ResponseDecode = json_decode($response);
                        // print_r($ResponseDecode); exit;
                                if($ResponseDecode->statuscode != 'TXN'){
                                    
                                    $data[] = array(
                                        'status' => '0',
                                        'statusMsg' => $ResponseDecode->status,
                                        
                                    );
                                }else{
                                    
                                    $today_date=date("d-m-Y");
                                    $sendData = array(
                                        'agent_id' => $user_id,
                                        'opening_bal' => $current_balance,
                                        'closing_bal' => $closing_balance,
                                        'credit_amount' => "0.00",
                                        'debit_amount' => "3.50",
                                        'acc_no' => $acount_no,
                                        'ifsc' => $ifsc,
                                        'holder_name' => $ResponseDecode->data->benename,
                                        'status' => $ResponseDecode->status,
                                        'distributor_mob' => "NA",
                                        'distributor_name' => "NA",
                                        'remark' =>"Payee Account Verified.",
                                        'callback_date' => $datetime,
                                        'credit_debit_status' => "debit",
                                    );
                                    $saved_data_wallet_history = $this->db->insert('agent_wallet_history', $sendData);
                                    if($saved_data_wallet_history){
                                        $insert_array = array(
                                	        'current_balance' => $closing_balance
                                	     );
                                        $this->db->where('agent_id', $user_id);
                                        $update_data=$this->db->update('agent_account', $insert_array);
                                        if($update_data){
                                            
                                    $data[] = array(
                                        'status' => '1',
                                        'statusMsg' => $ResponseDecode->status,
                                        'ben_name' => $ResponseDecode->data->benename
                                    );
                                    }else{
                                        $data[] = array(
                                            'status' => '0',
                                            'statusMsg' => "Failed",
                                            
                                        );
                                    }
                                    }
                                }
                                }else{
                                    $data[] = array(
                                        'status' => '0',
                                        'statusMsg' => "Data not available",
                                        
                                    );
                                }
                            }
                    else{
                                $data[] = array(
                                    "status" => '0',
                                    "statusMsg" => "Insufficient Balance.",
                                    
                                );
                            }
                }else{
                                $data[] = array(
                                    "status" => '0',
                                    "statusMsg" => "Wallet Blocked.",
                                    
                                );
                            }
                            
            }else{
                $data[] = array(
                    "status" => '0',
                    "statusMsg" => "Unauthorized User apptoken!",
                    
                );
            }
        }else{
              $data[] = array(
                    "status" => '0',
                    "statusMsg" => "Unauthorized User!",
                    
                );
          }
        }
    } catch (Exception $e) {
            $data[] = array(
                "status" => '0',
                "statusMsg" => "Could not request Payment. Please try again!",
                'error' => "Error: " . $e->getMessage()
            );
        }
        echo json_encode(array("result" => $data));
    }
    
    public function app_pin_check(){
        
        try{
        $arrData = array();
        $post_data = $this->input->post();
        $ftoken = $this->input->post('ftoken');
        $token = $this->input->post('token');
        $uid = $this->input->post('uid');
        $pin = $this->input->post('pin');
        
        
        if(!empty($uid)){
        $query = $this->db->query("select * from register_agent where ftoken='$ftoken' and uid='$uid' and user_status='1'");
        $num_rows = $query->num_rows();
        if ($num_rows > 0) {
            $result = $query->row();
            
            $this->db->select('*');
            $this->db->where(['token' => $token, 'status' => 1]);
            $queryt = $this->db->get('apptoken');
            $num_rowt = $queryt->num_rows();
            if ($num_rowt > 0) {
                $uid=$result->id;
                $pin_table=$result->app_pin;
               
                if ($pin_table == $pin) {
                                
                                    $data[] = array(
                                        'status' => '1',
                                        'statusMsg' => "Pin Matched Successful.",
                                        
                                    );
                                }
                            else{
                                $data[] = array(
                                    "status" => '0',
                                    "statusMsg" => "Invalid pin.",
                                    
                                );
                            }
                            
            }else{
                $data[] = array(
                    "status" => '0',
                    "statusMsg" => "Unauthorized User apptoken!",
                    
                );
            }
        }else{
              $data[] = array(
                    "status" => '0',
                    "statusMsg" => "Unauthorized User!",
                    
                );
          }
        }
    } catch (Exception $e) {
            $data[] = array(
                "status" => '0',
                "statusMsg" => "Could not request Payment. Please try again!",
                'error' => "Error: " . $e->getMessage()
            );
        }
        echo json_encode(array("result" => $data));
    
    }
    
    public function delete_bene(){
        
        try{
        $arrData = array();
        $post_data = $this->input->post();
        $ftoken = $this->input->post('ftoken');
        $token = $this->input->post('token');
        $uid = $this->input->post('uid');
        $bid = $this->input->post('bid');
        
        
        if(!empty($uid)){
        $query = $this->db->query("select * from register_agent where ftoken='$ftoken' and uid='$uid' and user_status='1'");
        $num_rows = $query->num_rows();
        if ($num_rows > 0) {
            $result = $query->row();
            
            $this->db->select('*');
            $this->db->where(['token' => $token, 'status' => 1]);
            $queryt = $this->db->get('apptoken');
            $num_rowt = $queryt->num_rows();
            if ($num_rowt > 0) {
                $user_id=$result->id;
                
                                $arrData = array(
                                    'status' => "2"
                                );
                                // echo "<pre>";print_r($arrData);exit;
                                $update = $this->json_model->update_agent_payee_list_data($arrData,$bid,$user_id);
                                
                                $query_status_update = $this->db->query("select * from payee_list_agent where id='$bid' and user_id='$user_id' and status='2'");
                                $num_rows_status_update = $query_status_update->num_rows();
                                
                                // echo $this->db->last_query();
                                if ($num_rows_status_update > 0) {
              
                                    $data[] = array(
                                        'status' => '1',
                                        'statusMsg' => "Status updated Successful.",
                                        
                                    );
                                }
                            else{
                                $data[] = array(
                                    "status" => '0',
                                    "statusMsg" => "Unauthorized.",
                                    
                                );
                            }
                            
            }else{
                $data[] = array(
                    "status" => '0',
                    "statusMsg" => "Unauthorized User apptoken!",
                    
                );
            }
        }else{
              $data[] = array(
                    "status" => '0',
                    "statusMsg" => "Unauthorized User!",
                    
                );
          }
        }
    } catch (Exception $e) {
            $data[] = array(
                "status" => '0',
                "statusMsg" => "Could not request Payment. Please try again!",
                'error' => "Error: " . $e->getMessage()
            );
        }
        echo json_encode(array("result" => $data));
    
    }
    
    public function agent_wallet_history(){
        try{
        $arrData = array();
        $post_data = $this->input->post();
        $ftoken = $this->input->post('ftoken');
        $token = $this->input->post('token');
        $uid = $this->input->post('uid');
        $from_date = $this->input->post('fdate');
        $to_date = $this->input->post('tdate');
        $tdate = "$to_date 23:59:59";
        $fdate = "$from_date 00:00:00";
        
        if(!empty($uid)){
        $query = $this->db->query("select * from register_agent where ftoken='$ftoken' and uid='$uid' and user_status='1'");
        $num_rows = $query->num_rows();
        if ($num_rows > 0) {
            $result = $query->row();
            
            $this->db->select('*');
            $this->db->where(['token' => $token, 'status' => 1]);
            $queryt = $this->db->get('apptoken');
            $num_rowt = $queryt->num_rows();
            if ($num_rowt > 0) {
                $user_id=$result->id;
                                
                                $this->db->select('*');
                                $this->db->from('agent_wallet_history');
                                if(!empty($from_date) && empty($to_date)) {
                                    $this->db->like('created_at',$from_date);
                                } elseif(!empty($to_date) && empty($from_date)) {
                                    $this->db->like('created_at',$to_date);
                                } elseif(!empty($from_date) && !empty($to_date)) {
                                    $this->db->where("created_at >=",$fdate);
                                    $this->db->where("created_at <=",$tdate);
                                }
                                $this->db->where("agent_id",$user_id);
                                $this->db->order_by('id','DESC');
                                $records = $this->db->get()->result();
                            //   print_r($records); exit;
                                // echo $this->db->last_query();
                                if ($records > 0) {
                                    $box_value = $this->json_model->box_value($tdate,$fdate,$user_id);
                                    $arrData1 = array();
                                    foreach($records as $records){
                                        
                                        $search = 'Transaction Against Link ID';
                                        if(preg_match("/{$search}/i", $records->remark)) {
                                            $explodeString = explode(" ",$records->remark);
                                            $trNumber = $explodeString['4'];
                                            $queryNum = $this->db->query("select * from link_request where id='$trNumber'");
                                            $num_rowsNum = $queryNum->num_rows();
                                            if ($num_rowsNum > 0) {
                                                $resultNum = $queryNum->row();
                                                $arrData1 = array(
                                                    'cmode' => $resultNum->payment_type,
                                                    'cpgname' => $resultNum->api_name,
                                                    'cname' => $resultNum->holder_name,
                                                    'ccard_number' => $resultNum->card_number,
                                                    'curn' => $resultNum->mer_id,
                                                    'ctid' => $resultNum->transaction_id,
                                                    'link_request_amt' => $resultNum->amount,
                                                );
                                            }
                                        } else {
                                            $arrData1 = array(
                                                'cmode' => 'Na',
                                                'cpgname' => 'Na',
                                                'cname' => 'Na',
                                                'ccard_number' => 'Na',
                                                'curn' => 'Na',
                                                'ctid' => 'Na',
                                                'link_request_amt' => 'Na',
                                            );
                                        }
                                        $arrData['data'][] = array(
                                           'opening_bal' => $records->opening_bal,
                                           'credit_amount' => $records->credit_amount,
                                           'debit_amount' => $records->debit_amount,
                                           'closing_bal' => $records->closing_bal,
                                           'acc_no' => $records->acc_no,
                                           'ifsc' => $records->ifsc,
                                           'holder_name' => $records->holder_name,
                                           'status' => $records->status,
                                           'trans_id' => $records->trans_id,
                                           'urn' => $records->urn,
                                           'distributor_mob' => $records->distributor_mob,
                                           'distributor_name' => $records->distributor_name,
                                           'remark' => $records->remark,
                                           'created_at' => $records->created_at,
                                           'callback_date' => $records->callback_date,
                                           'credit_debit_status' => $records->credit_debit_status,
                                        //   'Data' => $arrData1
                                          'cmode' => $arrData1['cmode'],
                                          'cpgname' => $arrData1['cpgname'],
                                          'cname' => $arrData1['cname'],
                                          'ccard_number' => $arrData1['ccard_number'],
                                          'curn' => $arrData1['curn'],
                                          'ctid' => $arrData1['ctid'],
                                          'link_request_amt' => $arrData1['link_request_amt'],
                                        );
                                    }
                                    $data[] = array('status'=>1,'msg'=>"success",'total_credit'=>$box_value['0']->credit_amount,'total_debit'=>$box_value['0']->debit_amount,'details'=>$arrData);
                                }
                            else{
                                $data[] = array(
                                    "status" => '0',
                                    "msg" => "No Data Found.",
                                    
                                );
                            }
                            
            }else{
                $data[] = array(
                    "status" => '0',
                    "msg" => "Unauthorized User apptoken!",
                    
                );
            }
        }else{
              $data[] = array(
                    "status" => '0',
                    "msg" => "Unauthorized User!",
                    
                );
          }
        }
    } catch (Exception $e) {
            $data[] = array(
                "status" => '0',
                "msg" => "Could not request Payment. Please try again!",
                'error' => "Error: " . $e->getMessage()
            );
        }
        echo json_encode(array("result" => $data));
    }
    
    
    public function py_wallet_bank(){
        try{
        $arrData = array();
        $post_data = $this->input->post();
        $ftoken = $this->input->post('ftoken');
        $token = $this->input->post('token');
        $uid = $this->input->post('uid');
        $ac_no = $this->input->post('ac_no');
        $ifsc_code = $this->input->post('ifsc_code');
         $amount_main = $this->input->post('amount');
        $mode = $this->input->post('mode');
        $payeename = $this->input->post('payeename');
        $app_pin = $this->input->post('app_pin');
        $keyy="C38AF3551B";
        $saalt="8E8771ED8B";
        $amount=round($amount_main,2);
        $length = 10;
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = "";
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        
        $charges="0.00";
        $curl_amount=$amount - (($charges * $amount)/100);
        $minus_amount="9";
        $final_curl_amount = bcsub($curl_amount,$minus_amount, 2); 
        $final_curl_amount1=round($final_curl_amount,2);
       $admin_commision = bcsub($amount,$final_curl_amount1, 2); 
        
        if(!empty($uid)){
        $query = $this->db->query("select * from register_agent where ftoken='$ftoken' and uid='$uid' and app_pin='$app_pin' and user_status='1'");
        $num_rows = $query->num_rows();
        if ($num_rows > 0) {
            $result = $query->row();
            
            $this->db->select('*');
            $this->db->where(['token' => $token, 'status' => 1]);
            $queryt = $this->db->get('apptoken');
            $num_rowt = $queryt->num_rows();
            if ($num_rowt > 0) {
                $user_id=$result->id;
                $name=$result->first_name;
                 if($ac_no!="" && $ifsc_code!="" && $amount!="" && $mode!=""){
                     $query_wallet_amount = $this->db->query("select current_balance from agent_account where agent_id='$user_id'");
                        $num_rows_wallet_amount = $query_wallet_amount->num_rows();
                        if($num_rows_wallet_amount > 0){
                            $result_wallet_amount = $query_wallet_amount->row();
                            $current_balance=$result_wallet_amount->current_balance;
                            if($current_balance >= $amount){
                                $today_date=date("d-m-Y");
                                    $sendData = array(
                                        'agent_id' => $user_id,
                                        'urn' => $randomString,
                                        'amount' => $amount
                                    );
                                    $saved_data_wallet_bank_flow = $this->db->insert('wallet_bank_flow', $sendData);
                                    $lastid = $this->db->insert_id();
                                    if($saved_data_wallet_bank_flow){
                                        $closing_balance=bcsub($current_balance,$amount, 2); 
                                        $sendData = array(
                                            'agent_id' => $user_id,
                                            'opening_bal' => $current_balance,
                                            'closing_bal' => $closing_balance,
                                            'credit_amount' => "0.00",
                                            'debit_amount' => "$amount",
                                            'acc_no' => $ac_no,
                                            'ifsc' => $ifsc_code,
                                            'holder_name' => $payeename,
                                            'status' => "NA",
                                            'distributor_mob' => $final_curl_amount1,
                                            'distributor_name' => $mode,
                                            'remark' =>"Wallet to bank transfer",
                                            'credit_debit_status' => "debit",
                                            'urn' => $randomString,
                                           'admin_commision' => $admin_commision
                                        );
                                        $saved_data = $this->db->insert('agent_wallet_history', $sendData);
                                        $agent_wallet_history_id = $this->db->insert_id();
                                                $insert_array = array(
                                        	        'current_balance' => $closing_balance
                                        	   );
                                                $this->db->where('agent_id', $user_id);
                                                $update_data=$this->db->update('agent_account', $insert_array);
                                                if($saved_data && $update_data){
                                                    $insert_array = array(
                                        	        'status' => "1"
                                        	   );
                                                $this->db->where('id', $lastid);
                                                $update_data=$this->db->update('wallet_bank_flow', $insert_array);
                                                
                                                
                                                   
                                                    
                                                    
                                                     $hashvalue = $keyy.'|'.$ac_no.'|'.$ifsc_code.'||'.$randomString.'|'.$final_curl_amount1.'|'.$saalt;
                                                    $hashed_value = hash('sha512', $hashvalue);
                                                    
                                                    $passArray = array(
                                                        "key" => $keyy,
                                                        "beneficiary_type" => "bank_account",
                                                        "beneficiary_name" => $payeename,
                                                        "account_number" => $ac_no,
                                                        "ifsc" => $ifsc_code,
                                                        "upi_handle" => "",
                                                        "unique_request_number" => $randomString,
                                                        "payment_mode" => $mode,
                                                        "amount" => $final_curl_amount1,
                                                        "email" => "",
                                                        "phone" => "",
                                                        "narration" => "WALLET"
                                                    );
                                                    // print_r($passArray);
                                                    $encodeArray = json_encode($passArray);
                                                    // print_r($encodeArray);
                                                    
                                                    $curl = curl_init();
                                                    curl_setopt_array($curl, array(
                                                        CURLOPT_URL => 'https://wire.easebuzz.in/api/v1/quick_transfers/initiate/',
                                                        CURLOPT_RETURNTRANSFER => true,
                                                        CURLOPT_ENCODING => '',
                                                        CURLOPT_MAXREDIRS => 10,
                                                        CURLOPT_TIMEOUT => 0,
                                                        CURLOPT_FOLLOWLOCATION => true,
                                                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                                        CURLOPT_CUSTOMREQUEST => 'POST',
                                                        CURLOPT_POSTFIELDS => "$encodeArray",
                                                        CURLOPT_HTTPHEADER => array(
                                                            'Content-Type: application/json',
                                                            'Accept: application/json',
                                                            'Authorization:'.$hashed_value
                                                        )
                                                    ));
                                    
                                                    $response = curl_exec($curl);
                                                    curl_close($curl);
                                                    // print_r($response); exit;
                                                        $jsonDecode = json_decode($response);
                                                     
                                                         if($jsonDecode->success==true){
                                                           if($jsonDecode->data->transfer_request->status=="accepted" || $jsonDecode->data->transfer_request->status=="success" || $jsonDecode->data->transfer_request->status=="pending" || $jsonDecode->data->transfer_request->status=="in_process"){
                                                                             $unique_transaction_reference = $jsonDecode->data->transfer_request->unique_transaction_reference;
                                                                            $status=$jsonDecode->data->transfer_request->status;
                                                                            $settlement_datetime=date("Y-m-d  G:i:s");
                                                                        
                                                                         
                                                                                $insert_array2 = array(
                                                                    	        'status' => "2"
                                                                    	   );
                                                                            $this->db->where('id', $lastid);
                                                                            $update_data2=$this->db->update('wallet_bank_flow', $insert_array2);
                                                                        
                                                                         $arrData = array(
                                                                            'status' => $status,
                                                                            'trans_id'=>$unique_transaction_reference,
                                                                            'urn'=>$randomString,
                                                                            'callback_date'=>$settlement_datetime
                                                                            
                                                                        );
                                                                        //echo "<pre>";print_r($arrData);exit;
                                                                        $this->db->where(['id' => $agent_wallet_history_id]);
                                                                        $this->db->update('agent_wallet_history', $arrData);
                                                                       
                                                                       $data[] = array(
                                                                            "status" => '1',
                                                                            "msg" => $status,
                                                                            
                                                                        );
                                                                        
                                                           }
                                                       }else if($jsonDecode->success==false){
                                                           
                                                            $query_wallet_amount1 = $this->db->query("select current_balance from agent_account where agent_id='$user_id'");
                                                            $num_rows_wallet_amount1 = $query_wallet_amount1->num_rows();
                                                            if($num_rows_wallet_amount1 > 0){
                                                                $result_wallet_amount1 = $query_wallet_amount1->row();
                                                                $current_balance1=$result_wallet_amount1->current_balance;
                                                            
                            
                                                           $message=$jsonDecode->message;
                                                                $insert_array2 = array(
                                                                    	        'status' => "3"
                                                                    	   );
                                                                $this->db->where('id', $lastid);
                                                                $update_data2=$this->db->update('wallet_bank_flow', $insert_array2);
                                                                
                                                                $closing_balance2=bcadd($current_balance1,$amount, 2); 
                                                                
                                                                $sendData = array(
                                                                    'agent_id' => $user_id,
                                                                    'opening_bal' => $current_balance1,
                                                                    'closing_bal' => $closing_balance2,
                                                                    'credit_amount' => $amount,
                                                                    'debit_amount' => "0.00",
                                                                    'acc_no' => $ac_no,
                                                                    'ifsc' => $ifsc_code,
                                                                    'holder_name' => $payeename,
                                                                    'status' => "NA",
                                                                    'distributor_mob' => $final_curl_amount1,
                                                                    'distributor_name' => $mode,
                                                                    'remark' =>"Wallet to bank transfer refund",
                                                                    'credit_debit_status' => "credit",
                                                                    'urn' => $randomString,
                                                                );
                                                                $saved_data = $this->db->insert('agent_wallet_history', $sendData);
                                                                $agent_wallet_history_id = $this->db->insert_id();
                                                                        $insert_array = array(
                                                                	        'current_balance' => $closing_balance2
                                                                	   );
                                                                        $this->db->where('agent_id', $user_id);
                                                                        $update_data=$this->db->update('agent_account', $insert_array);
                                                                        
                                                                         $data[] = array(
                                                                            "status" => '0',
                                                                            "msg" => $message,
                                                                            
                                                                        );
                                                            }
                                                           }
                                                       
                                                       else{
                                                           $data[] = array(
                                                        "status" => '0',
                                                        "msg" => "Wallet Not Ddbited.",
                                                        
                                                    );
                                                       }
                                                    
                                                    
                                                    
                                                }else{
                                                    $data[] = array(
                                                        "status" => '0',
                                                        "msg" => "Wallet Not Ddbited.",
                                                        
                                                    );
                                                }
                                    }else{
                                        $data[] = array(
                                                        "status" => '0',
                                                        "msg" => "Wallet Not Ddbited.",
                                                        
                                                    );
                                    }
                            }else{
                            $data[] = array(
                                "status" => '0',
                                "msg" => "Insuficient Balance.",
                                
                            );
                            }
                        }else{
                        $data[] = array(
                            "status" => '0',
                            "msg" => "Data Not Available.",
                            
                        );
                }   
                 } else{
                    $data[] = array(
                        "status" => '0',
                        "msg" => "Data Not Available.",
                        
                    );
                }             
                            
            }else{
                $data[] = array(
                    "status" => '0',
                    "msg" => "Unauthorized User apptoken!",
                    
                );
            }
        }else{
              $data[] = array(
                    "status" => '0',
                    "msg" => "Unauthorized User!",
                    
                );
          }
        }
    } catch (Exception $e) {
            $data[] = array(
                "status" => '0',
                "msg" => "Could not request Payment. Please try again!",
                'error' => "Error: " . $e->getMessage()
            );
        }
        echo json_encode(array("result" => $data));
    }
    
    
    public function py_wallet_bank_CallBack(){
        $postData = json_decode(file_get_contents('php://input'), true);
        if($postData) {
            $today_date=date("d-m-Y H:i:s");
             $amount = $postData['data']['amount'];
            $status = $postData['data']['status'];
            $unique_request_number = $postData['data']['unique_request_number'];
            $unique_transaction_reference = $postData['data']['unique_transaction_reference'];
            $narration = $postData['data']['narration'];
            if($narration=="ST"){
                
                if($status=="failure" || $status=="failed" || $status=="Failure" || $status=="Failed"){
                 
                    $query = $this->db->query("select * from agent_wallet_history where urn='$unique_request_number' and status !='$status'");
                    $num_rows = $query->num_rows();
                    if (!empty($num_rows)) {
                        $result = $query->row();
                        $status_table=$result->status;
                        $credit_amount=$result->debit_amount;
                         $user_id=$result->agent_id;
                        $ac_no=$result->acc_no;
                        $ifsc_code=$result->ifsc;
                        $payeename=$result->holder_name;
                        
                        
                        $query1 = $this->db->query("select * from agent_account where agent_id='$user_id'");
                        $num_rows1 = $query1->num_rows();
                        if(!empty($num_rows1)){
                            // echo "ssss123";
                            $result1 = $query1->row();
                            $current_balance1=$result1->current_balance;
                        $closing_balance2=bcadd($current_balance1,$credit_amount, 2); 
                        
                        if($status_table=="accepted" || $status_table=="success" || $status_table=="pending" || $status_table=="in_process"){
                            // echo "ssss";
                            $sendData = array(
                                        'agent_id' => $user_id,
                                        'opening_bal' => $current_balance1,
                                        'closing_bal' => $closing_balance2,
                                        'credit_amount' => $credit_amount,
                                        'debit_amount' => "0.00",
                                        'acc_no' => $ac_no,
                                        'ifsc' => $ifsc_code,
                                        'holder_name' => $payeename,
                                        'status' => $status,
                                        'distributor_mob' => "NA",
                                        'distributor_name' => "NA",
                                        'remark' =>"Refund for failed transaction",
                                        'credit_debit_status' => "credit",
                                        'urn' => $unique_request_number,
                                        'callback_date' => $today_date
                                    );
                                    $saved_data = $this->db->insert('agent_wallet_history', $sendData);
                                    $agent_wallet_history_id = $this->db->insert_id();
                                    
                                    $insert_array1 = array(
                                            	        'status' => $status
                                            	   );
                                    $this->db->where('urn', $unique_request_number);
                                    $update_data1=$this->db->update('agent_wallet_history', $insert_array1);
                                    
                                            $insert_array = array(
                                    	        'current_balance' => $closing_balance2
                                    	   );
                                            $this->db->where('agent_id', $user_id);
                                            $update_data=$this->db->update('agent_account', $insert_array);
                                            
                                            $insert_array_flow = array(
                                                	        'status' => "4"
                                                	   );
                                            $this->db->where('urn', $unique_request_number);
                                            $update_array_flow=$this->db->update('wallet_bank_flow', $insert_array_flow);
                        }
                        }
                        
                    }
                    
                }else{
                     $insert_array = array(
                            	        'trans_id' => $unique_transaction_reference,
                            	        'status' => $status,
                            	        'callback_date' => $today_date
                            	   );
                    $this->db->where('urn', $unique_request_number);
                    $update_data=$this->db->update('agent_wallet_history', $insert_array);
                }
            }
            
            
        }
    }
    
    
    
    public function app_wallet_topup_cf(){
        try{
        $arrData = array();
        $post_data = $this->input->post();
        $ftoken = $this->input->post('ftoken');
        $token = $this->input->post('token');
        $uid = $this->input->post('uid');
        $app_id="248140ce1ef2b6c3dedff5918d041842";
        $secretKey="d4da766e11182a074a1ca3d76b97b85764c1afdb";
        $payment_mode = $post_data['payment_mode'];
        
        if(!empty($uid)){
        $query = $this->db->query("select * from register_agent where ftoken='$ftoken' and uid='$uid' and user_status='1'");
        $num_rows = $query->num_rows();
        if ($num_rows > 0) {
            $result = $query->row();
            
            $this->db->select('*');
            $this->db->where(['token' => $token, 'status' => 1]);
            $queryt = $this->db->get('apptoken');
            $num_rowt = $queryt->num_rows();
            if ($num_rowt > 0) {
                $uid=$result->id;
                $email=$result->email;
                $phone=$result->mobile_no;
                $charges=$result->charges;
                $amex_charges=$result->amex_charges;
                
                $this->db->select('*');
                        $this->db->where(['merchant_id' => $post_data['merchant_id']]);
                        $queryt2 = $this->db->get('app_wallet_topup');
                        $num_rowt2 = $queryt2->num_rows();
                        if ($num_rowt2 > 0) {
                            $data[] = array(
                                    "status" => '0',
                                    "msg" => "already exist",
                                     "request_id" => "NA"
                                );
                        }else{
                            $amount_float=$post_data['amount']. ".0";
                            $curl = curl_init();
                                   curl_setopt_array($curl, [
                                      CURLOPT_URL => 'https://api.cashfree.com/pg/orders/'.$post_data['merchant_id'].'/payments',
                                      CURLOPT_RETURNTRANSFER => true,
                                      CURLOPT_ENCODING => "",
                                      CURLOPT_MAXREDIRS => 10,
                                      CURLOPT_TIMEOUT => 30,
                                      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                      CURLOPT_CUSTOMREQUEST => "GET",
                                      CURLOPT_HTTPHEADER => [
                                        "Accept: application/json",
                                        "x-api-version: 2021-05-21",
                                        "x-client-id: $app_id",
                                        "x-client-secret: $secretKey"
                                      ],
                                    ]);
                
                                  $response = curl_exec($curl); 
                                $err = curl_close($curl);
                                 $a = json_decode($response);
                                //  print_r($response); exit;
                                //  print_r($a); 
                                //  echo $a['0']->payment_status;
                                //  echo $payment_status=$payment_url=$this->get_string_between($response, ',"payment_status":"','","payment_message');
                                //  exit;
                                 if($err){
                                    $data[] = array(
                                        "status" => $err,
                                        "msg" => $err,
                                        "request_id" => "NA"
                                    );
                                
                                 }else{
                                    $payment_status=$a['0']->payment_status;
                                    // $payment_message=$payment_url=$this->get_string_between($response, ',"payment_message":"','","bank_reference');
                                    // $payment_status = $a[0]->payment_status;
                                    $payment_message = $a['0']->payment_message;
                                    //  $error = $jsonDecode->msg->error;
                                    if($payment_status == "SUCCESS" || $payment_status == "Success" || $payment_status == "success"){
                                        $payment_method = $a[0]->payment_method;
                                        $payment_amount=$a[0]->payment_amount;
                                        $card_number=$payment_method->card->card_number;
                                        $sendData = array(
                                        'agent_id' => $uid,
                                        'transaction_id' => $post_data['transaction_id'],
                                        'amount' => $payment_amount,
                                        'holder_name' => $post_data['holder_name'],
                                        'card_number' => $card_number,
                                        'payment_mode' => $post_data['payment_mode'],
                                        'merchant_id' => $post_data['merchant_id'],
                                        'response_message' => $a[0]->payment_message,
                                    );
                                    $saved_data = $this->db->insert('app_wallet_topup', $sendData);
                                    $lastid = $this->db->insert_id();
                                    if($saved_data){
                                        if($payment_mode=="BUSINESS_CREDIT_CARD" || $payment_mode=="CORPORATE_CREDIT_CARD" || $payment_mode=="PREPAID_CARD" || $payment_mode=="DEBIT_CARD" || $payment_mode=="business_credit_card" || $payment_mode=="corporate_credit_card" || $payment_mode=="prepaid_card" || $payment_mode=="debit_card"){
                                            $deduction_percentage=$amex_charges;
                                        }else{
                                            $deduction_percentage=$charges;
                                        }
                                        $settlement_amount=$payment_amount - (($deduction_percentage * $payment_amount)/100);
                                        $sat_amt=round($settlement_amount,2);
                                        
                                        $query_acc = $this->db->query("select current_balance from agent_account where agent_id='$uid'");
                                        $num_rows_acc = $query_acc->num_rows();
                                        $result_acc = $query_acc->row();
                                        $current_balance=$result_acc->current_balance;
                                        
                                        $closing_balance= $current_balance + $sat_amt;
                                        $today_date=date("d-m-Y");
                                        $sendData = array(
                                            'agent_id' => $uid,
                                            'opening_bal' => $current_balance,
                                            'closing_bal' => $closing_balance,
                                            'credit_amount' => $sat_amt,
                                            'debit_amount' => "0.00",
                                            'acc_no' => "NA",
                                            'ifsc' => "NA",
                                            'holder_name' => "NA",
                                            'status' => "NA",
                                            'distributor_mob' => "NA",
                                            'distributor_name' => "NA",
                                            'remark' =>"App to Wallet TxnId ".$post_data['merchant_id'],
                                            'callback_date' => $today_date
                                        );
                                        $saved_data_wallet_history = $this->db->insert('agent_wallet_history', $sendData);
                                        if($saved_data_wallet_history){
                                            $insert_array = array(
                                    	        'current_balance' => $closing_balance
                                    	     );
                                            $this->db->where('agent_id', $uid);
                                            $update_data=$this->db->update('agent_account', $insert_array);
                                            if($update_data){
                                                $insert_array = array(
                                        	        'status' => "1"
                                        	     );
                                                $this->db->where('id', $lastid);
                                                $update_data_status=$this->db->update('app_wallet_topup', $insert_array);
                                                if($update_data_status){
                                                    $data[] = array(
                                                        "status" => '1',
                                                        "msg" => "Data inserted Successful.",
                                                        "request_id" => "NA"
                                                    );
                                                }
                                            }
                                        }
                                    
                                    }else{
                                        $data[] = array(
                                            "status" => '0',
                                            "msg" => "Data not found!",
                                            "request_id" => "NA"
                                        );
                                    }
                                    }else{
                                        $data[] = array(
                                            "status" => '0',
                                            "msg" => "Invalid Merchant ID",
                                            "request_id" => "NA"
                                        );
                                    }
                                     
                                     
                                     
                                 }
                                 
                        }
            }else{
                $data[] = array(
                    "status" => '0',
                    "msg" => "Unauthorized User apptoken!",
                    "request_id" => "NA"
                );
            }
        }else{
              $data[] = array(
                    "status" => '0',
                    "msg" => "Unauthorized User!",
                    "request_id" => "NA"
                );
          }
        }
    } catch (Exception $e) {
            $data[] = array(
                "status" => '0',
                "msg" => "Could not request Payment. Please try again!",
                'error' => "Error: " . $e->getMessage()
            );
        }
        echo json_encode(array("result" => $data));
    }
    
    public function get_string_between($string, $start, $end){
        $string = ' ' . $string;
        $ini = strpos($string, $start);
        if ($ini == 0) return '';
        $ini += strlen($start);
        $len = strpos($string, $end, $ini) - $ini;
        return substr($string, $ini, $len);
    }
    
    public function app_refresh_callback(){
        try{
            $arrData = array();
            $post_data = $this->input->post();
            $ftoken = $this->input->post('ftoken');
            $token = $this->input->post('token');
            $uid = $this->input->post('uid');
            $urn_no = $this->input->post('urn_no');
            $keyy="C38AF3551B";
        $saalt="8E8771ED8B";
            
            if(!empty($uid)){
            $query = $this->db->query("select * from register_agent where ftoken='$ftoken' and uid='$uid' and user_status='1'");
            $num_rows = $query->num_rows();
            if ($num_rows > 0) {
                $result = $query->row();
                
                $this->db->select('*');
                $this->db->where(['token' => $token, 'status' => 1]);
                $queryt = $this->db->get('apptoken');
                $num_rowt = $queryt->num_rows();
                if ($num_rowt > 0) {
                    $user_id=$result->id;
                    
                      $hashvalue = $keyy.'|'.$urn_no.'|'.$saalt;
                                                     $hashed_value = hash('sha512', $hashvalue);
                                                    
                                                    
                                                    
                                                    $curl = curl_init();

                                                    curl_setopt_array($curl, array(
                                                      CURLOPT_URL => 'https://wire.easebuzz.in/api/v1/transfers/'.$urn_no.'/',
                                                      CURLOPT_RETURNTRANSFER => true,
                                                      CURLOPT_ENCODING => '',
                                                      CURLOPT_MAXREDIRS => 10,
                                                      CURLOPT_TIMEOUT => 0,
                                                      CURLOPT_FOLLOWLOCATION => true,
                                                      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                                      CURLOPT_CUSTOMREQUEST => 'GET',
                                                      CURLOPT_POSTFIELDS =>'{
                                                       "key": "C38AF3551B"
                                                    }',
                                                      CURLOPT_HTTPHEADER => array(
                                                        'Authorization: '.$hashed_value,
                                                        'Content-Type: application/json'
                                                      ),
                                                    ));
                                                    
                                                    $response = curl_exec($curl);
                                                    
                                                    curl_close($curl);
                                                    // echo $response; exit;
                                                        $jsonDecode = json_decode($response);
                                                        // print_r($jsonDecode); exit;
                                                        $success = $jsonDecode->success;
                                                        if($jsonDecode && $success=="1"){
                                                            $today_date=date("d-m-Y H:i:s");
                                                            
                                                             $amount = $jsonDecode->data->transfer_request->amount;
                                                            $status = $jsonDecode->data->transfer_request->status;
                                                            $unique_request_number = $jsonDecode->data->transfer_request->unique_request_number;
                                                            $unique_transaction_reference = $jsonDecode->data->transfer_request->unique_transaction_reference;
                                                            
                                                            
                
                                                            if($status=="failure" || $status=="failed" || $status=="Failure" || $status=="Failed"){
                                                             
                                                                $query = $this->db->query("select * from agent_wallet_history where urn='$unique_request_number' and status !='$status'");
                                                                $num_rows = $query->num_rows();
                                                                if (!empty($num_rows)) {
                                                                    $result = $query->row();
                                                                    $status_table=$result->status;
                                                                    $credit_amount=$result->debit_amount;
                                                                     $user_id=$result->agent_id;
                                                                    $ac_no=$result->acc_no;
                                                                    $ifsc_code=$result->ifsc;
                                                                    $payeename=$result->holder_name;
                                                                    
                                                                    
                                                                    $query1 = $this->db->query("select * from agent_account where agent_id='$user_id'");
                                                                    $num_rows1 = $query1->num_rows();
                                                                    if(!empty($num_rows1)){
                                                                        // echo "ssss123";
                                                                        $result1 = $query1->row();
                                                                        $current_balance1=$result1->current_balance;
                                                                    $closing_balance2=bcadd($current_balance1,$credit_amount, 2); 
                                                                    
                                                                    if($status_table=="accepted" || $status_table=="success" || $status_table=="pending" || $status_table=="in_process"){
                                                                        // echo "ssss";
                                                                        $sendData = array(
                                                                                    'agent_id' => $user_id,
                                                                                    'opening_bal' => $current_balance1,
                                                                                    'closing_bal' => $closing_balance2,
                                                                                    'credit_amount' => $credit_amount,
                                                                                    'debit_amount' => "0.00",
                                                                                    'acc_no' => $ac_no,
                                                                                    'ifsc' => $ifsc_code,
                                                                                    'holder_name' => $payeename,
                                                                                    'status' => $status,
                                                                                    'distributor_mob' => "NA",
                                                                                    'distributor_name' => "NA",
                                                                                    'remark' =>"Refund for failed transaction",
                                                                                    'credit_debit_status' => "credit",
                                                                                    'urn' => $unique_request_number,
                                                                                    'callback_date' => $today_date
                                                                                );
                                                                                $saved_data = $this->db->insert('agent_wallet_history', $sendData);
                                                                                $agent_wallet_history_id = $this->db->insert_id();
                                                                                
                                                                                $insert_array1 = array(
                                                                                        	        'status' => $status
                                                                                        	   );
                                                                                $this->db->where('urn', $unique_request_number);
                                                                                $update_data1=$this->db->update('agent_wallet_history', $insert_array1);
                                                                                
                                                                                        $insert_array = array(
                                                                                	        'current_balance' => $closing_balance2
                                                                                	   );
                                                                                        $this->db->where('agent_id', $user_id);
                                                                                        $update_data=$this->db->update('agent_account', $insert_array);
                                                                                        
                                                                                        $insert_array_flow = array(
                                                                                            	        'status' => "4"
                                                                                            	   );
                                                                                        $this->db->where('urn', $unique_request_number);
                                                                                        $update_array_flow=$this->db->update('wallet_bank_flow', $insert_array_flow);
                                                                    }
                                                                    }
                                                                    
                                                                }
                                                                
                                                            }else{
                                                                 $insert_array = array(
                                                                        	        'trans_id' => $unique_transaction_reference,
                                                                        	        'status' => $status,
                                                                        	        'callback_date' => $today_date
                                                                        	   );
                                                                $this->db->where('urn', $unique_request_number);
                                                                $update_data=$this->db->update('agent_wallet_history', $insert_array);
                                                            }
                                                            
                                                        $data[] = array(
                                                            "status" => '1',
                                                            "msg" => $status,
                                                            "request_id" => "NA"
                                                        );
                                                            
                                                        }else{
                                                            $data[] = array(
                                                            "status" => '0',
                                                            "msg" =>  $jsonDecode->message,
                                                            "request_id" => "NA"
                                                        );
                                                        }
                    
                }else{
                    $data[] = array(
                        "status" => '0',
                        "msg" => "Unauthorized User apptoken!",
                        "request_id" => "NA"
                    );
                }
            }else{
                  $data[] = array(
                        "status" => '0',
                        "msg" => "Unauthorized User!",
                        "request_id" => "NA"
                    );
              }
            }
        } catch (Exception $e) {
                $data[] = array(
                    "status" => '0',
                    "msg" => "Could not request Payment. Please try again!",
                    'error' => "Error: " . $e->getMessage()
                );
            }
            echo json_encode(array("result" => $data));
    }
    
    public function py_wallet_bank_temp(){
        try{
        $arrData = array();
        $post_data = $this->input->post();
        $ftoken = $this->input->post('ftoken');
        $token = $this->input->post('token');
        $uid = $this->input->post('uid');
        $ac_no = $this->input->post('ac_no');
        $ifsc_code = $this->input->post('ifsc_code');
         $amount_main = $this->input->post('amount');
        $mode = $this->input->post('mode');
        $payeename = $this->input->post('payeename');
        $app_pin = $this->input->post('app_pin');
        $keyy="C38AF3551B";
        $saalt="8E8771ED8B";
        $amount=round($amount_main,2);
        $length = 10;
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = "";
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        
        $charges="0.00";
        $curl_amount= (($charges * $amount)/100);
        $minus_amount="9";
        $additional_amt = bcadd($curl_amount,$minus_amount, 2);
        $compare_amt = bcadd($amount,$additional_amt, 2);
        
    //     $final_curl_amount = bcsub($curl_amount,$minus_amount, 2); 
    //     $final_curl_amount1=round($final_curl_amount,2);
      $admin_commision = bcsub($compare_amt,$amount, 2); 
        $query_service = $this->db->query("select api_name from agentServiceApi where id='5' and status='3'");
        $num_rows_service = $query_service->num_rows();
        if ($num_rows_service > 0) {
            
            if(!empty($uid)){
            $query = $this->db->query("select register_agent.* from register_agent join agent_account on(agent_account.agent_id=register_agent.id) where register_agent.ftoken='$ftoken' and register_agent.uid='$uid' and register_agent.app_pin='$app_pin' and register_agent.user_status='1' and agent_account.status='0'");
            $num_rows = $query->num_rows();
            if ($num_rows > 0) {
                $result = $query->row();
                
                $this->db->select('*');
                $this->db->where(['token' => $token, 'status' => 1]);
                $queryt = $this->db->get('apptoken');
                $num_rowt = $queryt->num_rows();
                if ($num_rowt > 0) {
                    $user_id=$result->id;
                    $name=$result->first_name;
                     if($ac_no!="" && $ifsc_code!="" && $amount!="" && $mode!=""){
                         $query_wallet_amount = $this->db->query("select current_balance from agent_account where agent_id='$user_id'");
                            $num_rows_wallet_amount = $query_wallet_amount->num_rows();
                            if($num_rows_wallet_amount > 0){
                                $result_wallet_amount = $query_wallet_amount->row();
                                $current_balance=$result_wallet_amount->current_balance;
                                if($current_balance >= $compare_amt){
                                    $today_date=date("d-m-Y");
                                        $sendData = array(
                                            'agent_id' => $user_id,
                                            'urn' => $randomString,
                                            'amount' => $compare_amt
                                        );
                                        $saved_data_wallet_bank_flow = $this->db->insert('wallet_bank_flow', $sendData);
                                        $lastid = $this->db->insert_id();
                                        if($saved_data_wallet_bank_flow){
                                            $closing_balance=bcsub($current_balance,$compare_amt, 2); 
                                            $sendData = array(
                                                'agent_id' => $user_id,
                                                'opening_bal' => $current_balance,
                                                'closing_bal' => $closing_balance,
                                                'credit_amount' => "0.00",
                                                'debit_amount' => "$compare_amt",
                                                'acc_no' => $ac_no,
                                                'ifsc' => $ifsc_code,
                                                'holder_name' => $payeename,
                                                'status' => "NA",
                                                'distributor_mob' => $amount,
                                                'distributor_name' => $mode,
                                                'remark' =>"Wallet to bank transfer",
                                                'credit_debit_status' => "debit",
                                                'urn' => $randomString,
                                               'admin_commision' => $admin_commision
                                            );
                                            $saved_data = $this->db->insert('agent_wallet_history', $sendData);
                                            $agent_wallet_history_id = $this->db->insert_id();
                                                    $insert_array = array(
                                            	        'current_balance' => $closing_balance
                                            	   );
                                                    $this->db->where('agent_id', $user_id);
                                                    $update_data=$this->db->update('agent_account', $insert_array);
                                                    if($saved_data && $update_data){
                                                        $insert_array = array(
                                            	        'status' => "1"
                                            	   );
                                                    $this->db->where('id', $lastid);
                                                    $update_data=$this->db->update('wallet_bank_flow', $insert_array);
                                                    
                                                    
                                                       
                                                        
                                                        
                                                         $hashvalue = $keyy.'|'.$ac_no.'|'.$ifsc_code.'||'.$randomString.'|'.$amount.'|'.$saalt;
                                                        $hashed_value = hash('sha512', $hashvalue);
                                                        
                                                        $passArray = array(
                                                            "key" => $keyy,
                                                            "beneficiary_type" => "bank_account",
                                                            "beneficiary_name" => $payeename,
                                                            "account_number" => $ac_no,
                                                            "ifsc" => $ifsc_code,
                                                            "upi_handle" => "",
                                                            "unique_request_number" => $randomString,
                                                            "payment_mode" => $mode,
                                                            "amount" => $amount,
                                                            "email" => "",
                                                            "phone" => "",
                                                            "narration" => "WALLET"
                                                        );
                                                        // print_r($passArray);
                                                        $encodeArray = json_encode($passArray);
                                                        // print_r($encodeArray);
                                                        
                                                        $curl = curl_init();
                                                        curl_setopt_array($curl, array(
                                                            CURLOPT_URL => 'https://wire.easebuzz.in/api/v1/quick_transfers/initiate/',
                                                            CURLOPT_RETURNTRANSFER => true,
                                                            CURLOPT_ENCODING => '',
                                                            CURLOPT_MAXREDIRS => 10,
                                                            CURLOPT_TIMEOUT => 0,
                                                            CURLOPT_FOLLOWLOCATION => true,
                                                            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                                            CURLOPT_CUSTOMREQUEST => 'POST',
                                                            CURLOPT_POSTFIELDS => "$encodeArray",
                                                            CURLOPT_HTTPHEADER => array(
                                                                'Content-Type: application/json',
                                                                'Accept: application/json',
                                                                'Authorization:'.$hashed_value
                                                            )
                                                        ));
                                        
                                                        $response = curl_exec($curl);
                                                        curl_close($curl);
                                                        // print_r($response); exit;
                                                            $jsonDecode = json_decode($response);
                                                         
                                                             if($jsonDecode->success==true){
                                                               if($jsonDecode->data->transfer_request->status=="accepted" || $jsonDecode->data->transfer_request->status=="success" || $jsonDecode->data->transfer_request->status=="pending" || $jsonDecode->data->transfer_request->status=="in_process"){
                                                                                 $unique_transaction_reference = $jsonDecode->data->transfer_request->unique_transaction_reference;
                                                                                $status=$jsonDecode->data->transfer_request->status;
                                                                                $settlement_datetime=date("Y-m-d  G:i:s");
                                                                            
                                                                             
                                                                                    $insert_array2 = array(
                                                                        	        'status' => "2"
                                                                        	   );
                                                                                $this->db->where('id', $lastid);
                                                                                $update_data2=$this->db->update('wallet_bank_flow', $insert_array2);
                                                                            
                                                                             $arrData = array(
                                                                                'status' => $status,
                                                                                'trans_id'=>$unique_transaction_reference,
                                                                                'urn'=>$randomString,
                                                                                'callback_date'=>$settlement_datetime
                                                                                
                                                                            );
                                                                            //echo "<pre>";print_r($arrData);exit;
                                                                            $this->db->where(['id' => $agent_wallet_history_id]);
                                                                            $this->db->update('agent_wallet_history', $arrData);
                                                                           
                                                                           $data[] = array(
                                                                                "status" => '1',
                                                                                "msg" => $status,
                                                                                
                                                                            );
                                                                            
                                                               }
                                                               
                                                               
                                                               
                                                               
                                                               
                                                                /////////GHS/////
                                                               
                                                               
                                                              else if($jsonDecode->data->transfer_request->status=="failure"){
                                                                                
                                                                  
                                                                   $query_wallet_amount1 = $this->db->query("select current_balance from agent_account where agent_id='$user_id'");
                                                                $num_rows_wallet_amount1 = $query_wallet_amount1->num_rows();
                                                                if($num_rows_wallet_amount1 > 0){
                                                                    $result_wallet_amount1 = $query_wallet_amount1->row();
                                                                    $current_balance1=$result_wallet_amount1->current_balance;
                                                                
                                
                                                               $message=$jsonDecode->data->transfer_request->failure_reason;
                                                                    $insert_array2 = array(
                                                                        	        'status' => "3"
                                                                        	   );
                                                                    $this->db->where('id', $lastid);
                                                                    $update_data2=$this->db->update('wallet_bank_flow', $insert_array2);
                                                                    
                                                                    $closing_balance2=bcadd($current_balance1,$compare_amt, 2); 
                                                                    
                                                                    $sendData = array(
                                                                        'agent_id' => $user_id,
                                                                        'opening_bal' => $current_balance1,
                                                                        'closing_bal' => $closing_balance2,
                                                                        'credit_amount' => $compare_amt,
                                                                        'debit_amount' => "0.00",
                                                                        'acc_no' => $ac_no,
                                                                        'ifsc' => $ifsc_code,
                                                                        'holder_name' => $payeename,
                                                                        'status' => "failure",
                                                                        'distributor_mob' => $amount,
                                                                        'distributor_name' => $mode,
                                                                        'remark' =>"Wallet to bank transfer refund",
                                                                        'credit_debit_status' => "credit",
                                                                        'urn' => $randomString,
                                                                    );
                                                                    $saved_data = $this->db->insert('agent_wallet_history', $sendData);
                                                                    $agent_wallet_history_id = $this->db->insert_id();
                                                                            $insert_array = array(
                                                                    	        'current_balance' => $closing_balance2
                                                                    	   );
                                                                            $this->db->where('agent_id', $user_id);
                                                                            $update_data=$this->db->update('agent_account', $insert_array);
                                                                            
                                                                             $data[] = array(
                                                                                "status" => '0',
                                                                                "msg" => $message,
                                                                                
                                                                            );
                                                                }
                                                               
                                                             }
                                                               
                                                               /////////GHS/////
                                                           
                                                               
                                                               
                                                           }else if($jsonDecode->success==false){
                                                               
                                                                $query_wallet_amount1 = $this->db->query("select current_balance from agent_account where agent_id='$user_id'");
                                                                $num_rows_wallet_amount1 = $query_wallet_amount1->num_rows();
                                                                if($num_rows_wallet_amount1 > 0){
                                                                    $result_wallet_amount1 = $query_wallet_amount1->row();
                                                                    $current_balance1=$result_wallet_amount1->current_balance;
                                                                
                                
                                                               $message=$jsonDecode->message;
                                                                    $insert_array2 = array(
                                                                        	        'status' => "3"
                                                                        	   );
                                                                    $this->db->where('id', $lastid);
                                                                    $update_data2=$this->db->update('wallet_bank_flow', $insert_array2);
                                                                    
                                                                    $closing_balance2=bcadd($current_balance1,$compare_amt, 2); 
                                                                    
                                                                    $sendData = array(
                                                                        'agent_id' => $user_id,
                                                                        'opening_bal' => $current_balance1,
                                                                        'closing_bal' => $closing_balance2,
                                                                        'credit_amount' => $compare_amt,
                                                                        'debit_amount' => "0.00",
                                                                        'acc_no' => $ac_no,
                                                                        'ifsc' => $ifsc_code,
                                                                        'holder_name' => $payeename,
                                                                        'status' => "NA",
                                                                        'distributor_mob' => $amount,
                                                                        'distributor_name' => $mode,
                                                                        'remark' =>"Wallet to bank transfer refund",
                                                                        'credit_debit_status' => "credit",
                                                                        'urn' => $randomString,
                                                                    );
                                                                    $saved_data = $this->db->insert('agent_wallet_history', $sendData);
                                                                    $agent_wallet_history_id = $this->db->insert_id();
                                                                            $insert_array = array(
                                                                    	        'current_balance' => $closing_balance2
                                                                    	   );
                                                                            $this->db->where('agent_id', $user_id);
                                                                            $update_data=$this->db->update('agent_account', $insert_array);
                                                                            
                                                                             $data[] = array(
                                                                                "status" => '0',
                                                                                "msg" => $message,
                                                                                
                                                                            );
                                                                }
                                                               }
                                                           
                                                           else{
                                                               $data[] = array(
                                                            "status" => '0',
                                                            "msg" => "Wallet Not Debited.",
                                                            
                                                        );
                                                           }
                                                        
                                                        
                                                        
                                                    }else{
                                                        $data[] = array(
                                                            "status" => '0',
                                                            "msg" => "Wallet Not Ddbited.",
                                                            
                                                        );
                                                    }
                                        }else{
                                            $data[] = array(
                                                            "status" => '0',
                                                            "msg" => "Wallet Not Ddbited.",
                                                            
                                                        );
                                        }
                                }else{
                                $data[] = array(
                                    "status" => '0',
                                    "msg" => "Insuficient Balance.",
                                    
                                );
                                }
                            }else{
                            $data[] = array(
                                "status" => '0',
                                "msg" => "Data Not Available.",
                                
                            );
                    }   
                     } else{
                        $data[] = array(
                            "status" => '0',
                            "msg" => "Data Not Available.",
                            
                        );
                    }             
                                
                }else{
                    $data[] = array(
                        "status" => '0',
                        "msg" => "Unauthorized User apptoken!",
                        
                    );
                }
            }else{
                  $data[] = array(
                        "status" => '0',
                        "msg" => "Unauthorized User!",
                        
                    );
              }
            }
        }else{
            $data[] = array(
                "status" => '0',
                "msg" => "Service Issues, Try Later",
                
            );
        }
    } catch (Exception $e) {
            $data[] = array(
                "status" => '0',
                "msg" => "Could not request Payment. Please try again!",
                'error' => "Error: " . $e->getMessage()
            );
        }
        echo json_encode(array("result" => $data));
    }
    
    
    public function verify_bene_agentt(){
        try{
        $arrData = array();
        $post_data = $this->input->post();
        $ftoken = $this->input->post('ftoken');
        $token = $this->input->post('token');
        $uid = $this->input->post('uid');
        $mobile = $this->input->post('mobile');
        $acount_no = $this->input->post('acount_no');
        $ifsc = $this->input->post('ifsc');
        $datetime=date("Y-m-d  G:i:s");
        
        if(!empty($uid)){
        $query = $this->db->query("select * from register_agent where ftoken='$ftoken' and uid='$uid' and user_status='1'");
        $num_rows = $query->num_rows();
        if ($num_rows > 0) {
            $result = $query->row();
            
            $this->db->select('*');
            $this->db->where(['token' => $token, 'status' => 1]);
            $queryt = $this->db->get('apptoken');
            $num_rowt = $queryt->num_rows();
            if ($num_rowt > 0) {
                $user_id=$result->id;
                
                $query_agent_account = $this->db->query("select * from agent_account where agent_id='$user_id' and status='0'");
                $num_rows_agent_account = $query_agent_account->num_rows();
                // echo $this->db->last_query(); exit;
                if ($num_rows_agent_account > 0) {
                    
                    $result_agent_account = $query_agent_account->row();
                  $current_balance=$result_agent_account->current_balance;
                 if($current_balance >= "3.50"){
                 $closing_balance= $current_balance - 3.50;
                
                            $apiToken = 'MD4X7D1W2LYMW9D8ZTUB';
                            $keyy="C38AF3551B";
                            $saalt="8E8771ED8B";
                            $randomString = mt_rand(1000000000, 9999999999);
                            
                            
                            if($apiToken != "" || $mobile != "" || $acount_no != "" || $ifsc != ""){
                                
                                 $hashvalue = $keyy.'|'.$acount_no.'|'.$ifsc.'|'.$saalt;
                                                     $hashed_value = hash('sha512', $hashvalue);
                                                    
                                                    $passArray = array(
                                                        "key" => $keyy,
                                                        "account_no" => $acount_no,
                                                        "ifsc" => $ifsc,
                                                        "unique_request_number" => $randomString
                                                    );
                                                    // print_r($passArray);
                                                    $encodeArray = json_encode($passArray);
                                                   // print_r($encodeArray);
                                                    
                                                    $curl = curl_init();
                                                    curl_setopt_array($curl, array(
                                                        CURLOPT_URL => 'https://wire.easebuzz.in/api/v1/beneficiaries/bank_account/verify/',
                                                        CURLOPT_RETURNTRANSFER => true,
                                                        CURLOPT_ENCODING => '',
                                                        CURLOPT_MAXREDIRS => 10,
                                                        CURLOPT_TIMEOUT => 0,
                                                        CURLOPT_FOLLOWLOCATION => true,
                                                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                                        CURLOPT_CUSTOMREQUEST => 'POST',
                                                        CURLOPT_POSTFIELDS => "$encodeArray",
                                                        CURLOPT_HTTPHEADER => array(
                                                            'Content-Type: application/json',
                                                            'Accept: application/json',
                                                            'Authorization:'.$hashed_value
                                                        )
                                                    ));
                                                    
                                                    $response = curl_exec($curl);
                                                    curl_close($curl);
                                                     //print_r($response); exit;
                                                        $jsonDecode = json_decode($response);
                                                         //print_r($jsonDecode); exit;
                                                        
                                if($jsonDecode->success== 1){
                                                    
                                if($jsonDecode->data->is_valid != 1){
                                    
                                    $data[] = array(
                                        'status' => '0',
                                        'statusMsg' => "Invalid Details",
                                        
                                    );
                                }else{
                                    
                                    $today_date=date("d-m-Y");
                                    $sendData = array(
                                        'agent_id' => $user_id,
                                        'opening_bal' => $current_balance,
                                        'closing_bal' => $closing_balance,
                                        'credit_amount' => "0.00",
                                        'debit_amount' => "3.50",
                                        'acc_no' => $acount_no,
                                        'ifsc' => $ifsc,
                                        'holder_name' => $jsonDecode->data->account_name,
                                        'status' => $jsonDecode->data->is_valid,
                                        'distributor_mob' => $mobile,
                                        'distributor_name' => "NA",
                                        'remark' =>"Payee Account Verified.",
                                        'callback_date' => $datetime,
                                        'credit_debit_status' => "debit",
                                    );
                                    $saved_data_wallet_history = $this->db->insert('agent_wallet_history', $sendData);
                                    if($saved_data_wallet_history){
                                        $insert_array = array(
                                	        'current_balance' => $closing_balance
                                	     );
                                        $this->db->where('agent_id', $user_id);
                                        $update_data=$this->db->update('agent_account', $insert_array);
                                        if($update_data){
                                            
                                    $data[] = array(
                                        'status' => '1',
                                        'statusMsg' => $jsonDecode->data->is_valid,
                                        'ben_name' => $jsonDecode->data->account_name
                                    );
                                    }else{
                                        $data[] = array(
                                            'status' => '0',
                                            'statusMsg' => "Failed",
                                            
                                        );
                                    }
                                    }
                                }
                            }
                                }else{
                                    $data[] = array(
                                        'status' => '0',
                                        'statusMsg' => "Data not available",
                                        
                                    );
                                }
                            }
                    else{
                                $data[] = array(
                                    "status" => '0',
                                    "statusMsg" => "Insufficient Balance.",
                                    
                                );
                            }
                }else{
                                $data[] = array(
                                    "status" => '0',
                                    "statusMsg" => "Wallet Blocked.",
                                    
                                );
                            }
                            
            }else{
                $data[] = array(
                    "status" => '0',
                    "statusMsg" => "Unauthorized User apptoken!",
                    
                );
            }
        }else{
              $data[] = array(
                    "status" => '0',
                    "statusMsg" => "Unauthorized User!",
                    
                );
          }
        }
    } catch (Exception $e) {
            $data[] = array(
                "status" => '0',
                "statusMsg" => "Could not request Payment. Please try again!",
                'error' => "Error: " . $e->getMessage()
            );
        }
        echo json_encode(array("result" => $data));
    }
    
    public function add_agent_balance_list(){
        $this->db->select('*');
        $this->db->from('agent_account');
        $records = $this->db->get()->result();
                            //   print_r($records); exit;
                                // echo $this->db->last_query();
            if ($records > 0) {
                // echo "in";
                foreach($records as $records){
                    // echo "in1";
                    $user_id = $records->id;
                    
                    $opening_balance=$records->current_balance;
                    $closing_balance=$records->current_balance;
                    $sendData = array(
                            'agent_id' => $user_id,
                            'opening_bal' => $opening_balance,
                            'closing_bal' => $closing_balance,
                        );
                        $saved_data_wallet_history = $this->db->insert('agent_balance_list', $sendData);
                        if($saved_data_wallet_history){
                            $data[] = array(
                                'status' => '1',
                                'statusMsg' => "Inserted Successfully !",
                                
                            );
                        }else{
                            $data[] = array(
                                'status' => '0',
                                'statusMsg' => "something went wrong while adding data !",
                                
                            );
                        }
                        
                    
                }
            
        }else{
            $data[] = array(
                'status' => '0',
                'statusMsg' => "Data not found!",
                
            );
        }
        echo json_encode(array("result" => $data));
    }
    
    
    public function py_wallet_bank_temp_jv(){
        try{
        $arrData = array();
        $post_data = $this->input->post();
        $ftoken = $this->input->post('ftoken');
        $token = $this->input->post('token');
        $uid = $this->input->post('uid');
        $ac_no = $this->input->post('ac_no');
        $ifsc_code = $this->input->post('ifsc_code');
         $amount_main = $this->input->post('amount');
        $mode = $this->input->post('mode');
        $payeename = $this->input->post('payeename');
        $app_pin = $this->input->post('app_pin');
        $keyy="C38AF3551B";
        $saalt="8E8771ED8B";
        $amount=round($amount_main,2);
        $length = 10;
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = "";
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        
        $charges="0.00";
        $curl_amount= (($charges * $amount)/100);
        $minus_amount="9";
        $additional_amt = bcadd($curl_amount,$minus_amount, 2);
        $compare_amt = bcadd($amount,$additional_amt, 2);
        
    //     $final_curl_amount = bcsub($curl_amount,$minus_amount, 2); 
    //     $final_curl_amount1=round($final_curl_amount,2);
      $admin_commision = bcsub($compare_amt,$amount, 2); 
        $query_service = $this->db->query("select api_name from agentServiceApi where id='5' and status='3'");
        $num_rows_service = $query_service->num_rows();
        if ($num_rows_service > 0) {
            
            if(!empty($uid)){
            $query = $this->db->query("select register_agent.* from register_agent join agent_account on(agent_account.agent_id=register_agent.id) where register_agent.ftoken='$ftoken' and register_agent.uid='$uid' and register_agent.app_pin='$app_pin' and register_agent.user_status='1' and agent_account.status='0'");
            $num_rows = $query->num_rows();
            if ($num_rows > 0) {
                $result = $query->row();
                
                $this->db->select('*');
                $this->db->where(['token' => $token, 'status' => 1]);
                $queryt = $this->db->get('apptoken');
                $num_rowt = $queryt->num_rows();
                if ($num_rowt > 0) {
                    $user_id=$result->id;
                    $name=$result->first_name;
                     if($ac_no!="" && $ifsc_code!="" && $amount!="" && $mode!=""){
                         $query_wallet_amount = $this->db->query("select current_balance from agent_account where agent_id='$user_id'");
                            $num_rows_wallet_amount = $query_wallet_amount->num_rows();
                            if($num_rows_wallet_amount > 0){
                                $result_wallet_amount = $query_wallet_amount->row();
                                $current_balance=$result_wallet_amount->current_balance;
                                if($current_balance >= $compare_amt){
                                    $today_date=date("d-m-Y");
                                        $sendData = array(
                                            'agent_id' => $user_id,
                                            'urn' => $randomString,
                                            'amount' => $compare_amt
                                        );
                                        $saved_data_wallet_bank_flow = $this->db->insert('wallet_bank_flow', $sendData);
                                        $lastid = $this->db->insert_id();
                                        if($saved_data_wallet_bank_flow){
                                            $closing_balance=bcsub($current_balance,$compare_amt, 2); 
                                            $sendData = array(
                                                'agent_id' => $user_id,
                                                'opening_bal' => $current_balance,
                                                'closing_bal' => $closing_balance,
                                                'credit_amount' => "0.00",
                                                'debit_amount' => "$compare_amt",
                                                'acc_no' => $ac_no,
                                                'ifsc' => $ifsc_code,
                                                'holder_name' => $payeename,
                                                'status' => "NA",
                                                'distributor_mob' => $amount,
                                                'distributor_name' => $mode,
                                                'remark' =>"Wallet to bank transfer",
                                                'credit_debit_status' => "debit",
                                                'urn' => $randomString,
                                               'admin_commision' => $admin_commision
                                            );
                                            $saved_data = $this->db->insert('agent_wallet_history', $sendData);
                                            $agent_wallet_history_id = $this->db->insert_id();
                                                    $insert_array = array(
                                            	        'current_balance' => $closing_balance
                                            	   );
                                                    $this->db->where('agent_id', $user_id);
                                                    $update_data=$this->db->update('agent_account', $insert_array);
                                                    if($saved_data && $update_data){
                                                        $insert_array = array(
                                            	        'status' => "1"
                                            	   );
                                                    $this->db->where('id', $lastid);
                                                    $update_data=$this->db->update('wallet_bank_flow', $insert_array);
                                                    
                                                    
                                                       
                                                        
                                                        
                                                         $hashvalue = $keyy.'|'.$ac_no.'|'.$ifsc_code.'||'.$randomString.'|'.$amount.'|'.$saalt;
                                                        $hashed_value = hash('sha512', $hashvalue);
                                                        
                                                        $passArray = array(
                                                            "key" => $keyy,
                                                            "beneficiary_type" => "bank_account",
                                                            "beneficiary_name" => $payeename,
                                                            "account_number" => $ac_no,
                                                            "ifsc" => $ifsc_code,
                                                            "upi_handle" => "",
                                                            "unique_request_number" => $randomString,
                                                            "payment_mode" => $mode,
                                                            "amount" => $amount,
                                                            "email" => "",
                                                            "phone" => "",
                                                            "narration" => "ST"
                                                        );
                                                        // print_r($passArray);
                                                        $encodeArray = json_encode($passArray);
                                                         print_r($encodeArray);
                                                        
                                                        $curl = curl_init();
                                                        curl_setopt_array($curl, array(
                                                            CURLOPT_URL => 'https://wire.easebuzz.in/api/v1/quick_transfers/initiate/',
                                                            CURLOPT_RETURNTRANSFER => true,
                                                            CURLOPT_ENCODING => '',
                                                            CURLOPT_MAXREDIRS => 10,
                                                            CURLOPT_TIMEOUT => 0,
                                                            CURLOPT_FOLLOWLOCATION => true,
                                                            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                                            CURLOPT_CUSTOMREQUEST => 'POST',
                                                            CURLOPT_POSTFIELDS => "$encodeArray",
                                                            CURLOPT_HTTPHEADER => array(
                                                                'Content-Type: application/json',
                                                                'Accept: application/json',
                                                                'Authorization:'.$hashed_value
                                                            )
                                                        ));
                                        
                                                       echo $response = curl_exec($curl);
                                                        curl_close($curl);
                                                         print_r($response); 
                                                         exit;
                                                            $jsonDecode = json_decode($response);
                                                         
                                                             if($jsonDecode->success==true){
                                                               if($jsonDecode->data->transfer_request->status=="accepted" || $jsonDecode->data->transfer_request->status=="success" || $jsonDecode->data->transfer_request->status=="pending" || $jsonDecode->data->transfer_request->status=="in_process"){
                                                                                 $unique_transaction_reference = $jsonDecode->data->transfer_request->unique_transaction_reference;
                                                                                $status=$jsonDecode->data->transfer_request->status;
                                                                                $settlement_datetime=date("Y-m-d  G:i:s");
                                                                            
                                                                             
                                                                                    $insert_array2 = array(
                                                                        	        'status' => "2"
                                                                        	   );
                                                                                $this->db->where('id', $lastid);
                                                                                $update_data2=$this->db->update('wallet_bank_flow', $insert_array2);
                                                                            
                                                                             $arrData = array(
                                                                                'status' => $status,
                                                                                'trans_id'=>$unique_transaction_reference,
                                                                                'urn'=>$randomString,
                                                                                'callback_date'=>$settlement_datetime
                                                                                
                                                                            );
                                                                            //echo "<pre>";print_r($arrData);exit;
                                                                            $this->db->where(['id' => $agent_wallet_history_id]);
                                                                            $this->db->update('agent_wallet_history', $arrData);
                                                                           
                                                                           $data[] = array(
                                                                                "status" => '1',
                                                                                "msg" => $status,
                                                                                
                                                                            );
                                                                            
                                                               }
                                                           }else if($jsonDecode->success==false){
                                                               
                                                                $query_wallet_amount1 = $this->db->query("select current_balance from agent_account where agent_id='$user_id'");
                                                                $num_rows_wallet_amount1 = $query_wallet_amount1->num_rows();
                                                                if($num_rows_wallet_amount1 > 0){
                                                                    $result_wallet_amount1 = $query_wallet_amount1->row();
                                                                    $current_balance1=$result_wallet_amount1->current_balance;
                                                                
                                
                                                               $message=$jsonDecode->message;
                                                                    $insert_array2 = array(
                                                                        	        'status' => "3"
                                                                        	   );
                                                                    $this->db->where('id', $lastid);
                                                                    $update_data2=$this->db->update('wallet_bank_flow', $insert_array2);
                                                                    
                                                                    $closing_balance2=bcadd($current_balance1,$compare_amt, 2); 
                                                                    
                                                                    $sendData = array(
                                                                        'agent_id' => $user_id,
                                                                        'opening_bal' => $current_balance1,
                                                                        'closing_bal' => $closing_balance2,
                                                                        'credit_amount' => $compare_amt,
                                                                        'debit_amount' => "0.00",
                                                                        'acc_no' => $ac_no,
                                                                        'ifsc' => $ifsc_code,
                                                                        'holder_name' => $payeename,
                                                                        'status' => "NA",
                                                                        'distributor_mob' => $amount,
                                                                        'distributor_name' => $mode,
                                                                        'remark' =>"Wallet to bank transfer refund",
                                                                        'credit_debit_status' => "credit",
                                                                        'urn' => $randomString,
                                                                    );
                                                                    $saved_data = $this->db->insert('agent_wallet_history', $sendData);
                                                                    $agent_wallet_history_id = $this->db->insert_id();
                                                                            $insert_array = array(
                                                                    	        'current_balance' => $closing_balance2
                                                                    	   );
                                                                            $this->db->where('agent_id', $user_id);
                                                                            $update_data=$this->db->update('agent_account', $insert_array);
                                                                            
                                                                             $data[] = array(
                                                                                "status" => '0',
                                                                                "msg" => $message,
                                                                                
                                                                            );
                                                                }
                                                               }
                                                           
                                                           else{
                                                               $data[] = array(
                                                            "status" => '0',
                                                            "msg" => "Wallet Not Debited.",
                                                            
                                                        );
                                                           }
                                                        
                                                        
                                                        
                                                    }else{
                                                        $data[] = array(
                                                            "status" => '0',
                                                            "msg" => "Wallet Not Ddbited.",
                                                            
                                                        );
                                                    }
                                        }else{
                                            $data[] = array(
                                                            "status" => '0',
                                                            "msg" => "Wallet Not Ddbited.",
                                                            
                                                        );
                                        }
                                }else{
                                $data[] = array(
                                    "status" => '0',
                                    "msg" => "Insuficient Balance.",
                                    
                                );
                                }
                            }else{
                            $data[] = array(
                                "status" => '0',
                                "msg" => "Data Not Available.",
                                
                            );
                    }   
                     } else{
                        $data[] = array(
                            "status" => '0',
                            "msg" => "Data Not Available.",
                            
                        );
                    }             
                                
                }else{
                    $data[] = array(
                        "status" => '0',
                        "msg" => "Unauthorized User apptoken!",
                        
                    );
                }
            }else{
                  $data[] = array(
                        "status" => '0',
                        "msg" => "Unauthorized User!",
                        
                    );
              }
            }
        }else{
            $data[] = array(
                "status" => '0',
                "msg" => "Service Issues, Try Later",
                
            );
        }
    } catch (Exception $e) {
            $data[] = array(
                "status" => '0',
                "msg" => "Could not request Payment. Please try again!",
                'error' => "Error: " . $e->getMessage()
            );
        }
        echo json_encode(array("result" => $data));
    }
    
    public function add_date_wise_balance_list(){
        $this->db->select('*');
        $this->db->from('agent_account');
        $records = $this->db->get()->result();
                            //   print_r($records); exit;
                                // echo $this->db->last_query();
        $today_date=date("Y-m-d");
        $tdate = "$today_date 23:59:59";
        $fdate = "$today_date 00:00:00";
            if ($records > 0) {
                $this->db->select('*');
                $this->db->from('date_wise_balance');
                $this->db->where('DATE(created_at)',$today_date);
                $records_by_date = $this->db->get()->result();
                if(empty($records_by_date)){
                // echo "in";
                foreach($records as $records){
                    // echo "in1";
                    $user_id = $records->id;
                    $opening_balance=$records->current_balance;
                    
                    $this->db->select('sum(debit_amount) as debit_amount');
                     $this->db->from('agent_wallet_history a');
                      $this->db->join('register_agent b','a.agent_id=b.id');
                    
                            $this->db->where('b.id',$user_id);
                            $this->db->where("a.created_at >=",$fdate);
                            $this->db->where("a.created_at <=",$tdate);
                        
                        $this->db->where('a.credit_debit_status','debit');
                        $this->db->where('a.remark','Wallet to bank transfer');
                         $this->db->group_start();
                        $this->db->where('a.status','accepted');
                    $this->db->or_where('a.status','success');
                    $this->db->or_where('a.status','pending');
                    $this->db->or_where('a.status','in_process');
                     $this->db->group_end();
                    
                     $records_sum = $this->db->get()->result();
                     
                     
                     $this->db->select('sum(amount) as request_amount,sum(settlement_amount) as credit_amount');
                     $this->db->from('link_request a');
                      $this->db->join('register_agent b','a.uid=b.id');
                    
                            $this->db->where('b.id',$user_id);
                            $this->db->where("a.created_date >=",$fdate);
                            $this->db->where("a.created_date <=",$tdate);
                        
                        $this->db->where('a.status','1');
                        $this->db->where('a.satelment','1');
                    
                     $credit_request_sum = $this->db->get()->result();
                    //  echo $this->db->last_query();
                     if($records_sum > 0){
                         $used_balance=$records_sum[0]->debit_amount;
                         if(!empty($credit_request_sum[0]->credit_amount)){
                         $credit_amount=$credit_request_sum[0]->credit_amount;
                         }else{
                            $credit_amount="0.00"; 
                         }
                         if(!empty($credit_request_sum[0]->request_amount)){
                         $request_amount=$credit_request_sum[0]->request_amount;
                         }else{
                            $request_amount="0.00"; 
                         }
                         $sendData = array(
                            'agent_id' => $user_id,
                            'wallet_balance' => $opening_balance,
                            'used_balance' => $used_balance,
                            'request_amt' => $request_amount,
                            'credit_amt' => $credit_amount
                        );
                     }else{
                         $sendData = array(
                            'agent_id' => $user_id,
                            'wallet_balance' => $opening_balance,
                            'request_amt' => '0.00',
                            'credit_amt' => '0.00'
                        );
                     }
                    
                        $saved_data_wallet_history = $this->db->insert('date_wise_balance', $sendData);
                        if($saved_data_wallet_history){
                            $data[] = array(
                                'status' => '1',
                                'statusMsg' => "Inserted Successfully !",
                                
                            );
                        }else{
                            $data[] = array(
                                'status' => '0',
                                'statusMsg' => "something went wrong while adding data !",
                                
                            );
                        }
                        
                    
                }
                }else{
                    $data[] = array(
                'status' => '0',
                'statusMsg' => "Data Already Added!",
                
            );
                }
            
        }else{
            $data[] = array(
                'status' => '0',
                'statusMsg' => "Data not found!",
                
            );
        }
        echo json_encode(array("result" => $data));
    }
    
    public function add_date_wise_balance_list_test(){
        $this->db->select('*');
        $this->db->from('agent_account');
        $records = $this->db->get()->result();
                            //   print_r($records); exit;
                                // echo $this->db->last_query();
        $today_date=date("Y-m-d");
        $tdate = "$today_date 23:59:59";
        $fdate = "$today_date 00:00:00";
            if ($records > 0) {
                $this->db->select('*');
                $this->db->from('date_wise_balance_test');
                $this->db->where('DATE(created_at)',$today_date);
                $records_by_date = $this->db->get()->result();
                if(empty($records_by_date)){
                // echo "in";
                foreach($records as $records){
                    // echo "in1";
                    $user_id = $records->id;
                    $opening_balance=$records->current_balance;
                    
                    $this->db->select('sum(debit_amount) as debit_amount');
                     $this->db->from('agent_wallet_history a');
                      $this->db->join('register_agent b','a.agent_id=b.id');
                    
                            $this->db->where('b.id',$user_id);
                            $this->db->where("a.created_at >=",$fdate);
                            $this->db->where("a.created_at <=",$tdate);
                        
                        $this->db->where('a.credit_debit_status','debit');
                        $this->db->where('a.remark','Wallet to bank transfer');
                         $this->db->group_start();
                        $this->db->where('a.status','accepted');
                    $this->db->or_where('a.status','success');
                    $this->db->or_where('a.status','pending');
                    $this->db->or_where('a.status','in_process');
                     $this->db->group_end();
                    
                     $records_sum = $this->db->get()->result();
                     
                     
                     $this->db->select('sum(amount) as request_amount,sum(settlement_amount) as credit_amount');
                     $this->db->from('link_request a');
                      $this->db->join('register_agent b','a.uid=b.id');
                    
                            $this->db->where('b.id',$user_id);
                            $this->db->where("a.created_date >=",$fdate);
                            $this->db->where("a.created_date <=",$tdate);
                        
                        $this->db->where('a.status','1');
                        $this->db->where('a.satelment','1');
                    
                     $credit_request_sum = $this->db->get()->result();
                    //  echo $this->db->last_query();
                     if($records_sum > 0){
                         $used_balance=$records_sum[0]->debit_amount;
                         if(!empty($credit_request_sum[0]->credit_amount)){
                         $credit_amount=$credit_request_sum[0]->credit_amount;
                         }else{
                            $credit_amount="0.00"; 
                         }
                         if(!empty($credit_request_sum[0]->request_amount)){
                         $request_amount=$credit_request_sum[0]->request_amount;
                         }else{
                            $request_amount="0.00"; 
                         }
                         $sendData = array(
                            'agent_id' => $user_id,
                            'wallet_balance' => $opening_balance,
                            'used_balance' => $used_balance,
                            'request_amt' => $request_amount,
                            'credit_amt' => $credit_amount
                        );
                     }else{
                         $sendData = array(
                            'agent_id' => $user_id,
                            'wallet_balance' => $opening_balance,
                            'request_amt' => '0.00',
                            'credit_amt' => '0.00'
                        );
                     }
                    
                        $saved_data_wallet_history = $this->db->insert('date_wise_balance_test', $sendData);
                        if($saved_data_wallet_history){
                            $data = array(
                                        'sts' => '1',
                                        'message' => "inserted Successfully"
                                        );
                            } else {
                                 $data = array(
                                        'sts' => '0',
                                        'message' => "Something went Wrong"
                                        );
                            }
                        
                    
                }
                }else{
                    $data = array(
                                        'sts' => '0',
                                        'message' => "Data Already Added!"
                                        );
                    
                }
            
        }else{
            $data = array(
                'sts' => '0',
                'message' => "Data not found!"
                
            );
        }
        echo json_encode($data);
        // echo json_encode(array("result" => $data));
    }
    
    public function add_distributor(){
        try{
        $arrData = array();
        $post_data = $this->input->post();
        $ftoken = $this->input->post('ftoken');
        $token = $this->input->post('token');
        $uid = $this->input->post('agent_id');
        echo $mobile = $this->input->post('mobile');
        $name = $this->input->post('name');
        $email = $this->input->post('email');
        $password = $this->input->post('password');
        $datetime=date("Y-m-d  G:i:s");
        
        if(!empty($uid)){
        $query = $this->db->query("select * from register_agent where ftoken='$ftoken' and uid='$uid' and user_status='1'");
        $num_rows = $query->num_rows();
        if ($num_rows > 0) {
            $result = $query->row();
            
            $this->db->select('*');
            $this->db->where(['token' => $token, 'status' => 1]);
            $queryt = $this->db->get('apptoken');
            $num_rowt = $queryt->num_rows();
            if ($num_rowt > 0) {
                $user_id=$result->id;
                
                $query_agent_account = $this->db->query("select * from add_distributor where mobile='$mobile'");
                $num_rows_agent_account = $query_agent_account->num_rows();
                // echo $this->db->last_query(); exit;
                if (empty($num_rows_agent_account)) {
                    
                  $insert_data = array(
                                'agent_id' => $user_id,
                                'name' => $name,
                                'mobile' => $mobile,
                                'email' => $email,
                                'password' => $password
                                );
                           $saved_data = $this->db->insert('add_distributor', $insert_data);
                           
                           $data[] = array(
                                    "status" => '1',
                                    "statusMsg" => "Insert Successfully",
                                    
                                );
                
                }else{
                                $data[] = array(
                                    "status" => '0',
                                    "statusMsg" => "Mobile Number Already Registered.",
                                    
                                );
                            }
                            
            }else{
                $data[] = array(
                    "status" => '0',
                    "statusMsg" => "Unauthorized User apptoken!",
                    
                );
            }
        }else{
              $data[] = array(
                    "status" => '0',
                    "statusMsg" => "Unauthorized User!",
                    
                );
          }
        }
    } catch (Exception $e) {
            $data[] = array(
                "status" => '0',
                "statusMsg" => "Could not request Payment. Please try again!",
                'error' => "Error: " . $e->getMessage()
            );
        }
        echo json_encode(array("result" => $data));
    }
    
}


        
