<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Json_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }

    public function payment_request($data) {
        if (!empty($data)) {
            $insert = $this->db->insert('transfer_request', $data);
            return $insert ? $this->db->insert_id() : false;
        }
        return false;
    }
    
    public function getUsersById($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('register_users');
        $count_row = $query->num_rows();
        if ($count_row > 0) {
            return $query->row();
        } else {
            return FALSE;
        }
    }
    public function getWalletTransation($id) {

     $this->db->select('wallet_transation.*, register_users.first_name,register_users.last_name,register_users.mobile_no');
     $this->db->from('wallet_transation');
     $this->db->join('register_users', 'wallet_transation.user_id = register_users.id', 'left');
     $this->db->where('wallet_transation.user_id',$id);
     $this->db->limit(90, 0);
     $this->db->order_by('wallet_transation.id','DESC');
     $query = $this->db->get();
     $count_row = $query->num_rows();
     if ($count_row > 0) {
        return $query->result();
     } else {
        return FALSE;
     }
    }
    public function getAgentById($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('register_agent');
        $count_row = $query->num_rows();
        if ($count_row > 0) {
            return $query->row();
        } else {
            return FALSE;
        }
    }
    
    public function user_kyc($data) {
        if (!empty($data)) {
            $insert = $this->db->insert('users_documents', $data);
            return $insert ? $this->db->insert_id() : false;
        }
        return false;
    }
    
     public function update_user_kyc($data) {
        if (!empty($data)) {
            $this->db->where('user_id',$data['user_id']);
            return $this->db->update('users_documents', $data);
        }
        return false;
    }
    
    public function agent_kyc($data) {
        if (!empty($data)) {
            $insert = $this->db->insert('agent_documents', $data);
            return $insert ? $this->db->insert_id() : false;
        }
        return false;
    }
    
     public function update_agent_kyc($data) {
        if (!empty($data)) {
            $this->db->where('user_id',$data['user_id']);
            return $this->db->update('agent_documents', $data);
        }
        return false;
    }
    
     public function Add_Payee($data) {
        if (!empty($data)) {
            $insert = $this->db->insert('payee_list', $data);
            return $insert ? $this->db->insert_id() : false;
        }
        return false;
    }
    
         public function Add_Payee_Agent($data) {
        if (!empty($data)) {
            $insert = $this->db->insert('payee_list_agent', $data);
            return $insert ? $this->db->insert_id() : false;
        }
        return false;
    }
    
    public function Add_Payee_Agent_beneficiary($data) {
        if (!empty($data)) {
            $insert = $this->db->insert('agent_user_beneficiary', $data);
            return $insert ? $this->db->insert_id() : false;
        }
        return false;
    }
    
    public function Add_User_address($data) {
        if (!empty($data)) {
            $insert = $this->db->insert('users_address', $data);
            return $insert ? $this->db->insert_id() : false;
        }
        return false;
    }
    public function getUsersAddress($id){
        $this->db->where('user_id', $id);
        $query = $this->db->get('users_address');
        $count_row = $query->num_rows();
        if ($count_row > 0) {
            return $query->result_array();
        } else {
            return FALSE;
        }
    }
    
     public function Update_User_address($data){
        $this->db->where('user_id',$data['user_id']);
        return $this->db->update('users_address', $data);
    }
    
    
    public function getBeneficaryList($id){
        $this->db->where('user_id', $id);
        $query = $this->db->get('payee_list_agent');
        $count_row = $query->num_rows();
        // echo $this->db->last_query(); exit;
        if ($count_row > 0) {
            return $query->result_array();
        } else {
            return FALSE;
        }
    }
    
    public function getAgentBeneficaryList($id){
        $this->db->where('user_id', $id);
        $query = $this->db->get('payee_list_agent');
        $count_row = $query->num_rows();
        if ($count_row > 0) {
            return $query->row();
        } else {
            return FALSE;
        }
    }
    
    public function UpdatePassword($data,$mobile_no){
        $this->db->where('mobile_no',$mobile_no);
        return $this->db->update('register_users', $data);
    }
    
      public function checkService($opname){
        $this->db->select('*');
        $this->db->from('recharge_operator');
        $this->db->like('api_key',$opname);
        $this->db->where('status','1');
        $q = $this->db->get();
        if ($q->num_rows() > 0) {
            return $q->row();
        }      
        return FALSE;
    }
    
        public function insert_rechage_info($data){
        if (!empty($data)) {
            $insert = $this->db->insert('recharge', $data);
            return $insert ? $this->db->insert_id() : false;
        }
        return false;
    }
    
    
    public function checkMobileNumbers($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('register_users');
        $count_row = $query->num_rows();
        if ($count_row > 0) {
            return $query->row();
        } else {
            return FALSE;
        }
    }
    
    public function transaction_history($user_id){
        $this->db->select('transfer_request.*, register_users.first_name,register_users.last_name,register_users.mobile_no')
            ->join('register_users', 'transfer_request.user_id = register_users.id', 'left');
            // $this->db->where('transfer_request.status','1');
            $this->db->where('register_users.id',$user_id);
             $this->db->order_by('id','DESC');
        $q = $this->db->get('transfer_request');
        if ($q->num_rows() > 0) {
            return $q->result();
        }
        return FALSE;
    }
    
    public function transaction_amount($user_id){
        $this->db->select('sum(amount) as amount');
            $this->db->where('transfer_request.user_id',$user_id);
            $this->db->like('cdate', date('Y-m'));
        $q = $this->db->get('transfer_request');
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }
    
    public function daily_transaction_amount($user_id){
        $this->db->select('sum(amount) as amount');
            $this->db->where('transfer_request.user_id',$user_id);
            $this->db->like('cdate', date('Y-m-d'));
        $q = $this->db->get('transfer_request');
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }
    
    public function transaction_history_by_id($id){
        $this->db->select('transfer_request.*, register_users.first_name,register_users.last_name,register_users.mobile_no')
            ->join('register_users', 'transfer_request.user_id = register_users.id', 'left');
            $this->db->where('transfer_request.status','1');
            $this->db->where('transfer_request.id',$id);
        $q = $this->db->get('transfer_request');
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }
    
    public function getUsersDocuments($id) {
        $this->db->select('users_documents.*, register_users.first_name,register_users.last_name,register_users.mobile_no')
            ->join('register_users', 'users_documents.user_id = register_users.id', 'left');
            $this->db->where('users_documents.user_id',$id);
        $q = $this->db->get('users_documents');
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }
    
    public function getAgentDocuments($id) {
        $this->db->select('agent_documents.*, register_agent.first_name,register_agent.last_name,register_agent.mobile_no')
            ->join('register_agent', 'agent_documents.user_id = register_agent.id', 'left');
            $this->db->where('agent_documents.user_id',$id);
        $q = $this->db->get('agent_documents');
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }
    
     public function getDocumentsByUserId($user_id) {
        $this->db->select('*');
        $this->db->where('user_id',$user_id);
        $q = $this->db->get('users_documents');
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }
    
    public function getDocumentsByAgentId($user_id) {
        $this->db->select('*');
        $this->db->where('user_id',$user_id);
        $q = $this->db->get('agent_documents');
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }
    
    
    
    public function insert_bank_details($data){
        if (!empty($data)) {
            $insert = $this->db->insert('user_bank_details', $data);
            return $insert ? $this->db->insert_id() : false;
        }
        return false;
    }
    public function update_bank_details($data,$user_id){
        $this->db->where('user_id',$user_id);
        return $this->db->update('user_bank_details', $data);
    }
    
    public function checkBankByUserId($id) {
        $this->db->where('user_id', $id);
        $query = $this->db->get('user_bank_details');
        $count_row = $query->num_rows();
        if ($count_row > 0) {
            return $query->row();
        } else {
            return FALSE;
        }
    }
    
    public function update_user_photo($data,$user_id){
        $this->db->where('id',$user_id);
        return $this->db->update('register_users', $data);
    }
    
    public function getReferralUsers($id){
        $this->db->where('referral_user_id', $id);
        $query = $this->db->get('referral_list');
        $count_row = $query->num_rows();
        if ($count_row > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
    }
    
    public function deleteBeneficiary($beneficiary,$user_id){
        $this->db->where('id',$beneficiary);
        $this->db->where('user_id',$user_id);
        return $this->db->delete('payee_list');
    }
    
    
    public function get_users_by_referral_code($id){
        $this->db->where('referral_user_id', $id);
        $query = $this->db->get('referral_list');
        $count_row = $query->num_rows();
        if ($count_row > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
    }
    
    public function check_users_block($id){
        $this->db->where('id', $id);
        $this->db->where('user_status', 1);
        $query = $this->db->get('register_users');
        $count_row = $query->num_rows();
        if ($count_row > 0) {
            return $query->row();
        } else {
            return FALSE;
        }
    }
    
     /* ----------------- search -------------------- */
    
    
    public function search_all_users($mobile_no="",$date=""){
        $where = "DATE(created_at)='$date'";
        $this->db->select('*');
        $this->db->from('register_users');
        if($mobile_no){
            $this->db->where('mobile_no',$mobile_no );
        } 
        $this->db->order_by("id", "desc");
        $q = $this->db->get();
        if ($q->num_rows() > 0) {
            return $q->result();
        }
        return FALSE;
    }
    
    public function search_all_kyc($mobile_no,$limit, $start){
        $this->db->select('users_documents.*, register_users.first_name,register_users.last_name,register_users.mobile_no');
        $this->db->from('users_documents');
        $this->db->join('register_users', 'users_documents.user_id = register_users.id', 'left');
        $this->db->where('register_users.mobile_no',$mobile_no);
        $this->db->order_by('users_documents.id', 'desc');
        $this->db->limit($limit, $start);
        $q = $this->db->get();
        if ($q->num_rows() > 0) {
            return $q->result();
        }
        return FALSE;
    }
    
    public function search_all_kyc_count($mobile_no){
        $this->db->select('users_documents.*, register_users.first_name,register_users.last_name,register_users.mobile_no');
        $this->db->from('users_documents');
        $this->db->join('register_users', 'users_documents.user_id = register_users.id', 'left');
        $this->db->where('register_users.mobile_no',$mobile_no);
        $q = $this->db->get();
        if ($q->num_rows() > 0) {
            return $q->num_rows();
        }
        return FALSE;
    }
    
    public function get_CountAll_Request($mobile_no,$date) {
        $this->db->select('transfer_request.*, register_users.first_name,register_users.last_name,register_users.mobile_no')
                ->join('register_users', 'transfer_request.user_id = register_users.id', 'left');
        if($mobile_no){
            $this->db->where('register_users.mobile_no',$mobile_no );
        } 
        if($date){
            $this->db->where('transfer_request.cdate', $date);
        }
        $this->db->where('transfer_request.status', '0');
        $q = $this->db->get('transfer_request');
        if ($q->num_rows() > 0) {
            return $q->result();
        }
        return FALSE;
    }
    
    public function get_All_Request($mobile_no="",$date="") {
        $this->db->select('transfer_request.*, register_users.first_name,register_users.last_name,register_users.mobile_no')
                ->join('register_users', 'transfer_request.user_id = register_users.id', 'left');
        $this->db->where('transfer_request.status', '0');
        $this->db->where('transfer_request.dstatus', '0');
        if($mobile_no){
            $this->db->where('register_users.mobile_no',$mobile_no );
        } 
        if($date){
            $this->db->where('transfer_request.cdate', $date);
        }
        $this->db->order_by('transfer_request.id', 'desc');
        
        $q = $this->db->get('transfer_request');
        if ($q->num_rows() > 0) {
            return $q->result();
        }
        return FALSE;
    }
    
    public function get_All_History($mobile_no="",$date="") {
        
        $where = "DATE(debited_date)='$date'";
            
        $this->db->select('transfer_request.*, register_users.first_name,register_users.last_name,register_users.mobile_no')
                ->join('register_users', 'transfer_request.user_id = register_users.id', 'left');
        $this->db->where('transfer_request.status', '1');
        if($mobile_no){
            $this->db->where('register_users.mobile_no',$mobile_no );
        } 
        if($date){
            $this->db->where($where);
        }
        $this->db->order_by('transfer_request.id', 'desc');

        $q = $this->db->get('transfer_request');
       
        if ($q->num_rows() > 0) {
            return $q->result();
        }
        return FALSE;
    }
    
    public function update_request_data($data,$id) {
        if (!empty($data)) {
            $this->db->where('id',$id);
            return $this->db->update('transfer_request', $data);
        }
        return false;
    }
    
    public function checkUserRequest($user_id,$card_no=null){
        $this->db->where('user_id', $user_id);
        $this->db->where('card_number', $card_no);
        $this->db->where('card_status', '3');
        $query = $this->db->get('transfer_request');
        $count_row = $query->num_rows();
        if ($count_row > 0) {
            return $query->row();
        } else {
            return FALSE;
        }
    }
    
     public function getRechageData($client_id){
        $this->db->select('*');
        $this->db->from('recharge');
        $this->db->where('my_orderid',$client_id);
        $q = $this->db->get();
        if ($q->num_rows() > 0) {
            return $q->row();
        }      
        return FALSE;
    }
    
    public function update_rechage_data($data,$id){
        if (!empty($data)) {
            $this->db->where('my_orderid',$id);
            return $this->db->update('recharge', $data);
        }
        return false;
    }
    
    public function getRechargeHistory($id) {
     $this->db->select('recharge.*, register_users.first_name,register_users.last_name,register_users.mobile_no');
     $this->db->from('recharge');
     $this->db->join('register_users', 'recharge.user_id = register_users.id', 'left');
     $this->db->where('recharge.user_id',$id);
     $this->db->limit(90, 0);
     $this->db->order_by('recharge.id','DESC');
     $query = $this->db->get();
     $count_row = $query->num_rows();
     if ($count_row > 0) {
        return $query->result();
     } else {
        return FALSE;
     }
    }
    
    public function get_total_amount_paid($from_date,$to_date,$uid){
        $fdate = "$from_date 00:00:00";
        $tdate = "$to_date 59:59:59";
        $this->db->select('sum(amount) as total');
        $this->db->from('link_request');
        $this->db->where('created_date >=', $fdate);
        $this->db->where('created_date <=', $tdate);
        $this->db->where('status', 1);
        $this->db->where('uid', $uid);
        $query = $this->db->get();
        $count_row = $query->num_rows();
        // echo $this->db->last_query(); exit;
        if ($count_row > 0) {
            return $query->row();
        } else {
            return FALSE;
        }
    }
    
    public function get_total_amount_recive($from_date,$to_date,$uid){
        $fdate = "$from_date 00:00:00";
        $tdate = "$to_date 59:59:59";
        $this->db->select('sum(settlement_amount) as total');
        $this->db->from('link_request');
        $this->db->where('settlement_datetime >=', $fdate);
        $this->db->where('settlement_datetime <=', $tdate);
        $this->db->where('satelment', 1);
        $this->db->where('uid', $uid);
        $query = $this->db->get();
        $count_row = $query->num_rows();
        if ($count_row > 0) {
            return $query->row();
        } else {
            return FALSE;
        }
    }
    
    public function getAllAgentData($fdate,$tdate,$uid){
        $this->db->select('*');
        $this->db->from('link_request');
        $this->db->where('trans_date >=', $fdate);
        $this->db->where('trans_date <=', $tdate);
        $this->db->where('uid', $uid);
        $query = $this->db->get();
        $count_row = $query->num_rows();
        if ($count_row > 0) {
            return $query->row();
        } else {
            return FALSE;
        }
    }
    
    public function update_settlement_details($update_array, $unique_request_number){
        $this->db->where('settlement_unique_no',$unique_request_number);
        return $this->db->update('link_request', $update_array);
    }
    
    public function getTransactionById($id) {
        $this->db->select('transfer_request.*, register_users.first_name,register_users.last_name,register_users.mobile_no,register_users.email')
                ->join('register_users', 'transfer_request.user_id = register_users.id', 'left');
        $this->db->from('transfer_request');        
        $this->db->where('transfer_request.id',$id);
        $q = $this->db->get();
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }
    
    public function getAgentUserBeneficaryList($id){
        $this->db->where('user_id', $id);
        $query = $this->db->get('agent_user_beneficiary');
        $count_row = $query->num_rows();
        if ($count_row > 0) {
            return $query->row();
        } else {
            return FALSE;
        }
    }
    
    public function update_agent_payee_list_data($data,$id,$uid){
        if (!empty($data)) {
            $this->db->where(['id' => $id,'user_id' => $uid]);
            return $this->db->update('payee_list_agent', $data);
            
        }
        return false;
    }
    
    public function box_value($to_date,$from_date,$agent_name){
        // $to_date=$this->input->post('to_date');
        // $from_date=$this->input->post('from_date');
        // $agent_name=$this->input->post('agent_name');
       
        $tdate = "$to_date 59:59:59";
        $fdate = "$from_date 00:00:00";
        if(isset($agent_name)){
             $agent_name = $agent_name;
         } else {
             $agent_name = "";
         }
        
         if(isset($from_date)){
             $from_date = $from_date;
         } else {
             $from_date = "";
         }
         if(isset($to_date)){
             $to_date = $to_date;
         } else {
             $to_date = "";
         }
         
         $this->db->select('sum(credit_amount) as credit_amount,sum(debit_amount) as debit_amount');
         $this->db->from('agent_wallet_history a');
          $this->db->join('register_agent b','a.agent_id=b.id');
         if($agent_name){
                $this->db->where('b.id',$agent_name);
            }
            
            if(!empty($from_date) && empty($to_date)) {
                $this->db->like('a.created_at',$from_date);
            } elseif(!empty($to_date) && empty($from_date)) {
                $this->db->like('a.created_at',$to_date);
            } elseif(!empty($from_date) && !empty($to_date)) {
                $this->db->where("a.created_at >=",$fdate);
                $this->db->where("a.created_at <=",$tdate);
            }
        
        
         $records = $this->db->get()->result();
         return $records;
    }
}
